/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.util.DefaultHref;
import org.displaytag.util.Href;
import org.displaytag.util.RequestHelper;

public class DefaultRequestHelper
implements RequestHelper {
    private static Log log = LogFactory.getLog((Class)DefaultRequestHelper.class);
    private HttpServletRequest request;
    private HttpServletResponse response;

    public DefaultRequestHelper(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.request = servletRequest;
        this.response = servletResponse;
    }

    public Href getHref() {
        String requestURI = this.request.getRequestURI();
        DefaultHref href = new DefaultHref(this.response.encodeURL(requestURI));
        href.setParameterMap(this.getParameterMap());
        return href;
    }

    public String getParameter(String key) {
        return this.request.getParameter(key);
    }

    public Integer getIntParameter(String key) {
        String value = this.request.getParameter(key);
        if (value != null) {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException e) {
                log.debug((Object)Messages.getString("RequestHelper.invalidparameter", new Object[]{key, value}));
            }
        }
        return null;
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration parametersName = this.request.getParameterNames();
        while (parametersName.hasMoreElements()) {
            String paramName = (String)parametersName.nextElement();
            String[] originalValues = (String[])ObjectUtils.defaultIfNull((Object)this.request.getParameterValues(paramName), (Object)new String[0]);
            String[] values = new String[originalValues.length];
            for (int i = 0; i < values.length; ++i) {
                try {
                    values[i] = URLEncoder.encode(StringUtils.defaultString((String)originalValues[i]), StringUtils.defaultString((String)this.response.getCharacterEncoding(), (String)"UTF8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
            map.put(paramName, values);
        }
        return map;
    }
}

