/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import javax.servlet.jsp.PageContext;
import org.displaytag.decorator.Decorator;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.TableModel;
import org.displaytag.util.LookupUtil;

public abstract class TableDecorator
extends Decorator {
    private Object currentRowObject;
    private int viewIndex = -1;
    private int listIndex = -1;
    protected TableModel tableModel;

    public final int getViewIndex() {
        return this.viewIndex;
    }

    public final int getListIndex() {
        return this.listIndex;
    }

    public final Object getCurrentRowObject() {
        return this.currentRowObject;
    }

    public void init(PageContext context, Object decorated, TableModel tableModel) {
        this.tableModel = tableModel;
        this.init(context, decorated);
    }

    public final void initRow(Object rowObject, int currentViewIndex, int currentListIndex) {
        this.currentRowObject = rowObject;
        this.viewIndex = currentViewIndex;
        this.listIndex = currentListIndex;
    }

    public String startRow() {
        return null;
    }

    public String finishRow() {
        return null;
    }

    public void finish() {
        this.currentRowObject = null;
        super.finish();
    }

    public String addRowClass() {
        return null;
    }

    public String addRowId() {
        return null;
    }

    public void startOfGroup(String value, int group) {
    }

    public void endOfGroup(String value, int groupThatHasEnded) {
    }

    public String displayGroupedValue(String cellValue, short groupingStatus) {
        if (groupingStatus == 5 || groupingStatus == 0) {
            return "";
        }
        return cellValue;
    }

    public boolean isLastRow() {
        return this.getListIndex() == this.tableModel.getRowListPage().size() - 1;
    }

    protected Object evaluate(String propertyName) {
        try {
            return LookupUtil.getBeanProperty(this.getCurrentRowObject(), propertyName);
        }
        catch (ObjectLookupException e) {
            return null;
        }
    }
}

