/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import org.apache.commons.lang.StringUtils;
import org.displaytag.export.BaseExportView;
import org.displaytag.model.TableModel;

public class CsvView
extends BaseExportView {
    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        super.setParameters(tableModel, exportFullList, includeHeader, decorateValues);
    }

    protected String getRowEnd() {
        return "\n";
    }

    protected String getCellEnd() {
        return ",";
    }

    protected boolean getAlwaysAppendCellEnd() {
        return false;
    }

    protected boolean getAlwaysAppendRowEnd() {
        return true;
    }

    public String getMimeType() {
        return "text/csv";
    }

    protected String escapeColumnValue(Object value) {
        String stringValue = StringUtils.trim((String)value.toString());
        if (!StringUtils.containsNone((String)stringValue, (char[])new char[]{'\n', ','})) {
            return "\"" + StringUtils.replace((String)stringValue, (String)"\"", (String)"\\\"") + "\"";
        }
        return stringValue;
    }
}

