/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.util.UrlPathHelper;

public class DefaultRequestToViewNameTranslator
implements RequestToViewNameTranslator {
    private static final String SLASH = "/";
    private UrlPathHelper pathHelper = new UrlPathHelper();
    private String separator = "/";
    private boolean stripExtensions = true;
    private boolean stripLeadingSlashes = true;
    private static final String DOT = ".";

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setStripExtensions(boolean stripExtensions) {
        this.stripExtensions = stripExtensions;
    }

    public void setStripLeadingSlashes(boolean stripLeadingSlashes) {
        this.stripLeadingSlashes = stripLeadingSlashes;
    }

    public void setPathHelper(UrlPathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public final String translate(HttpServletRequest request) {
        String pathInMapping = this.pathHelper.getPathWithinServletMapping(request);
        return this.transformPath(pathInMapping);
    }

    protected String transformPath(String pathInMapping) {
        String path = pathInMapping;
        if (this.stripLeadingSlashes && path.startsWith(SLASH)) {
            path = path.substring(1);
        }
        if (this.stripExtensions && path.indexOf(DOT) > -1) {
            path = path.substring(0, path.lastIndexOf(DOT));
        }
        return !SLASH.equals(this.separator) ? path : StringUtils.replace(path, SLASH, this.separator);
    }
}

