/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.aspectj;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

@Aspect
public abstract class AbstractTransactionAspect
extends TransactionAspectSupport {
    protected AbstractTransactionAspect(TransactionAttributeSource tas) {
        this.setTransactionAttributeSource(tas);
    }

    @Before(value="transactionalMethodExecution(txObject)", argNames="txObject")
    public void ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c(Object txObject, JoinPoint.StaticPart thisJoinPointStaticPart) {
        MethodSignature methodSignature = (MethodSignature)thisJoinPointStaticPart.getSignature();
        Method method = methodSignature.getMethod();
        TransactionAspectSupport.TransactionInfo txInfo = this.createTransactionIfNecessary(method, txObject.getClass());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aspect-created transaction: " + txInfo));
        }
    }

    @AfterThrowing(pointcut="transactionalMethodExecution(txObject)", throwing="t", argNames="txObject,t")
    public void ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c(Object txObject, Throwable t) {
        this.doCloseTransactionAfterThrowing(TransactionAspectSupport.currentTransactionInfo(), t);
    }

    @AfterReturning(pointcut="transactionalMethodExecution(txObject)", returning="", argNames="txObject")
    public void ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c(Object txObject) {
        this.doCommitTransactionAfterReturning(TransactionAspectSupport.currentTransactionInfo());
    }

    @After(value="transactionalMethodExecution(txObject)", argNames="txObject")
    public void ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c(Object txObject) {
        this.doFinally(TransactionAspectSupport.currentTransactionInfo());
    }

    @Pointcut(value="", argNames="txObject")
    protected abstract void ajc$pointcut$$transactionalMethodExecution$e29(Object var1);
}

