/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;

public class ResourceScriptSource
implements ScriptSource {
    private Resource resource;
    private long lastModified;

    public ResourceScriptSource(Resource resource) {
        this.resource = resource;
        this.lastModified = this.getLastModifiedTime(resource);
    }

    public InputStream getScript() throws IOException {
        this.lastModified = this.getLastModifiedTime(this.resource);
        return this.resource.getInputStream();
    }

    public boolean isModified() {
        long currentModificationTime = this.getLastModifiedTime(this.resource);
        return currentModificationTime > this.lastModified;
    }

    private long getLastModifiedTime(Resource resource) {
        try {
            File file = resource.getFile();
            return file.lastModified();
        }
        catch (IOException ex) {
            return Long.MIN_VALUE;
        }
    }
}

