/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.InterfaceMaker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.RefreshableScriptTargetSource;
import org.springframework.scripting.ResourceScriptSource;
import org.springframework.scripting.Script;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.StaticScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractScriptFactory
implements BeanNameAware,
BeanFactoryPostProcessor,
BeanPostProcessor,
ResourceLoaderAware {
    private static final String INLINE_SCRIPT_PREFIX = "inline:";
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean enableRefresh = true;
    private String ownBeanName;
    private ConfigurableListableBeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Map beanScriptSources = new HashMap();
    private Map beanInterfaces = new HashMap();
    private static final String CREATE_OBJECT = "createObject";
    static /* synthetic */ Class class$org$springframework$aop$TargetSource;
    static /* synthetic */ Class class$java$lang$Object;

    public void setEnableRefresh(boolean enableRefresh) {
        this.enableRefresh = enableRefresh;
    }

    public void setBeanName(String beanName) {
        this.ownBeanName = beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        String[] names = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < names.length; ++i) {
            RootBeanDefinition rbd;
            String name = names[i];
            BeanDefinition bd = beanFactory.getBeanDefinition(name);
            if (!(bd instanceof RootBeanDefinition) || !this.isScriptDefinition(rbd = (RootBeanDefinition)bd)) continue;
            this.logger.info((Object)("Handling createObject() method for bean name [" + name + "]"));
            rbd.getConstructorArgumentValues().addGenericArgumentValue(name);
        }
    }

    private boolean isScriptDefinition(RootBeanDefinition rbd) {
        int ctorArgCount = rbd.getConstructorArgumentValues().getArgumentCount();
        return this.ownBeanName.equals(rbd.getFactoryBeanName()) && CREATE_OBJECT.equals(rbd.getFactoryMethodName()) && (ctorArgCount == 1 || ctorArgCount == 2);
    }

    public Object createObject(String script, String beanName) throws Exception {
        return this.createObject(this.convertToScriptSource(script), null, beanName);
    }

    public Object createObject(String script, Class[] interfaces, String beanName) throws Exception {
        Assert.notNull(script, "Script location or data must be specified.");
        return this.createObject(this.convertToScriptSource(script), interfaces, beanName);
    }

    public Object createObject(ScriptSource scriptSource, String beanName) throws Exception {
        return this.createObject(scriptSource, null, beanName);
    }

    public Object createObject(ScriptSource scriptSource, Class[] interfaces, String beanName) throws Exception {
        Assert.notNull(scriptSource, "ScriptSource is required");
        Assert.notNull(beanName, "Bean name is required");
        if (this.requiresConfigInterface()) {
            Class configInterface = this.createConfigInterface(this.beanFactory.getBeanDefinition(beanName), interfaces);
            if (interfaces == null) {
                interfaces = new Class[]{configInterface};
            } else {
                ArrayList<Class> tmp = new ArrayList<Class>(Arrays.asList(interfaces));
                tmp.add(configInterface);
                interfaces = tmp.toArray(new Class[tmp.size()]);
            }
        }
        Script script = this.getScript(scriptSource, interfaces);
        this.beanScriptSources.put(beanName, scriptSource);
        this.beanInterfaces.put(beanName, interfaces);
        return script.createObject();
    }

    private ScriptSource convertToScriptSource(String script) {
        if (script.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(script.substring(INLINE_SCRIPT_PREFIX.length()));
        }
        return new ResourceScriptSource(this.resourceLoader.getResource(script));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ScriptSource scriptSource = (ScriptSource)this.beanScriptSources.get(beanName);
        if (this.enableRefresh && scriptSource != null) {
            RefreshableScriptTargetSource ts = new RefreshableScriptTargetSource((BeanFactory)this.beanFactory, beanName, scriptSource);
            DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor(ts);
            introduction.suppressInterface(class$org$springframework$aop$TargetSource == null ? (class$org$springframework$aop$TargetSource = AbstractScriptFactory.class$("org.springframework.aop.TargetSource")) : class$org$springframework$aop$TargetSource);
            Class[] interfaces = (Class[])this.beanInterfaces.get(beanName);
            if (interfaces == null) {
                interfaces = bean.getClass().getInterfaces();
            }
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setInterfaces(interfaces);
            proxyFactory.addAdvice(introduction);
            proxyFactory.setTargetSource(ts);
            return proxyFactory.getProxy();
        }
        return bean;
    }

    private Class createConfigInterface(BeanDefinition definition, Class[] interfaces) {
        InterfaceMaker maker = new InterfaceMaker();
        PropertyValue[] propertyValues = definition.getPropertyValues().getPropertyValues();
        for (int i = 0; i < propertyValues.length; ++i) {
            PropertyValue propertyValue = propertyValues[i];
            String baseName = StringUtils.capitalize(propertyValue.getName());
            String setterName = "set" + baseName;
            String getterName = "get" + baseName;
            Class propertyType = this.findPropertyType(getterName, interfaces);
            Signature signature = new Signature(setterName, Type.VOID_TYPE, new Type[]{Type.getType((Class)propertyType)});
            maker.add(signature, new Type[0]);
        }
        return maker.create();
    }

    private Class findPropertyType(String getterName, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Class iface = interfaces[i];
            Method[] methods = iface.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                if (!getterName.equals(method.getName()) || method.getParameterTypes().length != 0) continue;
                return method.getReturnType();
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AbstractScriptFactory.class$("java.lang.Object")) : class$java$lang$Object;
    }

    protected boolean requiresConfigInterface() {
        return false;
    }

    protected abstract Script getScript(ScriptSource var1, Class[] var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

