/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scripting.Script;
import org.springframework.scripting.ScriptSource;

public abstract class AbstractScript
implements Script {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ScriptSource scriptSource;

    protected AbstractScript(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object createObject() throws Exception {
        InputStream is = null;
        try {
            is = this.getScriptSource().getScript();
            Object object = this.doCreateObject(is);
            return object;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.logger.debug((Object)"Unable to close InputStream.", (Throwable)ex);
                }
            }
        }
    }

    protected ScriptSource getScriptSource() {
        return this.scriptSource;
    }

    protected abstract Object doCreateObject(InputStream var1) throws Exception;
}

