/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class EntityManagerFactoryUtils {
    public static final int ENTITY_MANAGER_SYNCHRONIZATION_ORDER = 900;
    private static final Log logger = LogFactory.getLog(EntityManagerFactoryUtils.class);

    public static EntityManager getEntityManager(EntityManagerFactory emf) throws PersistenceException, IllegalStateException {
        try {
            return EntityManagerFactoryUtils.doGetEntityManager(emf);
        }
        catch (IllegalStateException ex) {
            return emf.getEntityManager();
        }
    }

    public static EntityManager doGetEntityManager(EntityManagerFactory emf) throws PersistenceException, IllegalStateException {
        Assert.notNull(emf, "No EntityManagerFactory specified");
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(emf);
        if (emHolder != null) {
            return emHolder.getEntityManager();
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("No JPA EntityManager bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        logger.debug((Object)"Opening JPA EntityManager");
        EntityManager em = emf.createEntityManager();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for JPA EntityManager");
            emHolder = new EntityManagerHolder(em);
            emHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization(new EntityManagerSynchronization(emHolder, emf));
            TransactionSynchronizationManager.bindResource(emf, emHolder);
        }
        return em;
    }

    public static boolean isEntityManagerTransactional(EntityManager em, EntityManagerFactory emf) {
        if (emf == null) {
            return false;
        }
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(emf);
        return emHolder != null && em == emHolder.getEntityManager();
    }

    public static DataAccessException convertJpaAccessException(PersistenceException ex) {
        return new JpaSystemException(ex);
    }

    private static class EntityManagerSynchronization
    extends TransactionSynchronizationAdapter {
        private final EntityManagerHolder entityManagerHolder;
        private final EntityManagerFactory entityManagerFactory;
        private boolean holderActive = true;

        public EntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf) {
            this.entityManagerHolder = emHolder;
            this.entityManagerFactory = emf;
        }

        public int getOrder() {
            return 900;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.entityManagerFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.entityManagerFactory, this.entityManagerHolder);
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.entityManagerFactory);
            this.holderActive = false;
            this.entityManagerHolder.getEntityManager().close();
        }
    }
}

