/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target.dynamic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.target.dynamic.Refreshable;

public abstract class AbstractRefreshableTargetSource
implements TargetSource,
Refreshable {
    public static final int REFRESH_CHECK_NEVER = -1;
    public static final int REFRESH_CHECK_ALWAYS = 0;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Object targetObject;
    private long lastRefreshCheck = System.currentTimeMillis();
    private long refreshCheckDelay = -1L;
    private long lastRefreshTime;
    private long refreshCount;

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    public void setRefreshCheckDelay(long refreshCheckDelay) {
        this.refreshCheckDelay = refreshCheckDelay;
    }

    public Class getTargetClass() {
        return this.targetObject == null ? null : this.targetObject.getClass();
    }

    public boolean isStatic() {
        return false;
    }

    public final synchronized Object getTarget() throws Exception {
        if (this.targetObject == null || this.refreshCheckDelayElapsed() && this.requiresRefresh()) {
            this.refresh();
        }
        return this.targetObject;
    }

    public void releaseTarget(Object object) throws Exception {
    }

    public final synchronized void refresh() {
        this.logger.debug((Object)"Attempting to refresh target.");
        ++this.refreshCount;
        this.lastRefreshTime = System.currentTimeMillis();
        this.targetObject = this.freshTarget();
        this.logger.debug((Object)"Target refreshed successfully.");
    }

    private boolean refreshCheckDelayElapsed() {
        boolean elapsed;
        if (this.refreshCheckDelay == -1L) {
            return false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        boolean bl = elapsed = currentTimeMillis - this.lastRefreshCheck > this.refreshCheckDelay;
        if (elapsed) {
            this.logger.debug((Object)"Refresh check delay elapsed - will check if refresh is necessary.");
            this.lastRefreshCheck = currentTimeMillis;
        }
        return elapsed;
    }

    protected boolean requiresRefresh() {
        return false;
    }

    protected abstract Object freshTarget();
}

