/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;

public class SimpleMRUCache
implements Serializable {
    private static final int MAX_STRONG_REF_COUNT = 128;
    private final transient Object[] strongRefs = new Object[128];
    private transient int strongRefIndex = 0;
    private final transient Map softQueryCache = new ReferenceMap(1, 1);

    public synchronized Object get(Object key) {
        Object result = this.softQueryCache.get(key);
        if (result != null) {
            this.strongRefs[++this.strongRefIndex % 128] = result;
        }
        return result;
    }

    public void put(Object key, Object value) {
        this.softQueryCache.put(key, value);
        this.strongRefs[++this.strongRefIndex % 128] = value;
    }
}

