/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.hql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.impl.IteratorImpl;
import org.hibernate.loader.BasicLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class QueryLoader
extends BasicLoader {
    private QueryTranslator queryTranslator;
    private Queryable[] entityPersisters;
    private String[] entityAliases;
    private String[] sqlAliases;
    private String[] sqlAliasSuffixes;
    private boolean[] includeInSelect;
    private String[] collectionSuffixes;
    private boolean hasScalars;
    private String[][] scalarColumnNames;
    private Type[] queryReturnTypes;
    private final Map sqlAliasByEntityAlias = new HashMap(8);
    private EntityType[] ownerAssociationTypes;
    private int[] owners;
    private boolean[] entityEagerPropertyFetches;
    private int[] collectionOwners;
    private QueryableCollection[] collectionPersisters;
    private int selectLength;
    private HolderInstantiator holderInstantiator;
    private LockMode[] defaultLockModes;

    public QueryLoader(QueryTranslator queryTranslator, SessionFactoryImplementor factory, SelectClause selectClause) {
        super(factory);
        this.queryTranslator = queryTranslator;
        this.initialize(selectClause);
        this.postInstantiate();
    }

    private void initialize(SelectClause selectClause) {
        int i;
        List fromElementList = selectClause.getFromElementsForLoad();
        this.hasScalars = selectClause.isScalarSelect();
        this.scalarColumnNames = selectClause.getColumnNames();
        this.queryReturnTypes = selectClause.getQueryReturnTypes();
        this.holderInstantiator = new HolderInstantiator(selectClause.getConstructor(), selectClause.isMap(), selectClause.isList(), selectClause.getQueryReturnAliases());
        List collectionFromElements = selectClause.getCollectionFromElements();
        if (collectionFromElements != null && collectionFromElements.size() != 0) {
            int length = collectionFromElements.size();
            this.collectionPersisters = new QueryableCollection[length];
            this.collectionOwners = new int[length];
            this.collectionSuffixes = new String[length];
            for (i = 0; i < length; ++i) {
                FromElement collectionFromElement = (FromElement)collectionFromElements.get(i);
                this.collectionPersisters[i] = collectionFromElement.getQueryableCollection();
                this.collectionOwners[i] = fromElementList.indexOf(collectionFromElement.getOrigin());
                this.collectionSuffixes[i] = collectionFromElement.getCollectionSuffix();
            }
        }
        int size = fromElementList.size();
        this.entityPersisters = new Queryable[size];
        this.entityEagerPropertyFetches = new boolean[size];
        this.entityAliases = new String[size];
        this.sqlAliases = new String[size];
        this.sqlAliasSuffixes = new String[size];
        this.includeInSelect = new boolean[size];
        this.owners = new int[size];
        this.ownerAssociationTypes = new EntityType[size];
        for (i = 0; i < size; ++i) {
            FromElement element = (FromElement)fromElementList.get(i);
            this.entityPersisters[i] = (Queryable)element.getEntityPersister();
            if (this.entityPersisters[i] == null) {
                throw new IllegalStateException("No entity persister for " + element.toString());
            }
            this.entityEagerPropertyFetches[i] = element.isAllPropertyFetch();
            this.sqlAliases[i] = element.getTableAlias();
            this.entityAliases[i] = element.getClassAlias();
            this.sqlAliasByEntityAlias.put(this.entityAliases[i], this.sqlAliases[i]);
            this.sqlAliasSuffixes[i] = size == 1 ? "" : Integer.toString(i) + "_";
            boolean bl = this.includeInSelect[i] = !element.isFetch();
            if (this.includeInSelect[i]) {
                ++this.selectLength;
            }
            this.owners[i] = -1;
            if (!element.isFetch() || element.isCollectionJoin() || element.getQueryableCollection() != null || !element.getDataType().isEntityType()) continue;
            EntityType entityType = (EntityType)element.getDataType();
            if (entityType.isOneToOne()) {
                this.owners[i] = fromElementList.indexOf(element.getOrigin());
            }
            this.ownerAssociationTypes[i] = entityType;
        }
        this.defaultLockModes = ArrayHelper.fillArray(LockMode.NONE, size);
    }

    public final void validateScrollability() throws HibernateException {
        this.queryTranslator.validateScrollability();
    }

    protected boolean needsFetchingScroll() {
        return this.queryTranslator.containsCollectionFetches();
    }

    public Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    public String[] getAliases() {
        return this.sqlAliases;
    }

    public String[] getSqlAliasSuffixes() {
        return this.sqlAliasSuffixes;
    }

    public String[] getSuffixes() {
        return this.getSqlAliasSuffixes();
    }

    public String[] getCollectionSuffixes() {
        return this.collectionSuffixes;
    }

    protected String getQueryIdentifier() {
        return this.queryTranslator.getQueryString();
    }

    protected String getSQLString() {
        return this.queryTranslator.getSQLString();
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    protected boolean[] getEntityEagerPropertyFetches() {
        return this.entityEagerPropertyFetches;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    protected LockMode[] getLockModes(Map lockModes) {
        if (lockModes == null || lockModes.size() == 0) {
            return this.defaultLockModes;
        }
        LockMode[] lockModeArray = new LockMode[this.entityAliases.length];
        for (int i = 0; i < this.entityAliases.length; ++i) {
            LockMode lockMode = (LockMode)lockModes.get(this.entityAliases[i]);
            if (lockMode == null) {
                lockMode = LockMode.NONE;
            }
            lockModeArray[i] = lockMode;
        }
        return lockModeArray;
    }

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sql;
        }
        HashMap aliasedLockModes = new HashMap();
        Iterator iter = lockModes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            String userAlias = (String)me.getKey();
            String sqlAlias = (String)this.sqlAliasByEntityAlias.get(userAlias);
            if (sqlAlias == null) {
                throw new IllegalArgumentException("alias not found: " + userAlias);
            }
            aliasedLockModes.put(sqlAlias, me.getValue());
        }
        HashMap<String, String[]> keyColumnNames = null;
        if (dialect.forUpdateOfColumns()) {
            Loadable[] persisters = this.getEntityPersisters();
            keyColumnNames = new HashMap<String, String[]>();
            for (int i = 0; i < this.sqlAliases.length; ++i) {
                keyColumnNames.put(this.sqlAliases[i], persisters[i].getIdentifierColumnNames());
            }
        }
        return sql + new ForUpdateFragment(dialect, aliasedLockModes, keyColumnNames).toFragmentString();
    }

    protected boolean upgradeLocks() {
        return true;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        row = this.toResultRow(row);
        boolean isHolder = this.holderInstantiator.isRequired();
        if (this.hasScalars) {
            String[][] scalarColumns = this.scalarColumnNames;
            int queryCols = this.queryReturnTypes.length;
            if (!isHolder && queryCols == 1) {
                return this.queryReturnTypes[0].nullSafeGet(rs, scalarColumns[0], session, null);
            }
            row = new Object[queryCols];
            for (int i = 0; i < queryCols; ++i) {
                row[i] = this.queryReturnTypes[i].nullSafeGet(rs, scalarColumns[i], session, null);
            }
            return row;
        }
        if (!isHolder) {
            return row.length == 1 ? row[0] : row;
        }
        return row;
    }

    protected List getResultList(List results) throws QueryException {
        if (this.holderInstantiator.isRequired()) {
            for (int i = 0; i < results.size(); ++i) {
                Object[] row = (Object[])results.get(i);
                Object result = this.holderInstantiator.instantiate(row);
                results.set(i, result);
            }
        }
        return results;
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.queryTranslator.getQuerySpaces(), this.queryReturnTypes);
    }

    public Iterator iterate(QueryParameters queryParameters, EventSource session) throws HibernateException {
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            PreparedStatement st = this.prepareQueryStatement(queryParameters, false, session);
            if (queryParameters.isCallable()) {
                throw new QueryException("iterate() not supported for callable statements");
            }
            ResultSet rs = this.getResultSet(st, queryParameters.hasAutoDiscoverScalarTypes(), false, queryParameters.getRowSelection(), session);
            IteratorImpl result = new IteratorImpl(rs, st, session, this.queryReturnTypes, this.queryTranslator.getColumnNames(), this.holderInstantiator);
            if (stats) {
                session.getFactory().getStatisticsImplementor().queryExecuted("HQL: " + this.queryTranslator.getQueryString(), 0, System.currentTimeMillis() - startTime);
            }
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not execute query using iterate", this.getSQLString());
        }
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.queryReturnTypes, this.holderInstantiator, session);
    }

    private Object[] toResultRow(Object[] row) {
        if (this.selectLength == row.length) {
            return row;
        }
        Object[] result = new Object[this.selectLength];
        int j = 0;
        for (int i = 0; i < row.length; ++i) {
            if (!this.includeInSelect[i]) continue;
            result[j++] = row[i];
        }
        return result;
    }

    public int[] getNamedParameterLocs(String name) throws QueryException {
        return this.queryTranslator.getParameterTranslations().getNamedParameterSqlLocations(name);
    }
}

