/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.ParameterBinder;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.antlr.HqlSqlBaseWalker;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.ErrorReporter;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.SqlASTFactory;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.tree.AssignmentSpecification;
import org.hibernate.hql.ast.tree.CollectionFunction;
import org.hibernate.hql.ast.tree.ConstructorNode;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.tree.IndexNode;
import org.hibernate.hql.ast.tree.InsertStatement;
import org.hibernate.hql.ast.tree.IntoClause;
import org.hibernate.hql.ast.tree.MethodNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.OperatorNode;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.ResolvableNode;
import org.hibernate.hql.ast.tree.RestrictableStatement;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.UpdateStatement;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.AliasGenerator;
import org.hibernate.hql.ast.util.JoinProcessor;
import org.hibernate.hql.ast.util.LiteralProcessor;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.hql.ast.util.SyntheticAndFactory;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.param.NamedParameterSpecification;
import org.hibernate.param.PositionalParameterSpecification;
import org.hibernate.param.VersionTypeSeedParameterSpecification;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.DbTimestampType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.usertype.UserVersionType;
import org.hibernate.util.ArrayHelper;

public class HqlSqlWalker
extends HqlSqlBaseWalker
implements ErrorReporter,
ParameterBinder.NamedParameterSource {
    private static Log log = LogFactory.getLog((Class)HqlSqlWalker.class);
    private SessionFactoryHelper sessionFactoryHelper;
    private LiteralProcessor literalProcessor;
    private ParseErrorHandler parseErrorHandler;
    private FromClause currentFromClause = null;
    private SelectClause selectClause;
    private AliasGenerator aliasGenerator = new AliasGenerator();
    private Set querySpaces = new HashSet();
    private Map tokenReplacements;
    private QueryTranslatorImpl queryTranslatorImpl;
    private int parameterCount;
    private Map namedParameters = new HashMap();
    private String filterCollectionRole;
    private HqlParser hqlParser;
    private ASTPrinter printer;
    private int impliedJoinType;
    private ArrayList parameters = new ArrayList();
    private int numberOfParametersInSetClause;
    private int positionalParameterCount;
    private ArrayList assignmentSpecifications = new ArrayList();

    public HqlSqlWalker(QueryTranslatorImpl qti, SessionFactoryImplementor sfi, HqlParser parser, Map tokenReplacements, String collectionRole) {
        this.setASTFactory(new SqlASTFactory(this));
        this.parseErrorHandler = new ErrorCounter();
        this.queryTranslatorImpl = qti;
        this.sessionFactoryHelper = new SessionFactoryHelper(sfi);
        this.literalProcessor = new LiteralProcessor(this);
        this.tokenReplacements = tokenReplacements;
        this.filterCollectionRole = collectionRole;
        this.hqlParser = parser;
        this.printer = new ASTPrinter(SqlTokenTypes.class);
    }

    protected void prepareFromClauseInputTree(AST fromClauseInput) {
        if (this.isFilter() && !this.isSubQuery()) {
            QueryableCollection persister = this.sessionFactoryHelper.getCollectionPersister(this.filterCollectionRole);
            Type collectionElementType = persister.getElementType();
            if (!collectionElementType.isEntityType()) {
                throw new QueryException("collection of values in filter: this");
            }
            String collectionElementEntityName = persister.getElementPersister().getEntityName();
            ASTFactory inputAstFactory = this.hqlParser.getASTFactory();
            AST fromElement = ASTUtil.create(inputAstFactory, 73, collectionElementEntityName);
            ASTUtil.createSibling(inputAstFactory, 69, "this", fromElement);
            fromClauseInput.addChild(fromElement);
            if (log.isDebugEnabled()) {
                log.debug((Object)"prepareFromClauseInputTree() : Filter - Added 'this' as a from element...");
            }
            this.queryTranslatorImpl.showHqlAst(this.hqlParser.getAST());
        }
    }

    private boolean isFilter() {
        return this.filterCollectionRole != null;
    }

    public SessionFactoryHelper getSessionFactoryHelper() {
        return this.sessionFactoryHelper;
    }

    public Map getTokenReplacements() {
        return this.tokenReplacements;
    }

    public AliasGenerator getAliasGenerator() {
        return this.aliasGenerator;
    }

    public FromClause getCurrentFromClause() {
        return this.currentFromClause;
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public void reportError(RecognitionException e) {
        this.parseErrorHandler.reportError(e);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected AST createFromElement(String path, AST alias, AST propertyFetch) throws SemanticException {
        FromElement fromElement = this.currentFromClause.addFromElement(path, alias);
        fromElement.setAllPropertyFetch(propertyFetch != null);
        return fromElement;
    }

    protected AST createFromFilterElement(AST filterEntity, AST alias) throws SemanticException {
        FromElement fromElement = this.currentFromClause.addFromElement(filterEntity.getText(), alias);
        FromClause fromClause = fromElement.getFromClause();
        QueryableCollection persister = this.sessionFactoryHelper.getCollectionPersister(this.filterCollectionRole);
        String[] keyColumnNames = persister.getKeyColumnNames();
        String fkTableAlias = persister.isOneToMany() ? fromElement.getTableAlias() : fromClause.getAliasGenerator().createName(this.filterCollectionRole);
        JoinSequence join = this.sessionFactoryHelper.createJoinSequence();
        join.setRoot(persister, fkTableAlias);
        if (!persister.isOneToMany()) {
            join.addJoin((AssociationType)persister.getElementType(), fromElement.getTableAlias(), 0, persister.getElementColumnNames(fkTableAlias));
        }
        join.addCondition(fkTableAlias, keyColumnNames, " = ?");
        fromElement.setJoinSequence(join);
        fromElement.setFilter(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"createFromFilterElement() : processed filter FROM element.");
        }
        return fromElement;
    }

    protected void createFromJoinElement(AST path, AST alias, int joinType, AST fetchNode, AST propertyFetch, AST with) throws SemanticException {
        boolean fetch;
        boolean bl = fetch = fetchNode != null;
        if (path.getType() != 15) {
            throw new SemanticException("Path expected for join!");
        }
        DotNode dot = (DotNode)path;
        int hibernateJoinType = JoinProcessor.toHibernateJoinType(joinType);
        dot.setJoinType(hibernateJoinType);
        dot.setFetch(fetch);
        dot.resolve(true, false, alias == null ? null : alias.getText());
        FromElement fromElement = dot.getImpliedJoin();
        fromElement.setAllPropertyFetch(propertyFetch != null);
        if (with != null) {
            if (fetch) {
                throw new SemanticException("with-clause not allowed on fetched associations; use filters");
            }
            this.handleWithFragment(fromElement, with);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("createFromJoinElement() : " + this.getASTPrinter().showAsString((AST)fromElement, "-- join tree --")));
        }
    }

    private void handleWithFragment(FromElement fromElement, AST hqlWithNode) throws SemanticException {
        try {
            this.withClause(hqlWithNode);
            AST hqlSqlWithNode = this.returnAST;
            SqlGenerator sql = new SqlGenerator(this.getSessionFactoryHelper().getFactory());
            sql.whereExpr(hqlSqlWithNode.getFirstChild());
            fromElement.setAdHocOnClauseFragment("(" + sql.getSQL() + ")");
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage());
        }
    }

    protected void pushFromClause(AST fromNode, AST inputFromNode) {
        FromClause newFromClause = (FromClause)fromNode;
        newFromClause.setParentFromClause(this.currentFromClause);
        this.currentFromClause = newFromClause;
    }

    private void popFromClause() {
        this.currentFromClause = this.currentFromClause.getParentFromClause();
    }

    protected void lookupAlias(AST aliasRef) throws SemanticException {
        FromElement alias = this.currentFromClause.getFromElement(aliasRef.getText());
        FromReferenceNode aliasRefNode = (FromReferenceNode)aliasRef;
        aliasRefNode.setFromElement(alias);
    }

    protected void setImpliedJoinType(int joinType) {
        this.impliedJoinType = JoinProcessor.toHibernateJoinType(joinType);
    }

    public int getImpliedJoinType() {
        return this.impliedJoinType;
    }

    protected AST lookupProperty(AST dot, boolean root, boolean inSelect) throws SemanticException {
        DotNode dotNode = (DotNode)dot;
        FromReferenceNode lhs = dotNode.getLhs();
        AST rhs = lhs.getNextSibling();
        switch (rhs.getType()) {
            case 17: 
            case 27: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("lookupProperty() " + dotNode.getPath() + " => " + rhs.getText() + "(" + lhs.getPath() + ")"));
                }
                CollectionFunction f = (CollectionFunction)rhs;
                f.setFirstChild((AST)lhs);
                lhs.setNextSibling(null);
                dotNode.setFirstChild((AST)f);
                this.resolve((AST)lhs);
                f.resolve(inSelect);
                return f;
            }
        }
        dotNode.resolveFirstChild();
        return dotNode;
    }

    protected boolean isNonQualifiedPropertyRef(AST ident) {
        String identText = ident.getText();
        if (this.currentFromClause.isFromElementAlias(identText)) {
            return false;
        }
        List fromElements = this.currentFromClause.getExplicitFromElements();
        if (fromElements.size() == 1) {
            FromElement fromElement = (FromElement)fromElements.get(0);
            try {
                log.trace((Object)("attempting to resolve property [" + identText + "] as a non-qualified ref"));
                return fromElement.getPropertyMapping(identText).toType(identText) != null;
            }
            catch (QueryException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected AST lookupNonQualifiedProperty(AST property) throws SemanticException {
        FromElement fromElement = (FromElement)this.currentFromClause.getExplicitFromElements().get(0);
        AST syntheticDotNode = this.generateSyntheticDotNodeForNonQualifiedPropertyRef(property, fromElement);
        return this.lookupProperty(syntheticDotNode, false, this.getCurrentClauseType() == 45);
    }

    private AST generateSyntheticDotNodeForNonQualifiedPropertyRef(AST property, FromElement fromElement) {
        AST dot = this.getASTFactory().create(15, "{non-qualified-property-ref}");
        ((DotNode)dot).setPropertyPath(((FromReferenceNode)property).getPath());
        IdentNode syntheticAlias = (IdentNode)this.getASTFactory().create(119, "{synthetic-alias}");
        syntheticAlias.setFromElement(fromElement);
        syntheticAlias.setResolved();
        dot.setFirstChild((AST)syntheticAlias);
        dot.addChild(property);
        return dot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQuery(AST select, AST query) throws SemanticException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processQuery() : " + query.toStringTree()));
        }
        try {
            boolean explicitSelect;
            QueryNode qn = (QueryNode)query;
            boolean bl = explicitSelect = select != null && select.getNumberOfChildren() > 0;
            if (!explicitSelect) {
                this.createSelectClauseFromFromClause(qn);
            } else {
                this.useSelectClause(select);
            }
            JoinProcessor joinProcessor = new JoinProcessor(this.astFactory, this.queryTranslatorImpl);
            joinProcessor.processJoins(qn, this.isSubQuery());
            Iterator itr = qn.getFromClause().getProjectionList().iterator();
            while (itr.hasNext()) {
                FromElement fromElement = (FromElement)itr.next();
                if (!fromElement.isFetch() || fromElement.getQueryableCollection() == null || !fromElement.getQueryableCollection().hasOrdering()) continue;
                String orderByFragment = fromElement.getQueryableCollection().getSQLOrderByString(fromElement.getCollectionTableAlias());
                qn.getOrderByClause().addOrderFragment(orderByFragment);
            }
        }
        finally {
            this.popFromClause();
        }
    }

    protected void postProcessDML(RestrictableStatement statement) throws SemanticException {
        statement.getFromClause().resolve();
        FromElement fromElement = (FromElement)statement.getFromClause().getFromElements().get(0);
        Queryable persister = fromElement.getQueryable();
        fromElement.setText(persister.getTableName());
        if (persister.getDiscriminatorType() != null) {
            new SyntheticAndFactory(this.getASTFactory()).addDiscriminatorWhereFragment(statement, persister, Collections.EMPTY_MAP, fromElement.getTableAlias());
        }
    }

    protected void postProcessUpdate(AST update) throws SemanticException {
        UpdateStatement updateStatement = (UpdateStatement)update;
        this.postProcessDML(updateStatement);
    }

    protected void postProcessDelete(AST delete) throws SemanticException {
        this.postProcessDML((DeleteStatement)delete);
    }

    public static boolean supportsIdGenWithBulkInsertion(IdentifierGenerator generator) {
        return SequenceGenerator.class.isAssignableFrom(generator.getClass()) || PostInsertIdentifierGenerator.class.isAssignableFrom(generator.getClass());
    }

    protected void postProcessInsert(AST insert) throws SemanticException, QueryException {
        boolean includeVersionProperty;
        InsertStatement insertStatement = (InsertStatement)insert;
        insertStatement.validate();
        SelectClause selectClause = insertStatement.getSelectClause();
        Queryable persister = insertStatement.getIntoClause().getQueryable();
        if (!insertStatement.getIntoClause().isExplicitIdInsertion()) {
            IdentifierGenerator generator = persister.getIdentifierGenerator();
            if (!HqlSqlWalker.supportsIdGenWithBulkInsertion(generator)) {
                throw new QueryException("can only generate ids as part of bulk insert with either sequence or post-insert style generators");
            }
            AST idSelectExprNode = null;
            if (SequenceGenerator.class.isAssignableFrom(generator.getClass())) {
                String seqName = (String)((SequenceGenerator)generator).generatorKey();
                String nextval = this.sessionFactoryHelper.getFactory().getDialect().getSelectSequenceNextValString(seqName);
                idSelectExprNode = this.getASTFactory().create(135, nextval);
            }
            if (idSelectExprNode != null) {
                AST currentFirstSelectExprNode = selectClause.getFirstChild();
                selectClause.setFirstChild(idSelectExprNode);
                idSelectExprNode.setNextSibling(currentFirstSelectExprNode);
                insertStatement.getIntoClause().prependIdColumnSpec();
            }
        }
        boolean bl = includeVersionProperty = persister.isVersioned() && !insertStatement.getIntoClause().isExplicitVersionInsertion() && persister.isVersionPropertyInsertable();
        if (includeVersionProperty) {
            VersionType versionType = persister.getVersionType();
            AST versionValueNode = null;
            if (this.sessionFactoryHelper.getFactory().getDialect().supportsParametersInInsertSelect()) {
                versionValueNode = this.getASTFactory().create(116, "?");
                VersionTypeSeedParameterSpecification paramSpec = new VersionTypeSeedParameterSpecification(versionType);
                ((ParameterNode)versionValueNode).setHqlParameterSpecification(paramSpec);
                this.parameters.add(0, paramSpec);
            } else if (this.isIntegral(versionType)) {
                try {
                    Object seedValue = versionType.seed(null);
                    versionValueNode = this.getASTFactory().create(135, seedValue.toString());
                }
                catch (Throwable t) {
                    throw new QueryException("could not determine seed value for version on bulk insert [" + versionType + "]");
                }
            } else if (this.isDatabaseGeneratedTimestamp(versionType)) {
                String functionName = this.sessionFactoryHelper.getFactory().getDialect().getCurrentTimestampSQLFunctionName();
                versionValueNode = this.getASTFactory().create(135, functionName);
            } else {
                throw new QueryException("cannot handle version type [" + versionType + "] on bulk inserts with dialects not supporting parameters in insert-select statements");
            }
            AST currentFirstSelectExprNode = selectClause.getFirstChild();
            selectClause.setFirstChild(versionValueNode);
            versionValueNode.setNextSibling(currentFirstSelectExprNode);
            insertStatement.getIntoClause().prependVersionColumnSpec();
        }
        if (insertStatement.getIntoClause().isDiscriminated()) {
            String sqlValue = insertStatement.getIntoClause().getQueryable().getDiscriminatorSQLValue();
            AST discrimValue = this.getASTFactory().create(135, sqlValue);
            insertStatement.getSelectClause().addChild(discrimValue);
        }
    }

    private boolean isDatabaseGeneratedTimestamp(Type type) {
        return DbTimestampType.class.isAssignableFrom(type.getClass());
    }

    private boolean isIntegral(Type type) {
        return Long.class.isAssignableFrom(type.getReturnedClass()) || Integer.class.isAssignableFrom(type.getReturnedClass()) || Long.TYPE.isAssignableFrom(type.getReturnedClass()) || Integer.TYPE.isAssignableFrom(type.getReturnedClass());
    }

    private void useSelectClause(AST select) throws SemanticException {
        this.selectClause = (SelectClause)select;
        this.selectClause.initializeExplicitSelectClause(this.currentFromClause);
    }

    private void createSelectClauseFromFromClause(QueryNode qn) throws SemanticException {
        AST select = this.astFactory.create(130, "{derived select clause}");
        FromClause sibling = qn.getFromClause();
        qn.setFirstChild(select);
        select.setNextSibling((AST)sibling);
        this.selectClause = (SelectClause)select;
        this.selectClause.initializeDerivedSelectClause(this.currentFromClause);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Derived SELECT clause created.");
        }
    }

    protected void resolve(AST node) throws SemanticException {
        if (node != null) {
            ResolvableNode r = (ResolvableNode)node;
            if (this.isInFunctionCall()) {
                r.resolveInFunctionCall(false, true);
            } else {
                r.resolve(false, true);
            }
        }
    }

    protected void resolveSelectExpression(AST node) throws SemanticException {
        int type = node.getType();
        switch (type) {
            case 15: {
                DotNode dot = (DotNode)node;
                dot.resolveSelectExpression();
                break;
            }
            case 133: {
                FromReferenceNode aliasRefNode = (FromReferenceNode)node;
                aliasRefNode.resolve(false, false);
                FromElement fromElement = aliasRefNode.getFromElement();
                if (fromElement == null) break;
                fromElement.setIncludeSubclasses(true);
            }
        }
    }

    protected void beforeSelectClause() throws SemanticException {
        FromClause from = this.getCurrentFromClause();
        List fromElements = from.getFromElements();
        Iterator iterator = fromElements.iterator();
        while (iterator.hasNext()) {
            FromElement fromElement = (FromElement)iterator.next();
            fromElement.setIncludeSubclasses(false);
        }
    }

    protected AST generatePositionalParameter(AST inputNode) throws SemanticException {
        if (this.namedParameters.size() > 0) {
            throw new SemanticException("cannot define positional parameter after any named parameters have been defined");
        }
        ParameterNode parameter = (ParameterNode)this.astFactory.create(116, "?");
        PositionalParameterSpecification paramSpec = new PositionalParameterSpecification(((Node)inputNode).getLine(), ((Node)inputNode).getColumn(), this.positionalParameterCount++);
        parameter.setHqlParameterSpecification(paramSpec);
        this.parameters.add(paramSpec);
        return parameter;
    }

    protected AST generateNamedParameter(AST delimiterNode, AST nameNode) throws SemanticException {
        String name = nameNode.getText();
        this.trackNamedParameterPositions(name);
        ParameterNode parameter = (ParameterNode)this.astFactory.create(141, name);
        parameter.setText("?");
        NamedParameterSpecification paramSpec = new NamedParameterSpecification(((Node)delimiterNode).getLine(), ((Node)delimiterNode).getColumn(), name);
        parameter.setHqlParameterSpecification(paramSpec);
        this.parameters.add(paramSpec);
        return parameter;
    }

    private void trackNamedParameterPositions(String name) {
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((ArrayList)o).add(loc);
        }
    }

    protected void processConstant(AST constant) throws SemanticException {
        this.literalProcessor.processConstant(constant, true);
    }

    protected void processBoolean(AST constant) throws SemanticException {
        this.literalProcessor.processBoolean(constant);
    }

    protected void processIndex(AST indexOp) throws SemanticException {
        IndexNode indexNode = (IndexNode)indexOp;
        indexNode.resolve(true, true);
    }

    protected void processFunction(AST functionCall, boolean inSelect) throws SemanticException {
        MethodNode methodNode = (MethodNode)functionCall;
        methodNode.resolve(inSelect);
    }

    protected void processConstructor(AST constructor) throws SemanticException {
        ConstructorNode constructorNode = (ConstructorNode)constructor;
        constructorNode.prepare();
    }

    protected void setAlias(AST selectExpr, AST ident) {
        ((SelectExpression)selectExpr).setAlias(ident.getText());
    }

    public int[] getNamedParameterLocations(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name);
            qe.setQueryString(this.queryTranslatorImpl.getQueryString());
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((ArrayList)o);
    }

    public void addQuerySpaces(Serializable[] spaces) {
        for (int i = 0; i < spaces.length; ++i) {
            this.querySpaces.add(spaces[i]);
        }
    }

    public Type[] getReturnTypes() {
        return this.selectClause.getQueryReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.selectClause.getQueryReturnAliases();
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public FromClause getFinalFromClause() {
        return this.currentFromClause;
    }

    public boolean isShallowQuery() {
        return this.queryTranslatorImpl.isShallowQuery();
    }

    public Map getEnabledFilters() {
        return this.queryTranslatorImpl.getEnabledFilters();
    }

    public LiteralProcessor getLiteralProcessor() {
        return this.literalProcessor;
    }

    public ASTPrinter getASTPrinter() {
        return this.printer;
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    public int getNumberOfParametersInSetClause() {
        return this.numberOfParametersInSetClause;
    }

    protected void evaluateAssignment(AST eq) throws SemanticException {
        Queryable persister = this.getCurrentFromClause().getFromElement().getQueryable();
        this.evaluateAssignment(eq, persister, -1);
    }

    private void evaluateAssignment(AST eq, Queryable persister, int targetIndex) {
        if (persister.isMultiTable()) {
            AssignmentSpecification specification = new AssignmentSpecification(eq, persister);
            if (targetIndex >= 0) {
                this.assignmentSpecifications.add(targetIndex, specification);
            } else {
                this.assignmentSpecifications.add(specification);
            }
            this.numberOfParametersInSetClause += specification.getParameters().length;
        }
    }

    public ArrayList getAssignmentSpecifications() {
        return this.assignmentSpecifications;
    }

    protected AST createIntoClause(String path, AST propertySpec) throws SemanticException {
        Queryable persister = (Queryable)this.getSessionFactoryHelper().requireClassPersister(path);
        IntoClause intoClause = (IntoClause)this.getASTFactory().create(30, persister.getEntityName());
        intoClause.setFirstChild(propertySpec);
        intoClause.initialize(persister);
        this.addQuerySpaces(persister.getQuerySpaces());
        return intoClause;
    }

    protected void prepareVersioned(AST updateNode, AST versioned) throws SemanticException {
        UpdateStatement updateStatement = (UpdateStatement)updateNode;
        FromClause fromClause = updateStatement.getFromClause();
        if (versioned != null) {
            Queryable persister = fromClause.getFromElement().getQueryable();
            if (!persister.isVersioned()) {
                throw new SemanticException("increment option specified for update of non-versioned entity");
            }
            VersionType versionType = persister.getVersionType();
            if (versionType instanceof UserVersionType) {
                throw new SemanticException("user-defined version types not supported for increment option");
            }
            AST eq = this.getASTFactory().create(96, "=");
            AST versionPropertyNode = this.generateVersionPropertyNode(persister);
            eq.setFirstChild(versionPropertyNode);
            AST versionIncrementNode = null;
            if (Date.class.isAssignableFrom(versionType.getReturnedClass())) {
                versionIncrementNode = this.getASTFactory().create(116, "?");
                VersionTypeSeedParameterSpecification paramSpec = new VersionTypeSeedParameterSpecification(versionType);
                ((ParameterNode)versionIncrementNode).setHqlParameterSpecification(paramSpec);
                this.parameters.add(0, paramSpec);
            } else {
                versionIncrementNode = this.getASTFactory().create(109, "+");
                versionIncrementNode.setFirstChild(this.generateVersionPropertyNode(persister));
                versionIncrementNode.addChild(this.getASTFactory().create(119, "1"));
            }
            eq.addChild(versionIncrementNode);
            this.evaluateAssignment(eq, persister, 0);
            AST setClause = updateStatement.getSetClause();
            AST currentFirstSetElement = setClause.getFirstChild();
            setClause.setFirstChild(eq);
            eq.setNextSibling(currentFirstSetElement);
        }
    }

    private AST generateVersionPropertyNode(Queryable persister) throws SemanticException {
        String versionPropertyName = persister.getPropertyNames()[persister.getVersionProperty()];
        AST versionPropertyRef = this.getASTFactory().create(119, versionPropertyName);
        AST versionPropertyNode = this.lookupNonQualifiedProperty(versionPropertyRef);
        this.resolve(versionPropertyNode);
        return versionPropertyNode;
    }

    protected void prepareLogicOperator(AST operator) throws SemanticException {
        ((OperatorNode)operator).initialize();
    }

    protected void prepareArithmeticOperator(AST operator) throws SemanticException {
        ((OperatorNode)operator).initialize();
    }

    public static void panic() {
        throw new QueryException("TreeWalker: panic");
    }
}

