//*** Klasa Rectangle

package janb.view;

import java.awt.*;

public
class Rectangle 
    extends Figure {
       
    public Rectangle(int x, int y, int w, int h, Graphics gDC)
    {
        super(x, y, w, h, gDC);
    }
    
    public Rectangle(int x, int y, int w, int h)
    {
        this(x, y, w, h, null);    
    }
    
    public Rectangle(int x, int y, int d, Graphics gDC)
    {
        this(x, y, d, d, gDC);
    }    
    
    public Rectangle(int x, int y, int s)
    {
        this(x, y, s, s, null);
    }
       
    public Rectangle(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        Stroke oldStroke = gDC.getStroke();
        gDC.setStroke(getStroke());
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();
        int what = 0;
        switch(what = getFill()) {
            case Thin:    // Thin
                gDC.setStroke(Stroke_1);
                gDC.drawRect(x, y, w-1, h-1);
                break;            
            case Line:    // Line
                setGradient(gDC, x, y, w, h);            
                gDC.drawRect(x, y, w-1, h-1);
                // break;    (sic!)
            case Ring:    // Ring     
                setGradient(gDC, x, y, w, h);
                BasicStroke basicStroke = 
                    (BasicStroke)getStroke();
                int width = 
                    (int)(basicStroke.getLineWidth()),
                    x2 = x + width/2,
                    y2 = y + width/2,
                    dW = w - width,
                    dH = h - width;
                gDC.setStroke(getStroke());
                gDC.drawRect(x2, y2, dW-1, dH-1);
                if(what == Ring) {
                    gDC.setColor(Color.black);
                    gDC.setStroke(Stroke_1);
                    gDC.drawRect(x, y, w-1, h-1);
                    x += width;
                    y += width;                                
                    int ww = w - 2 * width,
                        hh = h - 2 * width;
                    gDC.drawRect(x, y, ww-1, hh-1);
                }
                break;
            case Full:    // Full  
                setGradient(gDC, x, y, w, h);
                gDC.fillRect(x, y, w, h);
                gDC.setStroke(new BasicStroke(1));
                gDC.setColor(Color.black);
                gDC.drawRect(x, y, w-1, h-1);
        }            
        gDC.setStroke(oldStroke);
        gDC.setPaint(oldPaint);
    }
}