import janb.view.*;

public
class ResMaster
    extends View {

    private int n = 5,    
                r, w, h, R, W, H, 
                xCenter, yCenter;
    
    public void initView()
    {
        w = getWidth();
        h = getHeight();
        xCenter = w/2;
    }
    
    public void dataEntered(String data)
    {
        if(!isIntegral(data) || getInt(data) < 2) {
            beep();
            return;
        }
        
        n = getInt(data);
        redraw();
    }
    
    public void drawView()
    {
        getRWH();   
        int r = (int)(R * sin((int)(180.0 / n)));
        setStroke(r / 4);
        for(int i = 0; i < n ; i++) {           
            int fi = (int)(90 + i * 360.0 / n),
                x = (int)(xCenter + R * cos(fi) - r),
                y = (int)(yCenter - R * sin(fi) - r);
            setPaint(getGradient());
            setFill(Ring);
  
                // wykrelenie koa              
            drawCircle(x, y, 2*r);
        }
    }    
    
    /*
    Definicja
        th = 180 / n;
        
    Dla dowolnego n
        r = R * sin(th);
        
    Wysoko i szeroko piramidy jako funkcja R

        Dla n nieparzystego rnego od 1
            H = r + R + R * cos(th) + r
            W = 4 * r 
            tj.
            H = R * (1 + 2 * sin(th) + cos(th))
            W = 4 * R * sin(th) 
        
        Dla n parzystego (w tym dla n = 2)
        
            H = W = r + 2 * R + r;
            tj.
            H = W = 2 * R * (1 + sin(th))
    */    
    
    public void getRWH()
    {        
        int th = (int)(180.0 / n);
        double R = 0, W = 0, H = 0;
        if(isOdd(n)) {
            R = h / (1 + 2 * sin(th) + cos(th));
            W = 4 * R * sin(th);
            
            if(W > w) {
                R = w / (4 * sin(th));
                W = 4 * R * sin(th);
            }   
            H = R * (1 + 2 * sin(th) + cos(th));
            yCenter = (h - (int)H) / 2 + 
                      (int)(R * (1 + sin(th)));
        }
        
        if(isEven(n)) {        
            R = h/2 / (1 + sin(th));
            W = 2 * R * (1 + sin(th));
            
            if(W > w) {
                R = h/2 / (1 + sin(th));
                W = 2 * R * (1 + sin(th));
            }
            yCenter = h/2;
        }  
        this.R = (int)R;
        this.W = (int)W;
        this.H = (int)H;
    }
}



 



[[[Cz II




    [[[Programowanie strukturowe




    Programowanie strukturowe jest rozwiniciem programowania klasycznego o wykonywanie operacji na listach i drzewach.

 



[[[Struktury danych




Struktur jest zmienna, ktra skada si z zestawu elementw. Kady element obiektu jest skalarem: numerykiem albo odnonikiem (do tablicy albo obiektu). Elementy s identyfikowane przez symbole okrelone przez programujcego podczas deklarowania struktury.

Opis struktury ma posta

    class Name
        Block

w ktrej Name jest nazw typu strukturowego, a Block jest instrukcj grupujc, ktrej ciao zawiera deklaracje pl i konstruktorw struktury.

Uwaga: Nazwa konstruktora jest identyczna z nazw typu strukturowego. Opis struktury moe zawiera wicej ni 1 konstruktor.

Przykad

Nastpujca definicja jest opisem 2-elementowych struktur typu Person,  ktrej elementy s typu String i int. Wystpujce w definicji funkcje s konstruktorami.

class Person {
    
    String fullName;
    int age;
    
    Person(String fullName, int age)
    {
        this.fullName= fullName;
        this.age = age;
    }

    Person(String fullName)
    {
        this.fullName = fullName;
    }
}


[[[Konstruktory


Konstruktor jest funkcj, ktrej suy do inicjowania elementw struktury. Jeli nazw pola struktury jest name, to w ciele konstruktora jest ni this.name. Kwalifikator this (wraz z kropk) mona pomin tylko tam, gdzie jest widoczna deklaracja pola.

Uwaga: Jeli w ciele struktury nie zdefiniuje si ani jednego konstruktora, to niejawnie zostanie wstawiony tam publiczny konstruktor o pustym ciele, nazywany konstruktorem domylnym.

Przykad

W nastpujcej definicji pominito kwalifikator nazwy pola im. Uproszczenie to nie moe dotyczy nazwy this.re, poniewa w miejscu jej wystpienia nie jest widoczna deklaracja nazwy pola re (przesania j deklaracja parametru re).

class Cplx {

    double re, im;
    
    Cplx(double re, double i)
    {
        this.re = re;
        im = i;         // skrt od: this.im = i;
    }
}


[[[Fabrykatory


W celu utworzenia struktury si posuy fabrykatorem. Fabrykator przydziela pami dla struktury, wywouje konstruktor i dostarcza odnonik do sfabrykowanej struktury.

Przykady

Przytoczone tu fabrykatory zostay uyte do sfabrykowania struktur typu Person i Cplx.

Person person;
person = new Person("Mary Taylor", 30);

Cplx number = new Cplx(3.0, 4.0);


[[[Odwoania


Jeli  struktur identyfikuje odnonik ref, a nazw jej pola jest name, to nazw elementu opisanego przez to pole jest ref.name.

Nastpujcy aplet, pokazany na ekranie Przetwarzanie struktur, oczekuje podania w klatce: nazwiska, imienia i wieku i na tej podstawie tworzy i przetwarza struktur typu Person.

Ekran Przetwarzanie struktur
### structure.gif

import janb.view.*;

public
class Master 
    extends View {
    
    class Person {
        
        String fullName;
        int age;
        
        Person(String fullName, int age)
        {
            this.fullName= fullName;
            this.age = age;
        }
    
        Person(String fullName)
        {
            this.fullName = fullName;
        }
    }
    
    public void dataEntered(String[] data)
    {
        if(length(data) != 3 ||
           !isAlpha(data[0]) ||
           !isAlpha(data[1]) ||
           !isIntegral(data[2])) {
            beep();
            return;
        }
        
        String fullName = data[0] + ' ' + data[1];
        int age = getInt(data[2]);
        
        Person person = new Person(fullName, age);
        
        showResult(person.fullName + " is " + person.age);
    }
}

 



[[[Listy i drzewa




Struktur listow jest poczenie struktur. Poczenia tworzy si zazwyczaj dopiero podczas wykonywania apletu i realizuje za pomoc odnonikw.


[[[Struktura stosowa


Nastpujcy aplet, pokazany na ekranie Struktura stosowa, wprowadza dane liczbowe z pliku Data.txt i tworzy z nich struktur listow o elementach uporzdkowanych w kolejnoci odwrotnej do kolejnoci ich wprowadzenia (np. dla danych: 10, 20, 30, wyprowadza: 30, 20, 10).

Uwaga: W celu zwrcenia uwagi, e opis struktur moe by znacznie uproszczony, ograniczono si do uycia bezparametrowego konstruktora domylnego oraz zrezygnowano z uycia specyfikatorw ochrony.

Ekran Struktura stosowa
### stackstr.gif

import janb.view.*;

public
class Master 
    extends View {

    class Item {
        Item pNext;
        int num;
    };
    
    private Item pHead = null;

    public void initView()
    {
        Stream inp = open("Data.txt", Input);
        if(inp == null) {
            showMsg("File does not exist!");
            return;
        }
        
            // tworzenie listy
        String data;
        while((data = read(inp)) != null) {
                // ignorowanie koca wiersza
            if(isEOL(data))
                continue;
                
                // tworzenie listy
            int num = getInt(data);
            Item pNew = new Item();
            pNew.pNext = pHead;
            pNew.num = num;
            pHead = pNew;
        }

            // przetwarzanie listy
        String result = "";
        while(pHead != null) {
            Item pOld = pHead;
            result += pHead.num + " ";
            pHead = pHead.pNext;
        }
        
            // wyprowadzenie wyniku
        showResult("Result is  " + result);
    }
}


[[[Struktura kolejkowa


Nastpujcy aplet, pokazany na ekranie Struktura kolejkowa, wprowadza dane z pliku Data.txt, tworzc z nich struktur listow o elementach uporzdkowanych w kolejnoci ich wprowadzenia (np. dla danych: 10, 30, 20, wyprowadza: 10, 30, 20).

Uwaga: W opisie struktury uyto konstruktora dwuparametrowego.

Ekran Struktura kolejkowa
### queuestr.gif

import janb.view.*;

public
class Master 
    extends View {

    class Item {
    
        Item pNext;
        int num;
        
        Item(Item pNext, int num)
        {
            this.pNext = pNext;
            this.num = num;    
        }
    };
    
    private Item pHead = null,
                 pTail;
    
    public void initView()
    {
        Stream inp = open("Data.txt", Input);
        if(inp == null) {
            showMsg("File does not exist!");
            return;
        }
                
            // tworzenie listy
        String data = null;
        while((data = read(inp)) != null) {
                // zignorowanie koca wiersza
            if(isEOL(data))
                continue;
                    
                // tworzenie listy
            int num = getInt(data);
            Item pNew = new Item(null, num);
            if(pHead == null)
                pHead = pTail = pNew;
            else {
                pTail.pNext = pNew;
                pTail = pNew;
            }
        }
    
            // przetwarzanie listy
        String result = "";
        while(pHead != null) {
            Item pOld = pHead;
            result += pHead.num + " ";
            pHead = pHead.pNext;
        }
        
            // wyprowadzenie wyniku
        showResult("Result is  " + result);
    }
}


[[[Struktura uporzdkowana


Nastpujcy aplet, pokazany na ekranie Struktura uporzdkowana, wprowadza dane liczbowe z pliku, tworzc z nich struktur listow o elementach na bieco porzdkowanych w kolejnoci rosncej (np. dla danych: 20, 10, 30 wyprowadza: 10, 20, 30).

Uwaga: Uycie konstruktora bezparametrowego jest niezbdne, poniewa opis struktury zawiera ju konstruktor, a wic do opisu struktury nie zostanie wstawiony konstruktor domylny.

Ekran Struktura uporzdkowana
### sortstr.gif

import janb.view.*;

public
class Master 
    extends View {

    class Item {
    
        Item pNext;
        int num;
        
        Item(Item pNext, int num)
        {
            this.pNext = pNext;
            this.num = num;    
        }
    };
    
    private Item pHead = new Item(null, 0);
    
    public void initView()
    {
        Stream inp = open("Data.txt", Input);
        if(inp == null) {
            showMsg("File does not exist!");
            return;
        }
                
            // tworzenie listy
        String data = null;
        while((data = read(inp)) != null) {
                // zignorowanie koca wiersza
            if(isEOL(data))
                continue;
                
                // tworzenie listy
            int num = getInt(data);
            Item pOld = pHead,
                 ptr  = pHead.pNext;             
            while(ptr != null && ptr.num < num) {
                pOld = ptr;
                ptr = ptr.pNext;
            }
            Item pNew = new Item(null, num);            
            pNew.pNext = pOld.pNext;
            pOld.pNext = pNew;
        }
    
            // przetwarzanie listy
        String result = "";
        Item ptr = pHead.pNext;
        while(ptr != null) {
            result += ptr.num + " ";
            ptr = ptr.pNext;
        }
        
            // wyprowadzenie wyniku
        showResult("Result is  " + result);
    }
}


[[[Struktura drzewiasta


Nastpujcy aplet, pokazany na ekranie Struktura drzewiasta, wprowadza dane liczbowe z klatki, tworzc z nich drzewo binarne, a nastpnie wyprowadza jego elementy..

Ekran Struktura drzewiasta
### treetree.gif

import janb.view.*;

public
class Master 
    extends View {
    
    class Node {
        int value;
        Node left, right;
        
        Node(int value, Node left, Node right)
        {
            this.value = value;
            this.left = left;
            this.right = right;
        }
    }    
    
    private int[] values;
    private int i;
    private Node root;
    private String result;
        
    public void dataEntered(String[] data)
    {              
        i = 0;
        values = getValues(data);
        if(values == null) {
           beep();
           return;
        }
        
        i = 0;
        root = growTree(length(data));
        result = "";
        showTree(root);
        showResult("Tree is  " + result);
    }
    
    public int getNext()
    {
        return values[i++];
    }
    
    public Node growTree(int count)
    {
        if(count == 0)
            return null;
        int leftCount;
        return new Node(
                   getNext(),
                   growTree(leftCount = count/2), 
                   growTree(count - leftCount - 1)
               );
    }

    public void showTree(Node node)
    {
       if(node == null)
           return;
       showTree(node.left);
       result += node.value + " ";
       showTree(node.right);
   }
}

 



[[[Cz III




    [[[Programowanie obiektowe




    Pogramowanie obiektowe polega na tworzeniu obiektw opisanych przez klasy oraz na wydawaniu obiektom polece opisanych przez metody zdefiniowane w klasach. Dobry styl programowania obiektowego polega na utworzeniu definicji klasy dla kadego rzeczownika, ktry pojawi w analizie rozwizywanego problemu.


 



[[[Klasy i obiekty




Klas jest opis struktury danych. Struktura opisana przez klas jest obiektem skadajcym si z elementw opisanych przez pola. W szczeglnoci, jeli nie-statyczne pole klasy jest typu int, to kady obiekt tej klasy zawiera element typu int.

Definicja klasy skada si z nagwka z fraz 

    class Name

w ktrej Name jest nazw klasy. Przed fraz moe wystpi specyfikator public, a po niej frazy extends i implements. Ciao klasy ma posta bloku ujtego w nawiasy klamrowe. W ciele klasy s zawarte deklaracje pl i definicje funkcji. 

Uwaga: Definicja klasy moe zawiera definicj klasy wewntrznej, a definicja funkcji moe zawiera definicj klasy lokalnej. Definicj wewntrzn mona umieci tam, gdzie mona umieci definicj funkcji, a definicj lokaln mona umieci tam, gdzie mona umieci deklaracj lokaln.


public
class Circle 
    extends Runner 
    implements Drawable, Moveable {

    private int x, y;       // pola x, y
    private Color color;    // pole color

        // funkcja skadowa
    public void draw(Graphics2D gDC)
    {
        // ...
        class Local {

            // ...
        }
        // ...
    }

    class Internal {

        // ...
    }
    // ...
}


[[[Dziedziczenie


Jeli po frazie class Name wystepuje fraza extends Base, to kady obiekt klasy Name skada si takich elementw jakie wystpuj w obiektach klasy Base oraz dodatkowo, z elementw jakie s opisane przez pola klasy Name.

Uwaga: Domyln fraz extends Base, dla klasy rnej od Object jest extends Object. A zatem obiekt kadej klasy skada si m.in. z elementw opisanych przez pola predefiniowanej systemowej klasy Object.

Przykad

Poniewa hierarchia rozszerzania (dziedziczenia) dla klasy Master ma posta

Object Component Container Panel Applet View Master

wic kady obiekt klasy Master skada si elementw opisanych przez wszystkie pola tych klas.


[[[Implementowanie


Jeli po frazie class Name wystpuje fraza implements Face, to klasa Name implementuje interfejs Face.

Implementowanie interfejsu jest zobowizaniem dostarczenia w ciele klasy wszystkich definicji funkcji zadeklarowanych w tym interfejsie. Jeli w interfejsie zadeklarowano stae finalne, to s one widoczne i dostpne w kadej klasie implementujcej ten interfejs.

Przykad 

Klasa Numbers implementuje interfejs Drawable. Zobowizuje j to do dostarczenia definicji funkcji drawPi zadeklarowanej w tym interfejsie.


plik Drawable.java

public 
interface Drawable {

    public final double Pi = Math.PI;
    public void drawPi(Graphics2D gDC, int x, int y);
}


plik Numbers.java

public
class Numbers 
    implements Drawable {

    public void drawPi(Graphics2D gDC, int x, int y)
    {
        gDC.drawString("" + Pi, x, y);
    }
   // ...
}


dla dociekliwych

Implementowanie interfejsu jest zuboon odmian dziedziczenia. Jest ono przydatne wwczas, gdy zamierza si wykonywa takie same operacje na obiektach rodziny klas, ktrych wsplny przodek jest w hierarchii klas znacznie od nich oddalony. 

W takim wypadku postpuje si zgodnie z nastpujcym schematem

1.    Definiuje interfejs zawierajcy deklaracje funkcji do wykonywania wymaganych operacji na obiektach.
2.    Zapewnia, aby kada z klas rodziny implementowaa ten interfejs.
3.    Wywouje zadeklarowane funkcje na rzecz odnonika zdefiniowanego typu interfejsowego.

Nastpujcy aplet, pokazany na ekranie Stosowanie interfejsu, ilustruje schemat posugiwania si intefejsami.

Ekran Stosowanie interfejsu
### interfac.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Drawable string, button;
 
    interface Drawable {
    
        public void draw(int x, int y);
    }
    
    class String2 
        implements Drawable {
        
        private String string;
        
        public String2(String string)
        {
            this.string = string;
        }
        
        public void draw(int x, int y)
        {
            drawString(string, x, y);
        }
    }
    
    class Button2
        extends Button
        implements Drawable {
               
        public Button2(String label)
        {
            super(label);
        }
        
        public void draw(int x, int y)
        {
            drawString(getLabel(), x, y);
        }
    }
    
    public void initView()
    {
        string = new String2("Hello");
        button = new Button2("World");
    }
    
    public void drawView()
    {
        string.draw(100, 100);
        button.draw(200, 200);
    }
}


[[[Widoczno


W kadym punkcie klasy jest widoczna nazwa pola, ktrego deklaracja nie zostaa przesonita przez inn deklaracj takiej samej nazwy. W szczeglnoci, w klasie pochodnej s widoczne wszystkie nie przesonite skadniki jej klasy bazowej.

Uwaga: Jeli bezporednia klasa bazowa zawiera pole name, ale w klasie pochodnej nazwa ta zostaa przesonita, to do przesonitego pola mona si odwoywa za pomoc kwalifikowanej nazwy super.name. Nie ma natomiast moliwoci odwoania si do pl innej ni bezporednia klasy bazowej (np. przez super.super.name).

Przykad

W miejscu, w ktrym w klasie Woman wystpuje instrukcja powrotu, jest widoczna nazwa fullName klasy Woman, ale nie jest widoczna nazwa fullName klasy Person. To tej niewidocznej nazwy mona odwoa si za pomoc napisu Person.fullName.

W miejscu tym jest widoczna nazwa age klasy Person, poniewa nie zostaa przesonita przez deklaracje globalne klasy Woman, ani przez lokalne deklaracje parametrw funkcji getName klasy Woman.


plik Person.java

public
class Person {

    private String fullName;
    private int age;
    
    public String getName()
    {
        return fullName;
    }    
        
    // ...
}


plik Woman.java

public
class Woman 
    extends Person {
    
    private boolean isMarried;
    private String fullName;
    
    public String getBoth()
    {
        return fullName + "  " + super.fullName;
    }        
       
    // ...
}


[[[Pakiety 


Definicje klas i interfejsw mona grupowan w pakiety. Jeli definicja klasy albo interfejsu ma si znale w pakiecie packet, to zawierajcy j plik naley rozpocz od polecenia

    package packet;

w ktrym packet jest opisem pakietu (np. janb.debug).

Uwaga: Jeli nie okreli si nazwy pakietu, to klasa albo interfejs zostanie umieszczona w pakiecie domylnym.

Przykad

Klasa Master naley do pakietu janb.jbPack.

package janb.jbPack;

import janb.view.*;

public 
class Master
    extends View {
       
    public void drawView()
    {
        showResult("Hello");
    }
}


[[[Hermetyzacja


Hermetyzacja polega na okreleniu dostpnoci skadnikw klasy. Obowizuj tu nastpujce zasady

1.    Nazwa zadeklarowana ze specyfikatorem public jest dostpna wszdzie (jest publiczna)
2.    Nazwa zadeklarowana ze specyfikatorem private jest dostpna tylko w jej klasie (jest prywatna).
3.    Nazwa zadeklarowana ze specyfikatorem protected jest dostpna tylko w jej klasie oraz w jej klasach pochodnych (jest chroniona).
4.    Nazwa zadeklarowana bez specyfikatora dostpnoci jest dostpna w caym pakiecie, do ktrego naley jej klasa (jest pakietowa).

Uwaga: Jeli klasa nie jest finalna, a wic gdy przewiduje si, e moe by potraktowana jako klasa bazowa pewnej klasy pochodnej, to zaleca si aby jej pola deklarowano jako chronione (protected). Deklarowane jako prywatne (private) powinny by tylko takie pola, ktrych nie przewiduje si do niekontrolowanego udostpniania skadnikom klasy pochodnej.

Przykad

Pola fullName i age klasy Person s widoczne w klasie Woman, ale dostpne w tej klasie jest tylko chronione pole age.

plik Person.java

public
class Person {

    private   String fullName;
    protected int age;
    
    public String getName()
    {
        return fullName;
    }    
        
    // ...
}


plik Woman.java

public
class Woman 
    extends Person {
    
    private boolean isMarried;
    private String fullName;
    
    public int getAge()
    {
        return age;
    }        

    public String getName()
    {
        return fullName;
    }        
       
    // ...
}


[[[Finalno


Nazwa zadeklarowana ze specyfikatorem final jest finalna. Jeli jest nazw zmiennej, to jest ustalona (w C++ const). Jeli jest nazw klasy, to taka klasa nie moe by uyta jako klasa bazowa innej klasy.

Uwaga: Finaln jest na przykad klasa String, ale nie jest klasa Vector.

Przykad

Klasa Person jest publiczn klas finaln.

public final
class Person {

    private String name;
    private int age;
    private final int teenAgeLimit = 19;
    
    // ...
}


[[[Konstruktor


Konstruktorem jest funkcja, ktrej zadaniem jest zainicjowanie elementw obiektu. W klasie moe wystpowa wicej ni jeden konstruktor. Jeli nie zdefiniowano ani jednego konstruktora, do klasa jest uzupeniana publicznym konstruktorem bezparametrowym o pustym ciele.

Z wntrza konstruktora klasy pochodnej Name mona wywoa konstruktor jej klasy bazowej Base. W klasie pochodnej taki konstruktor nazywa si super, a wywoujca go instrukcja musi by pierwsz instrukcj konstruktora klasy Name.

Z wntrza konstruktora klasy Name mona wywoa inny konstruktor jej klasy. W klasie Name taki konstruktor nazywa si this, a wywoujca go instrukcja musi by pierwsz instrukcj konstruktora klasy Name.

Przykad 

Wywoanie 1-parametrowego konstruktora klasy Woman spowoduje wykonanie w podanej kolejnoci, instrukcji klas Person i Woman.


plik Person.java

public
class Person {

    private String fullName;
    private int age;
    
    public Person(String fullName, int age)
    {
        this.fullName = fullName;    // 4
        this.age = age;              // 5
        // ...
    }
    
    public Person(String fullName)
    {
        this(fullName, 20);
        // ...
    }
    
    // ...
}


plik Woman.java

public
class Woman 
    extends Person {
    
    private boolean isMarried;
    
    public Woman(String fullName, int age, boolean isMarried)
    {
        super(fullName, age);        // 3
        this.isMarried = isMarried;  // 6
        // ...
    }
    
    public Woman(String fullName, int age)
    {
        this(fullName, age, false);  // 2
        // ...                       // 7
    }
    
    public Woman(String fullName)
    {
        this(fullName, 20);          // 1
        // ...                       // 8
    }        
    
    // ...
}


[[[Fabrykator


W celu utworzenia obiektu klasy naley si posuy fabrykatorem. Fabrykator przydziela pami dla obiektu, wywouje konstruktor klasy i dostarcza odnonik do sfabrykowanego obiektu.

Przykad

Do utworzenia obiektu klasy Woman uyto fabrykatora wywoujcego 3-parametrowy konstruktor tej klasy.


plik Person.java

public
class Person {

    private String fullName;
    private int age;
    
    public Person(String fullName, int age)
    {
        this.fullName = fullName;
        this.age = age;
    }
    
    // ...
}


plik Woman.java

public
class Woman 
    extends Person {
    
    private boolean isMarried;
    
    public Woman(String fullName, int age, boolean isMarried)
    {
        super(fullName, age);
        this.isMarried = isMarried;
    }
    
    // ...
}


plik Master.java

public 
class Master
    extends View {
    
    private Woman woman;
    
    public void initView()
    {
        woman = new Woman("Mary Taylor", 30, false);
        // ...
    }
}


[[[Abstrakcyjno


Klas abstrakcyjn jest klasa zadeklarowana ze specyfikatorem abstract oraz klasa, w ktrej nie dostarczono definicji funkcji zadeklarowanej w interfejsie implementowanym przez t klas.

Uwaga: Klasa abstrakcyjna rni si tym od klasy nie-abstrakcyjnej, e za pomoc fabrykatora nie mona tworzy jej obiektw.

Przykad

Poniewa klasa Person jest abstrakcyjna, a klasa Woman nie jest abstrakcyjna. Klasa Woman co prawda dziedziczy funkcj abstrakcyjn, ale poniewa dostarcza jej definicji, wic nie jest klas abstrakcyjn. Nie mona fabrykowa obiektw klasy Person, ale mona fabrykowa obiekty klasy Woman.


plik Person.java

public abstract
class Person {

    private String fullName;
    private int age;
    
    public Person(String fullName, int age)
    {
        this.fullName = fullName;
        this.age = age;
    }
    
    abstract void draw(Graphics2D gDC);
    
    public String getName()
    {
        return fullName;
    }
    // ...
}


plik Woman.java

public
class Woman 
    extends Person {
    
    private boolean isMarried;
    
    public Woman(String fullName, int age, boolean isMarried)
    {
        super(fullName, age);
        this.isMarried = isMarried;
    }
    
    void draw(Graphics2D gDC)
    {
        gDC.drawString(getName(), 20, 100);
    }
    
    // ...
}


plik Master.java

public 
class Master
    extends View {
       
    public void initView()
    {
        Person person = 
            new Person("Mary Taylor", 30);    // bd
        Woman woman = 
            new Woman("Mary Taylor", 30, true);
    }
}

 



[[[Funkcje i metody


Funkcje dziel si na konstruktory, funkcje statyczne i metody. Funkcj statyczn jest funkcja zadeklarowana ze specyfikatorem static. Metod jest kada funkcja nie-statyczna, ktra nie jest konstruktorem.

Funkcja statyczna moe odwoywa si tylko do pl statycznych. Nazwa funkcji statycznej function klasy Some jest Some.function. Nazw pola statycznego field klasy Some jest Some.field. 

Uwaga: Jeli w miejscu odwoania jest widoczna nazwa funkcji statycznej albo pola statycznego, to kwalifikator Some. mona pomin.

Przykad

Pole statyczne count zlicza, ile razy tworzono obiekt klasy Person.


plik Person.java

public
class Person {

    private String fullName;
    private int age;
    private static int count = 0;  // pole statyczne
    
        // konstruktor
    public Person(String fullName, int age)
    {
        this.fullName = fullName;
        this.age = age;
        count++;
    }
    
        // funkcja statyczna
    public static int getCount()
    {
        return Person.count;  // albo return count;
    }    
       // metoda
    public String getName()
    {
        return fullName;
    }
    
    // ...
}


[[[Funkcja abstrakcyjna


Funkcj abstrakcyjn jest funkcja bez ciaa, zadeklarowana ze specyfikatorem abstract. Jeli klasa zawiera deklaracj funkcji abstrakcyjnej, to staje si klas abstrakcyjn i musi by zdefiniowana ze specyfikatorem abstract.

Uwaga: Kada funkcja interfejsu jest domylnie publiczn funkcja abstrakcyjn.

Przykad

Funkcja draw jest funkcj abstrakcyjn zawart w klasie abstrakcyjnej Person.


plik Person.java

public abstract
class Person {

    private String fullName;
    private int age;
    
    abstract void draw(Graphics2D gDC);
    // ...
}


[[[Wywoywanie funkcji


Wywoanie funkcji statycznej odbywa si przez jej nazw. Nazw funkcji statycznej function klasy Name jest Name.function. Jeli w miejscu wywoania jest widoczna deklaracja wywoywanej funkcji, to nazw funkcji mona uproci do function.

Przykad

Poniewa w ciele funkcji drawCount jest widoczna funkcja Person.getCount, wic jej nazw mona uproci do getCount.


plik Person.java

public
class Person {

    private String fullName;
    private int age;
    private static int count = 0;
    
    public Person(String fullName, int age)
    {
        this.fullName = fullName;
        this.age = age;
    }
        
    public static int getCount()
    {
        return count;
    }
    
    // ...
}


plik Woman.java

import java.awt.*;

public
class Woman 
    extends Person {
    
    private boolean isMarried;
    
    public Woman(String fullName, int age, boolean isMarried)
    {
        super(fullName, age);        
        this.isMarried = isMarried;
    }
    
    public void drawCount(Graphics2D gDC)
    {
        gDC.drawString(
            "Count = " + 
            Person.getCount(),  // albo: getCount()
            20, 120
        );
    }
       
    // ...
}


[[[Wywoywanie metod


Wywoanie metody odbywa si na rzecz obiektu identyfikowanego przez odnonik. Wywoanie ma posta

    object.method(arg, arg, ... , arg)

w ktrej object jest odnonikiem do obiektu, method jest nazw metody, a kade arg jest argumentem.

W chwili wywoania metody jest tworzony odnonik reprezentowany przez sowo kluczowe this, po czym przypisuje si mu odniesienie stanowice warto odnonika object. Po skojarzeniu parametrw z argumentami, wykonuje si instrukcje zawarte w ciele metody.

Uwaga: Odnonik this jest niejawnym parametrem metody, identyfikujcym ten sam obiekt, ktry jest identyfikowany przez odnonik object.

Nastpujacy aplet, pokazany na ekranie Wywoywanie metod, pokazuje wiek Mary Taylor, zwikszajc go o 1 po kadym naciniciu klawisza spacji.

Ekran Wywoywanie metod
### methods.gif


plik Master.java

import janb.view.*;

public
class Master 
    extends View {
    
    private Person person;
    
    public void initView()
    {
        person = new Person("Mary Taylor", 30);
    }
    
    public void drawView()
    {
        showResult(
            person.getName() + 
            " is " + 
            person.getAge()
        );
    }
    
    public void keyTyped(char key)
    {
        if(key == SpaceKey)
            person.setAge(person.getAge() + 1);
        redraw();
    }
}


plik Person.java

public
class Person {

    private String fullName;
    private int age;
   
    public Person(String fullName, int age)
    {
        this.fullName = fullName;
        this.age = age;
    }
    
    public String getName()
    {
        return fullName;
    }
    
    public int getAge()
    {
        return age;
    }    
        
    public int setAge(int age)
    {
        return this.age = age;
    }
}


[[[Wymiana danych


Sposb wymiany danych midzy obiektami rnych klas zaley od tego, jak silna jest hermetyzacja ich skadnikw. Zalecenie, aby pola klas byy prywatne albo przynajmniej chronione,  powoduje, e dostarczenie danych do obiektu klas zewntrznej wymaga istnienia w klasie tego obiekt pola odnonikowego identyfikujcego obiekt dostarczajcy dan.


[[[Klasa wewntrzna

Nastpujcy aplet, pokazany na ekranie Klasa wewntrzna, ilustruje sposb dostarczenia danej do obiektu klasy klasy wewntrznej.

Uwaga: Klasa wewntrzna ma dostp do wszystkich (take do prywatnych) skadnikw jej klasy macierzystej.

Ekran Klasa wewntrzna
### internal.gif

import janb.view.*;

public
class Master 
    extends View {
    
    private String country = "Poland";
    private Person person;
    
    class Person {

        private String fullName;
        private String country;
        
        public Person(String fullName, Master master)
        {
            this.fullName = fullName;
            this.country = master.country;           
        }
        
        public String getInfo()
        {
            return name + " is from " + country;
        }
    }
    
    public void initView()
    {
        person = new Person("Mary Taylor", this);
    }
    
    public void drawView()
    {
        showResult(person.getInfo());
    }    
}


[[[Klasy zewntrzne

Nastpujcy aplet, pokazany na ekranie Klasa zewntrzna, ilustruje sposb dostarczenia danej do obiektu klasy klasy zewntrznej.

Uwaga: Klasa zewntrzna ma ograniczony dostp do skadnikw innej klasy zewntrznej. Rozwizaniem tego problemu jest  umieszczenie w klasie dostawcy publicznych funkcji organizujcych dostaw.

Ekran Bez Klasa zewntrzna
### external.gif

import janb.view.*;

public
class Master 
    extends View {
    
    private String country = "Poland";
    private Person person;
    
    public String getCountry()
    {
        return country;
    }
        
    public void initView()
    {
        person = new Person("Iza Bielecka", this);
    }
    
    public void drawView()
    {
        showResult(person.getInfo());
    }    
}

class Person {

    private String fullName;
    private String country;
    
    public Person(String fullName, Master master)
    {
        this.fullName = fullName;
        this.country = master.getCountry(); 
    }
    
    public String getInfo()
    {
        return name + " is from " + country;
    }
}

 



[[[Konwersje




Konwersj jest przeksztacenie zmiennej pewnego typu w zmienn innego typu, na przykad zmiennej typu double w zmienn typu int. 

Konwersja numeryczn jest przeksztacenie zmiennej numerycznej w numeryczn. Odbywa si to na og z zachowaniem zblionej wartoci. Na przykad (int)4.8 ma warto 4, a (double)4 ma warto 4.0.

Konwersj obiektow jest przeksztacenie odnonika pewnego typu w odnonik innego typu, na przykad odnonika typu String w odnonik typu Object albo odwrotnie.

Konwersje obiektowe s rozpoznawane przez Kompilator i przez Maszyn Wirtualn. Konwersja zaakceptowana przez kompilator jest poprawna statycznie, a zaakceptowana przez Maszyn Wirtualn jest poprawna dynamicznie. Konwersja jest poprawna jeli jest poprawna statycznie i dynamicznie.


[[[Poprawno statyczna


Poprawna statycznie jest

1.    Konwersja wzdu dowolnej drogi w hierarchii klas, ktra od klasy odnonika poddawanego konwersji do klasy odnonika docelowego wiedzie tylko w gr albo tylko w d.
2.    Niejawna konwersja z typu klasowego na jego typ bazowy.
3.    Konwersja z dowolnego typu klasowego na dowolny typ interfejsowy.
4.    Niejawna konwersja z typu klasowego na implementowany przeze typ interfejsowy.
5.    Konwersja z dowolnego typu interfejsowego na dowolny typ interfejsowy.
6.    Niejawna konwersja z typu interfejsowego na implementowany przeze typ interfejsowy.

import janb.view.*;

public
class Master 
    extends View {
        
    public void initView()
    {
        Woman woman = new Woman();
        Animal animal = new Animal();
        Object object;
        Face face;
        Snout snout;
        Look look;
        Man man;
        
        object = (Object)woman;      // ad. 1
        woman = (Woman)object;       // ad. 1
        man = woman;                 //     bd statyczny
        man = (Man)(Object) woman;   //     ok statycznie (sic!)
        object = woman;              // ad. 2
        snout = (Snout)woman;        // ad. 3
        snout = woman;               //     bd statyczny
        face = woman;                // ad. 4
        snout = (Snout)face;         // ad. 5
        snout = face;                //     bd statyczny
        look = snout;                // ad. 6
    }

}

interface Face {
    // ...
}

class Person 
    implements Face {

    // ...
}

class Woman 
    extends Person {

    // ...
}

class Man 
    extends Person {
    
}    

interface Look {

}

interface Snout
    extends Look {
    // ...
}

class Animal 
    implements Snout {

    // ...
}


[[[Poprawno dynamiczna


Poprawna dynamicznie jest konwersja, w ktrej 

1.    Odnonik docelowy jest typu klasowego, a jego klasa znajduje si w hierarchii klas na drodze czcej klas obiektu identyfikowanego przez odnonik poddawany konwersji z klas Object.
2.    Odnonik docelowy jest typu interfejsowego, a klasa obiektu identyfikowanego przez odnonik poddawany konwersji implementuje ten interfejs.

import janb.view.*;

public
class Master 
    extends View {
        
    public void initView()
    {
        Woman woman = new Woman();
        Person person;
        Face face;
        Snout snout;
        Man man;
        
        person = woman;             // ad. 1
        face = woman;               // ad. 2
        man = (Man)(Person)woman;   // bd dynamiczny
        snout = (Snout)woman;       // bd dynamiczny
    }
}

interface Face {
    // ...
}

class Person 
    implements Face {

    // ...
}

class Woman 
    extends Person {

    // ...
}

class Man 
    extends Person {
    
}    

interface Look {

}

interface Snout
    extends Look {
    // ...
}

 


[[[Polimorfizm


Wywoania metod polimorficzne. Polega to na tym, e jeli odnonikowi object klasy albo interfejsu Some

    Some object;

przypisano odniesienie do obiektu pewnej klasy, a wywoanie metody method na rzecz obiektu identyfikowanego w danej chwili przez object ma posta

    object.method(arg, arg, ... , arg)

to wykonuje si metod method widoczn w tej klasie, a nie metod klasy albo interfejsu Some.

Podczas kompilowania programu sprawdza si jedynie czy wywoanie jest poprawne statycznie, to jest czy w klasie albo w interfejsie Some jest widoczna i dostpna metoda method. 

Podczas wykonania upewnia si natomiast, e wywoanie jest poprawne dynamicznie, to jest czy stosownie do przypadku, odnonik object identyfikuje: obiekt klasy Some, obiekt klasy pochodnej od Some albo obiekt klasy implementujcej interfejs Some.

Uwaga: Jeli object ma posta sowa kluczowego super, a wywoanie jest zawarte w klasie Some pochodnej od Base, to wywoanie jest nie-polimorficzne i dotyczy metody method klasy Base z super zamienionym domylnie na this.

Nastpujcy aplet, pokazany na ekranie Wywoania polimorficzne, ilustruje zastosowanie polimorfizmu. Gwnym elementem programu jest wywoanie wystpujce w funkcji drawView. W zalenoci od tego jakiej klasy jest obiekt identyfikowany w danej chwili przez odnonik parent, jest wywoywana metoda getWho klasy Father albo metoda getWho klasy Mother. Metoda getWho klasy Parent jest wywoywana niepolimorficznie i tylko z wntrz tych funkcji.

Uwaga: Poniewa nie mona przewidzie, jakie odniesienie zostanie przypisane odnonikowi parent, wykonanie apletu jest niedeterministyczne.

Ekran Wywoania polimorficzne
### polimorf.gif

import janb.view.*;

public
class Master 
    extends View {
    
    private Father father = new Father("John Taylor", 40);
    private Mother mother = new Mother("Mary Taylor", 25);
    private Parent parent;
    
    public void initView()
    {
        int random = getRandom(2);
        if(random == 0)
            parent = father;
        else
            parent = mother;            
    }
    
    public void drawView()
    {
        showResult(parent.getWho());
    }

    abstract
    class Parent {
    
        private String fullName;
        private int age;
        
        public Parent(String fullName, int age)
        {
            this.fullName = fullName;
            this.age = age;
        }    
        
        public String getWho()
        {
            return fullName;
        }
        
        public int getAge()
        {
            return age;
        }
    }
           
    class Father 
        extends Parent {
               
        public Father(String fullName, int age)
        {
            super(fullName, age);
        }
        
        public String getWho()
        {
            return "Father " + super.getWho() + 
                   " is " + getAge();
        }
    }

    class Mother
        extends Parent {
               
        public Mother(String fullName, int age)
        {
            super(fullName, age);
        }
        
        public String getWho()
        {
            return "Mother " + super.getWho() + 
                   " is " + getAge();
        }
    }
}



 



[[[Kolekcje




Najczciej uywan klas kolekcyjn jest klasa Vector. Jest ona przykadem kolekcji implementowanej przez tablic o potencjalnie nieograniczonej liczbie elementw. Nowe elementy mona docza na kocu kolekcji, a stare mona zastpowa nowymi. Elementy mona wstawia midzy inne elementy, a usunicie elementu powoduje przemieszczenie w gr nastpujcych po nim elementw kolekcji.

Uwaga: Ten sam obiekt moe si znajdowa w wicej ni jednej kolekcji. Usunicie obiektu z kolekcji nie powoduje zniszczenia obiektu.


[[[Konstruktory


Vector(int count)
Vector()
Konstruuje kolekcj tablicow o count elementach (domylnie 0).


[[[Metody


[[[void add(int index, Object element)
Umieszcza w kolekcji, a pozycji index, obiekt object.

[[[boolean add(Object object)
Umieszcza na kocu kolekcji obiekt object. Dostarcza bezwarunkowo true.

[[[int size()
Dostarcza liczb obiektw kolekcji.

[[[Object get(int index)
Dostarcza odnonik do obiektu na pozycji index. Wysya wyjtek ArrayIndexOutOfBoundsException, jeli kolekcja nie zawiera elementu o podanym indeksie.

[[[Object set(int index, Object object)
Umieszcza w kolekcji, na pozycji index, obiekt object. Dostarcza odnonik do obiektu, ktry uprzednio znajdowa si na tej pozycji. Wysya wyjtek ArrayIndexOutOfBoundsException, jeli kolekcja nie zawiera elementu o podanym indeksie.

[[[boolean remove(Object object)
Usuwa z kolekcji, pierwszy znajdujcy si w niej obiekt object. Dostarcza true, jeli kolekcja zawieraa taki obiekt.

[[[void clear()
Usuwa z kolekcji wszystkie umieszczone w niej obiekty.


Nastpujcy aplet, pokazany na ekranie Kolekcjonowanie figur, tworzy kolekcj k i rombw tworzonych po klikaniu na widoku. W polu komunikatw jest podawane sumaryczne pole figur.

Ekran Kolekcjonowanie figur
### collect.gif

import janb.view.*;
import java.util.*;

public
class Master 
    extends View {
    
    private int d = 40, d2 = d/2;
    private Vector dataBase = new Vector();
           
    public void drawView()
    {    
        double area = 0;
        int size = dataBase.size();
        for(int i = 0; i < size ; i++) {
            Object object = dataBase.get(i);
            Figure figure = (Figure)object;
            figure.draw(pDC);
            Countable countable = (Countable)object;           
            area += countable.getArea();
        }
        showMsg("Area = " + (int)area);
    }
    
    public void mouseReleased(int x, int y, int flags)
    {
        Figure figure;
        if(isMeta(flags)) 
            figure = new Diamond2(
                         x-d2, y-d2, d, d, getColor()
                     ); 
        else
            figure = new Ellipse2(
                         x-d2, y-d2, d, d, getColor()
                     );
        dataBase.add(figure);
        redraw();
    }
}

interface Countable {

    public double getArea();
}

class Diamond2 
    extends Diamond
    implements Countable {        
    
    public Diamond2(int x, int y, int w, int h, Paint p)
    {
        super(x, y, w, h, p);
    }
    
    public double getArea()
    {
        double w = getW(),
               h = getH();    
        return w * h / 2;
    }
}

class Ellipse2 
    extends Ellipse
    implements Countable {
    
    public Ellipse2(int x, int y, int w, int h, Paint p)
    {
        super(x, y, w, h, p);
    }
    
    public double getArea()
    {
        double w = getW(),
               h = getH();    
        return Math.PI * w * h / 4;
    }
}

 



[[[Rozkady




Na widoku mona umieszcza nie tylko obiekty graficzne, ale rwnie sterowniki: przyciski, klatki, opisy i panele. O sposobie rozmieszczenia sterownikw decyduje zarzdca rozkadu. 

Uwaga: Widok jest panelem, ktry zdefiniowano bez zarzdcy rozkadu. Do narzucenia mu okrelonego zarzdcy suy metoda setLayout.

[[[void setLayout(LayoutManager manager)
Wywoana na rzecz pojemnika sterownikw, na przykad panelu, narzuca mu zarzdc rozkadu okrelonego przez manager.

Do dyspozycji jest kilku zarzdcw rozkadu, z ktrych najczciej uywanymi s: zarzdca rozkadu cigego (flow), brzegowego (border) i siatkowego (grid).  


[[[Bez rozkadu


Aby zrezygnowa z usug zarzdcw rozkadu, naley metod setLayout wywoa z argumentem 

    null

W takim wypadku pooenie i rozmiary sterownikw musz by okrelone jawnie, za pomoc metod setLocation i setSize albo setBounds.

[[[void setLocation(int x, int y)
Przemieszcza sterownik do punktu (x, y).

[[[void setSize(int w, int h)
Ustala rozmiary sterownika na  w x h.

[[[void setBounds(int x, int y, int w, int h)
Przemieszcza sterownik do punktu (x, y) i ustala jego rozmiary na  w x h.


Nastpujcy aplet, pokazany na ekranie Bez rozkadu, rozmieszcza swoje sterowniki bez uycia zarzdcy rozkadu.

Ekran Bez rozkadu
### nullmgr.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Button play = new Button("Play"),
                   loop = new Button("Loop"),
                   stop = new Button("Stop");
       
    public void initView()
    {
        setLayout(null);
        
        play.setLocation(50, 50);
        play.setSize(80, 40);
        add(play);
        
        loop.setLocation(120, 70);
        loop.setSize(80, 40);        
        add(loop);        
        
        stop.setLocation(190, 90);
        stop.setSize(80, 40);
        add(stop);
    }
}


[[[Rozkad cigy


Aby narzuci apletowi rozkad cigy, naley metod setLayout wywoa z argumentem 

    new FlowLayout()

W takim wypadku sterowniki bd rozmieszczane rzdami. W pierwszym rzdzie zarzdca umieci maksymaln liczb nie zachodzcych na siebie sterownikw, a pozostae umieci w taki sam sposb w kolejnych rzdach. Sterowniki kadego rzdu zostan rozmieszczone rwnomiernie.

Nastpujcy aplet, pokazany na ekranie Rozkad cigy, rozmieszcza swoje sterowniki przy pomocy zarzdcy rozkadu cigego.

Ekran Rozkad cigy
### flowmgr.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Button play = new Button("Play"),
                   loop = new Button("Loop"),
                   stop = new Button("Stop");
       
    public void initView()
    {
        setLayout(
            new FlowLayout()
        );
        
        add(play);            
        add(loop);        
        add(stop);
    }
}


[[[Rozkad brzegowy

    
Aby narzuci apletowi rozkad brzegowy, naley metod setLayout wywoa z argumentem 

    new BorderLayout()

W takim wypadku sterowniki bd rozmieszczane w 5 obszarach: zachodnim (West), wschodnim (East), pnocnym (North), poudniowym (South) i rodkowym (Center). Jeli w zestawie obszarw nie uyje si pewnego obszaru, to zostanie on skonsumowany przez pozostae. Moe to spowodowa, e sterowniki otrzymaj nadmierne rozmiary.

Nastpujcy aplet, pokazany na ekranie Rozkad brzegowy, rozmieszcza swoje sterowniki przy pomocy zarzdcy rozkadu brzegowego.

Uwaga: Uyto symboli z klasy BorderLayout. Kady z nich jest typu String (np. BorderLayout.West ma warto "West").

Ekran Rozkad brzegowy
### bordmgr.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Button play = new Button("Play"),
                   loop = new Button("Loop"),
                   stop = new Button("Stop");
       
    public void initView()
    {
        setLayout(
            new BorderLayout()
        );
        
        add(play, BorderLayout.NORTH);            
        add(loop, BorderLayout.WEST);        
        add(stop, BorderLayout.EAST);
    }
}


[[[Rozkad siatkowy


Aby narzuci apletowi rozkad siatkowy, naley metod setLayout wywoa z argumentem 

    new GridLayout(rows, cols)
albo
    new GridLayout(rows, cols, hGap, vGap)

W takim wypadku sterowniki bd rozmieszczane wierszami w prostoktnym ukadzie komrek rows x cols komrek o identycznych rozmiarach z odstpami hGap (w poziomie) i vGap (w pionie) midzy parami ssiadujcych komrek siatki.

Uwaga: Jeli poda si rn od 0 liczb wierszy i kolumn, to naley zapeni wszystkie komrki siatki. Jeli jako liczb wierszy poda si 0, to liczba wierszy wyniknie z liczby sterownikw i podanej liczby kolumn. Jeli jako liczb kolumn poda si 0, to liczba kolumn wyniknie z liczby sterownikw i podanej liczby wierszy.

Nastpujcy aplet, pokazany na ekranie Rozkad siatkowy, rozmieszcza swoje sterowniki przy pomocy zarzdcy rozkadu siatkowego.

Ekran Rozkad siatkowy
### gridmgr.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Button play = new Button("Play"),
                   loop = new Button("Loop"),
                   stop = new Button("Stop");
       
    public void initView()
    {
        setLayout(
            new GridLayout(0, 3)
        );
        
        
        add(play); 
        add(new Label(""));
        add(loop);
        
        for(int i = 0; i < 4 ; i++)
            add(new Label(""));
        add(stop);
    }
}


[[[Grupowanie sterownikw


Sterowniki mog by grupowane w panele rozmieszczane przez zarzdcw. Dziki temu staje si moliwe rozmieszczenie wicej ni jednego sterownika w tym samym obszarze rozkadu brzegowego albo w tej samej komrce rozkadu siatkowego.

Nastpujcy aplet, pokazany na ekranie Grupowanie sterownikw, grupuje sterowniki w panelach.

Ekran Grupowanie sterownikw
### grouping.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Button play = new Button("Play"),
                   loop = new Button("Loop"),
                   stop = new Button("Stop");
       
    public void initView()
    {
        setLayout(
            new BorderLayout()
        );
        
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());  // domylne!
        
        panel.add(play); 
        panel.add(loop);
        
        add(panel, BorderLayout.NORTH);
        add(stop,  BorderLayout.SOUTH);
    }
}



[[[Modyfikowanie sterownikw


Niekiedy predefiniowane rozmiary sterownikw okazuj si zbyt mae. W takim przypadku mona zastosowa prosty chwyt, polegajcy na zdefiniowaniu wasnej klasy sterownika, rozszerzajcej sterownik predefiniowany i umieci w niej metod getPreferredSize definiujc wasne rozmiary sterownika.

[[[Dimension getPreferredSize()
Metod naley napisa w taki sposb, aby dostarczaa wasne rozmiary sterownika.


Nastpujcy aplet, pokazany na ekranie Modyfikowanie sterownikw, tworzy wasne klasy sterownikw.

Ekran Modyfikowanie sterownikw
### modified.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Button2 play = new Button2("Play", 60, 20),
                    loop = new Button2("Loop", 80, 40),
                    stop = new Button2("Stop", 80, 80);
       
    public void initView()
    {
        setLayout(
            new FlowLayout()
        );
               
        Panel panel = new Panel();               
               
        panel.add(play); 
        panel.add(loop);        
        add(panel);
        
        add(stop);
    }
    
    class Button2
        extends Button {
        
        private Dimension dim;
        
        public Button2(String label, int w, int h)
        {
            super(label);
            dim = new Dimension(w, h);
        }
        
        public Dimension getPreferredSize()
        {
            return  dim;
        }
    }
}

 



[[[Sterowniki




Obiekty opisujce sterowniki tworzy si za pomoc fabrykatorw, wywoujcych konstruktory klas sterownikw. Po otrzymaniu odnonika do obiektu sterownika, mona na nim wykonywa operacje zmieniajce waciwoci sterownika, w tym jego pooenie, kolor i zawarto.


[[[Sterownik Button


[[[Konstruktory

[[[Button(String label)
Button()
Konstruuje przycisk opatrzony etykiet label (domylnie pust).


[[[Metody

[[[void setLabel(String label)
Zmienia etykiet przycisku na label.

[[[String getLabel(String label)
Dostarcza etykiet przycisku.


Przykad

Button command = new Button("Start");
// ...
command.setLabel("Stop");


[[[Sterownik TextField


[[[Konstruktory

[[[TextField(int count)
TextField(String string)
Konstruuje pust klatk mieszczc count znakw albo klatk zainicjowan acuchem string.


[[[Metody

[[[void setText(String string)
Umieszcza w klatce tekst string.

[[[String getText()
Dostarcza tekst zawarty w klatce.


Przykad

TextField input = new TextField(40);
// ...
input.setText("");


[[[Sterownik Label


[[[Konstruktory

[[[Label(String string)
Label(String string, int alignment)
Konstruuje etykiet z napisem string, wyrwnanym w sposb okrelony przez alignment.

Do wyrwnywania uywa si symboli: CENTER_ALIGNMENT, LEFT_ALIGNMENT, RIGHT_ALIGNMENT (domylnie LEFT_ALIGNMENT).


[[[Metody

[[[void setText(String string)
Umieszcza w etykiecie tekst string.

[[[String getText()
Dostarcza tekst etykiety.


Przykad

Label label = new Label("All right", Label.CENTER_ALIGNMENT);
// ...
label.setText("Error");



[[[Sterownik Panel


[[[Konstruktory

[[[Panel(LayoutManager manager)
Panel()
Konstruuje panel z zarzdc manager (domylnie: zarzdca rozkadu cigego).


[[[Metody

[[[void add(Component component)
void add(Component component, in position)
Umieszcza w panelu komponent component na pozycji domylnej albo na pozycji position.

[[[String setLayout(LayoutManager manager)
Narzuca panelowi zarzdc rozkadu manager.


Przykad

Panel panel = new Panel(new FlowLayout());
// ...
panel. add(new Button("Start");
 



[[[Zdarzenia




Operacj na sterowniku: panelu, przycisku, klatce, wykonuje si zazwyczaj po to, aby zostaa obsuona. Do obsugi zdarzenia deleguje si obiekt nasuchujcy. 

Jesli obiekt nasuchujcy ma reagowa na zdarzenia Kind (m.in. action, key, mouse, mouseMotion), to musi implementowa interfejs KindListener zdefiniowany w pakiecie java.awt.event: ActionListener, KeyListener, MouseListener i MouseMotionListener. 

Rne zdarzenia mona oddelegowa do tego samego obiektu, jak rwnie to samo zdarzenie moe by oddelegowane do wicej ni jednego obiektu. W kadym przypadku o zajciu zdarzenia s powiadamiane wszystkie oddelegowane do tego obiekty klasy nasuchujcej.

Implementowanie interfejsu zdarzeniowego zobowizuje klas delegowanego obiektu do dostarczenia metod obsugi zdarze, wymienionych w tabeli Metody obsugi zdarze.

Tabela Metody obsugi zdarze
###
    Interfejs    Metody

    ActionListener    actionPerformed

    KeyListener    keyPressed
        keyReleased
        keyTyped

    MouseListener    mousePressed
        mouseReleased
        mouseClicked
        mouseEntered
        mouseExited
    
    MouseMotionListener    mouseMoved
        mouseDragged
###

Nastpujcy aplet, pokazany na ekranie Delegowanie obsugi zdarze, informuje o zajciu zdarze mouse. Do odbioru zdarze oddelegowano widok.

Ekran Delegowanie obsugi zdarze
### delegate.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
    
    public void initView()
    {
        Watcher watcher = new Watcher();
        addMouseListener(watcher);
        addMouseMotionListener(watcher);
    }
    
    public void show(String string)
    {
        clearView();
        showResult(string);
    }        
    
    class Watcher 
        implements MouseListener, 
                   MouseMotionListener {
                   
        public void mousePressed(MouseEvent evt)
        {
            show("Pressed");
        }

        public void mouseReleased(MouseEvent evt)
        {
        }
        
        public void mouseClicked(MouseEvent evt)
        {
            show("Clicked");
        }
        
        public void mouseEntered(MouseEvent evt)
        {
        }
        
        public void mouseExited(MouseEvent evt)
        {
        }
        
        public void mouseMoved(MouseEvent evt)
        {
            int x = evt.getX(),
                y = evt.getY();
            showMsg("x = " + x + ", y = " + y);
        }
        
        public void mouseDragged(MouseEvent evt)
        {
        }
    }
}


[[[Klasy adaptacyjne


Definiowanie klasy obiektw nasuchujcych implementujcej interfejsy deklarujce wiele metod okazuje si do uciliwe. Mona tego unikn, posugujc si klasami adaptacyjnymi.

Klasami adaptacyjnymi s m.in. MouseAdapter i MouseMotionAdapter. Implementuj one odpowiednio interfejsy MouseListener i MouseMotionListener, a ich ciaa zawieraj definicje wszystkich metod implementowanych interfejsw. Dziki temu, jeli jako klasy bazowej uyje si klasy adaptacyjnej, to w klasie pochodnej wystarczy zdefiniowa tylko uywane metody obsugiwania zdarze.

Uwaga: Poniewa mona dziedziczy tylko jedn klas bazow, wic zastosowanie klas adaptacyjnych ogranicza si do przypadku, gdy zbdne jest dziedziczenie innych klas.

Nastpujcy aplet, pokazany na ekranie Uycie klasy adaptacyjnej, ilustruje zastosowanie klasy adaptacyjnej MouseAdapter. Poniewa mona dziedziczy tylko jedn tak klas, wic klasa nasuchujca implementuje take interfejs MouseMotionListener i definiuje z pustym ciaem nie uywana metod obsugi mouseDragged.

Ekran Uycie klasy adaptacyjnej
### adapting.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
    
    public void initView()
    {
        Watcher watcher = new Watcher();
        addMouseListener(watcher);
        addMouseMotionListener(watcher);
    }
    
    public void show(String string)
    {
        clearView();
        showResult(string);
    }        
    
    class Watcher 
        extends MouseAdapter
        implements MouseMotionListener {
                   
        public void mousePressed(MouseEvent evt)
        {
            show("Pressed");
        }

        public void mouseClicked(MouseEvent evt)
        {
            show("Clicked");
        }
                
        public void mouseMoved(MouseEvent evt)
        {
            int x = evt.getX(),
                y = evt.getY();
            showMsg("x = " + x + ", y = " + y);
        }
        
        public void mouseDragged(MouseEvent evt)
        {
        }
    }
}


[[[Obiekty zdarzeniowe


Jeli istnieje obiekt oddelegowany do obsugiwania zdarze, to po zajciu zdarzenia tworzy si obiekt zdarzeniowy, a nastpnie na rzecz obiektu oddelegowanego do obsugi tego zdarzenia wywouje si metod obsugi z odnonikiem do obiektu zdarzeniowego. Argument ten umoliwia rozpoznanie parametrw zdarzenia.


[[[Zdarzenie action

Zdarzenie action jest wysyane m.in. przez przycisk (Button) i klatk (TextField). Odbywa si to bezporednio po klikniciu przycisku albo po naciniciu klawisza Enter, gdy w klatce znajduje si karetka.

Po zajciu zdarzenia action jest wywoywana metoda actionPerformed interfejsu ActionListener. Jej parametr typu ActionEvent umoliwia wywoanie m.in. nastpujcych metod

[[[Object getSource()
Dostarcza odnonik identyfikujcy rdo zdarzenia.

[[[String getActionCommand()
Dostarcza argument wywoanej na rzecz przycisku metody setActionCommand, a domylnie napis na przycisku albo zawarto klatki.


Nastpujcy aplet, pokazany na ekranie Zdarzenia action, oddelegowuje obsug klatki i przycisku Clear do tego samego obiektu nasuchujcego. Nacinicie w klatce klawisza Enter przenosi jej zawarto na widok, a nacinicie przycisku wyczyszcza klatk.
 
Ekran Zdarzenia action
### action.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
    
    private Button clear = new Button("Clear");
    private TextField entry = new TextField(20);
    private String entryData = "";
       
    public void initView()
    {
        setLayout(new FlowLayout());
        
        add(clear);
        add(entry);
        
        Watcher watcher = new Watcher();
        clear.addActionListener(watcher);
        entry.addActionListener(watcher);
    }
    
    public void drawView()
    {
        showResult(entryData);
    }
    
    class Watcher 
        implements ActionListener {       
       
        public void actionPerformed(ActionEvent evt)
        {
            Object source = evt.getSource();
            if(source instanceof Button) {
                entry.setText("");
                entryData = "";
            } else
                entryData = evt.getActionCommand();
                
            redraw();
        }    
    }
}


[[[Zdarzenie key

Zdarzenie key jest wysyane przez dowolny sterownik, na ktry nastawiono celownik. Odbywa si to bezporednio po naciniciu klawisza. 

Uwaga: Do nastawienia celownika suy metoda requestFocus. Mona ja wywoa m.in. na rzecz panelu, przycisku i klatki.

Po zajciu zdarzenia key jest wywoywana stosowna metoda interfejsu KeyListener. Jej parametr typu MouseEvent, umoliwia wywoanie m.in. nastpujcych metod

[[[boolean isCtrlDown()
boolean isShiftDown()
boolean isAltDown()
boolean isMetaDown()
Dostarcza orzecznik, ktrego warto okrela stan nacinicia klawisz Ctrl, Shift, Alt i Meta.

[[[long getWhen()
Dostarcza liczb milisekund od pocztku epoki (1 stycznia 1970) do chwili zajcia zdarzenia.

[[[char getKeyChar()
Dostarcza Unikod znaku.

[[[int getKeyCode()
Dostarcza wirtualny kod klawisza.

Nastpujcy aplet, pokazany na ekranie Zdarzenia key, pokazuje kody Wirtualne i Unikody nacinitych klawiszy. Dla klawisza Enter pokazuje si may kwadracik.
 
Ekran Zdarzenia key
### keyevent.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
    
    private int virCode;
    
    public void initView()
    {
        Watcher watcher = new Watcher();
        addKeyListener(watcher);
    }
    
    class Watcher 
        implements KeyListener {       
       
        public void keyPressed(KeyEvent evt)
        {
            char key = evt.getKeyChar();        
            boolean isUnicode = 
                        key != KeyEvent.CHAR_UNDEFINED;  
            virCode = evt.getKeyCode();      
            if(!isUnicode) 
                showResult("Virtual code = " + virCode);
                
            String msg = "";
            if(evt.isShiftDown())
                msg += "Shift";
            if(evt.isControlDown())
                msg += " & Ctrl";
              showMsg(msg);
        }
    
        public void keyTyped(KeyEvent evt)
        {
            char key = evt.getKeyChar();
            showResult(
                "Virtual code = " + virCode + 
                ", Key = " + key
            ); 
        }
    
        public void keyReleased(KeyEvent evt)
        {
            clearView();
        }
    }
}


[[[Zdarzenia mouse

Zdarzenia mouse i mouseMotion s wysyane przez dowolny sterownik, m.in. przez panel (Panel). Odbywa si to bezporednio po wykonaniu operacji operacji z uyciem myszki, wykonanej na powierzchni sterownika.

Po zajciu zdarzenia mouse albo mouseMotion jest wywoywana stosowna metoda interfejsu MouseListener albo MouseMotionListener. Jej parametr umoliwia wywoanie m.in. nastpujcych metod

[[[boolean isControlDown()
boolean isShiftDown()
boolean isAltDown()
boolean isMetaDown()
Dostarcza orzecznik, ktrego warto okrela stan nacinicia klawisz Ctrl, Shift, Alt i Meta.

[[[long getWhen()
Dostarcza liczb milisekund od pocztku epoki (1 stycznia 1970) do chwili zajcia zdarzenia.

[[[int getClickCount()
Dostarcza liczb klikni wielo-kliknicia, np. dla dwu-kliknicia dostarcza 2.

[[[int getX()
Dostarcza odcit punktu, w ktrym zaszo zdarzenie.

[[[int getY()
Dostarcza rzdn punktu, w ktrym zaszo zdarzenie.


Nastpujcy aplet, pokazany na ekranie Zdarzenia mouse, informuje o wsprzdnych punktu kliknicia i podaje licznik klikni.
 
Ekran Zdarzenia mouse
### mousie.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
    
    private String clickCount = "";
          
    public void initView()
    {               
        Watcher watcher = new Watcher();
        addMouseListener(watcher);
    }
    
    public void drawView()
    {
        showResult(clickCount);
    }
    
    class Watcher 
        extends MouseAdapter {       
       
        public void mouseReleased(MouseEvent evt)
        {
            int count = evt.getClickCount();
            clickCount = "Click count is " + count;    
            int x = evt.getX(),
                y = evt.getY();
            showMsg("x = " + x + ", y = " + y);
            redraw();
        }    
    }
}


 



[[[Grafika 2D




U podstaw obiektowego potraktowania grafiki ley pojcie wykrelacza. Wykrelaczem sterownika, na przykad  wykrelaczem widoku albo apletu, jest systemowy obiekt klasy Graphics2D. Dziki dostpowi do cech urzdzenia obsugujcego sterownik, na obiekcie tym mona wykonywa abstrakcyjne operacje graficzne, niezalene od uytego sprztu i oprogramowania systemowego.

Wygodnym sposobem otrzymania wykrelacza zwizanego z widokiem jest uycie metody drawView z parametrem typu Graphics albo Graphics2D. 

[[[void drawView(Graphics pDC)
void drawView(Graphics2D pDC)
Jest wywoywana po kadym zewntrznym (wzgldem programu) zniszczeniu zawartoci widoku. W swoim parametrze udostpnia odnonik do wykrelacza widoku.

Nastpujcy aplet, pokazany na ekranie Wykrelacz widoku, uywa wykrelacza widoku do wykrelenia napisu Hello from Drawer.

Ekran Wykrelacz widoku
### drawer.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
             
    public void drawView(Graphics2D pDC)
    {
        pDC.drawString("Hello from Drawer", 20, 200);
    }    
}


[[[Wasny wykrelacz


W celu otrzymania odnonika do wasnego wykrelacza, naley na rzecz obiektu sterownika wywoa metod getGraphics. Jeli wykrelacz nie jest ju potrzebny, zaleca si wywoa na jego rzecz metod dispose.

[[[Graphics getGraphics()
Wywoana na rzecz sterownika, dostarcza odnonik typu Graphics do obiektu wykrelacza. Poniewa obiekt wykrelacza jest klasy Graphics2D, w celu uycia najnowszych metod grafiki 2D czsto dokonuje si konwersji dostarczonego odnonika na odnonik typu Graphics2D.

[[[void dispose()
Wywoana na rzecz wykrelacza, oddaje zasoby systemowe wykorzystywane przez wykrelacz.


Nastpujcy aplet, pokazany na ekranie Wasny wykrelacz, wykrela lini cig wzdu drogi przecigania kursora.

Uwaga: Po kadym zdarzeniu mouseMoved jest tworzony odrbny wykrelacz. Znacznie lepszym rozwizaniem byoby utworzenie wykrelacza w initDraw i zapamitanie go w zmiennej globalnej, wykorzystywanej w mouseMoved.

Ekran Wasny wykrelacz
### graphics.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;

public
class Master 
    extends View {
    
    private int xOld, yOld;
    
    public void initView()
    {
        Watcher watcher = new Watcher();
        addMouseListener(watcher);
        addMouseMotionListener(watcher);
    }

    class Watcher 
        extends MouseAdapter
        implements MouseMotionListener {
        
        public void mousePressed(MouseEvent evt)
        {
            xOld = evt.getX();
            yOld = evt.getY();
        }   
        
        public void mouseDragged(MouseEvent evt)
        {
            int x = evt.getX(),
                y = evt.getY();
            Graphics pDC = getGraphics();
            pDC.drawLine(xOld, yOld, x, y);
            pDC.dispose();
            xOld = x;
            yOld = y;
        }
        
        public void mouseMoved(MouseEvent evt)
        {
        }
    }
}


[[[Polecenia


Wykrelanie obiektw graficznych odbywa si za pomoc polece wydawanych wykrelaczowi. Polecenia s implementowane przez metody klasy Graphics2D.

[[[void translate(int x, int y)
Przemieszcza pocztek ukadu wsprzdnych wykrelania do punktu (x, y) okrelonego wzgldem biecego pocztku.

[[[void drawString(String string, int x, int y)
Wykrela napis string pooony na odcinku bazowym, ktrego lewy koniec znajduje si w punkcie (x, y).

[[[void drawLine(xA, yA, xZ, yZ)
Wykrela odcinek czcy punkty o wsprzdnych (xA, yA) i (xZ, yZ).

[[[void drawRect(int x, int y, int w, int h)
Wykrela prostokt o wsprzdnych lewego-grnego wierzchoka (x, y) i rozmiarach w x h pikseli (por. uwaga).

[[[void drawOval(int x, int y, int w, int h)
Wykrela owal (okrg albo elips) wpisany w domylny prostokt, o wsprzdnych lewego-grnego wierzchoka (x, y) i rozmiarach w x h pikseli (por. uwaga).

[[[void drawArc(int x, int y, int w, int h, int f, int t)
Wykrela uk wpisany w domylny prostokt, o wsprzdnych lewego-grnego wierzchoka (x, y) i rozmiarach w x h pikseli, od kta pocztkowego f do kta kocowego t.

[[[void drawPolygon(int x[], int y[], int n)
Wykrela aman czc n punktw o wsprzdnych (x[i], y[i]).

[[[void fillRect(int x, int y, int w, int h)
Wykrela wypeniony prostokt (por. drawRect).

[[[void fillOval(int x, int y, int w, int h)
Wykrela wypeniony owal (por. drawOval).

[[[void fillPolygon(int x[], int y[], int n)
Wykrela wypeniony wielokt (por. drawPolygon).

[[[void clearRect(int x, int y, int w, int h)
Wyczyszcza prostokt z lewym-grnym naronikiem w (x, y), o rozmiarach w x h.

[[[void drawImage(Image image, int x, int y, ImageObserver obs)
Wykrela obraz image, z lewym-grnym naronikiem w (x, y), pod nadzorem obserwatora obs (najczciej apletu, identyfikowanego przez this).

Uwaga: Wykrelajc prostokt i owal (drawRect, drawOval) podaje si wsprzdne lewego-grnego naronika domylnego prostokta, w ktry je wpisano oraz rozmiary tego prostokta zmniejszone o 1. Wykrelajc wypeniony prostokt i owal (fillRect, fillOval, clearRect) podaje si pene rozmiary domylnego prostokta. Wykrelajc odcinek podaje si wsprzdne jego kocw. Do wykrelenia punktu uywa si metody drawLine.

Nastpujcy aplet, pokazany na ekranie Obiekty graficzne, wykrela obszerny zestaw obszarw i linii.

Ekran Obiekty graficzne
### graphobj.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {

    public void drawView(Graphics pDC)
    {
            // przemieszczenie ukadu wsporzdnych
        pDC.translate(100, 100);
    
            // wykrelanie linii i obszarw
        pDC.drawLine(0, 0, 180-1, 180-1);
        pDC.drawRect(0, 0, 180-1, 180-1);
        pDC.setColor(Color.blue);
        pDC.fillRect(0, 50, 60, 50);
        pDC.drawRoundRect(100, 100, 60, 60, 15, 25);
        pDC.drawOval(50, 0, 50, 70);
        pDC.setColor(Color.magenta);
        pDC.fillOval(90, 40, 50, 50);
        pDC.drawArc(80, 80, 40, 40, 0, 270);
        int[] xVec = {  50, 120,  70,  60, },
              yVec = { 100, 150, 150, 180, };
        pDC.fillPolygon(xVec, yVec, 4);
        
            // przemieszczenie ukadu wsporzdnych        
        pDC.translate(-100, -100);
        
            // wykrelenie napisu
        pDC.setColor(Color.black);
        pDC.drawString("Graphics objects", 100, 50);
    }
}


[[[Buforowanie


Wykrelanie grafiki moe si odbywa nie tylko na pulpicie, ale rwnie w buforze pamici operacyjnej. Wymaga to 

1.    Utworzenia bufora.
2.    Utworzenia wykrelacza bufora.
3.    Wydawania polece wykrelaczowi bufora.

Spowoduje to umieszczanie grafiki w buforze.

Do wykonywania operacji buforowanych uywa si m.in. metod createImage, clearRect i drawImage.

[[[Image createImage(int w, int h)
Dostarcza odnonik identyfikujcy obraz znajdujcy si w buforze o rozmiarach w x h.


Nastpujcy aplet, pokazany na ekranie Wykrelanie w buforze, przygotowuje obraz w buforze i dopiero po tym przenosi go na widok.

Ekran Wykrelanie w buforze
### prepare.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private Image buffer;
    private Graphics mDC;
    
    public void initView()
    {
        int w = getWidth(),
            h = getHeight();
        buffer = createImage(w, h); 
        mDC = buffer.getGraphics();
        mDC.clearRect(0, 0, w, h);   // tu zbdne
        mDC.drawLine(0, 0, w-1, h-1);
        mDC.drawLine(w-1, 0, 0, h-1);
    }
    
    public void drawView(Graphics pDC)
    {
        pDC.drawImage(buffer, 0, 0, this);
    }    
}


[[[Kolory


Do wykrelacza mona wstawi kolor: obiekt klasy Color. Umoliwia to realizowanie wykrelania w kolorach.

Do definiowania koloru su konstruktory klasy Color, a zarzdzania kolorami metody setColor i getColor.

[[[Color(r, g, b)
Color(int rgb)
Konstruuje obiekt reprezentujcy kolor o podanych skadowych RGB.

[[[void setColor(Color color)
Wywoana na rzecz wykrelacza, wstawia do niego kolor color.

[[[Color getColor()
Wywoana na rzecz wykrelacza klasy Graphics dostarcza wstawiony do niego kolor.


Nastpujcy aplet, pokazany na ekranie Uycie koloru, wykrela 100 odcinkw o przypadkowych dugociach i kolorach.

Ekran Wykrelanie w buforze
### colorics.gif

import janb.view.*;
import java.awt.*;
import java.util.Random;

public
class Master 
    extends View {
    
    private Random rand = new Random();
    
    public void drawView(Graphics pDC)
    {
        int w = getWidth(),
            h = getHeight(),
            count = 100;
            
        for(int i = 0; i < count ; i++) {
            int random = rand.nextInt(),
                x = getRandom(0, w),
                y = getRandom(0, h);
            pDC.setColor(new Color(random));
            pDC.drawLine(0, 0, x, y);
        }        
    }
}


[[[Piro


Do wykrelacza mona wstawi piro: obiekt klasy implementujcej interfejs Stroke. Umoliwia to definiowanie szerokoci, wygldu i pocze linii.

Wygld linii kreskowanej jest zdefiniowany w tablicy, ktrej kolejne elementy okrelaj na przemian dugo kreski i dugo wystpujcego za ni odstpu.

Poczenie szerokich linii moe by zaostrzone, zaokrglone albo spaszczone. 

1.    Poczenie zaostrzone (JOIN_MITER) polega na przedueniu zewntrznych krawdzi linii, a do ich spotkania.
2.    Poczenie zaokrglone (JOIN_ROUND) polega na wykreleniu koa o promieniu rwnym szerokoci linii.
3.    Poczenie spaszczone (JOIN_BEVEL) polega na poczeniu i wypenieniu zewntrznych naronikw linii.

Zakoczenie linii moe by cite, pkoliste albo kwadratowe.

1.    Zakoczenie cite (CAP_BUTT) polega na pozostawieniu linii bez zmian.
2.    Zakoczenie pkoliste (CAP_ROUND) polega na doczeniu wypenionego pkola o rednicy rwnej szerokoci linii.
3.    Zakoczenie kwadratowe (CAP_SQUARE) polega na doczeniu wypenionego kwadratu o boku rwnym poowie szerokoci linii.

Uwaga: Kolor pira jest identyczny z aktualnym kolorem pdzla.

Do definiowania pir su konstruktory klasy BasicStroke, a do zarzdzania pirami metody setStroke i getStroke.

[[[BasicStroke(float width, int cap, int join, 
            float miter, float[] dash, float phase)
BasicStroke(float width, int cap, int join)
BasicStroke(float width)
Konstruuje piro z szerokoci width, zakoczeniem  cap, poczeniem join, wydueniem miter, kreskowaniem dash i odskoczeniem phase.


[[[void setStroke(Stroke stroke)
Wywoana na rzecz wykrelacza, wstawia do niego piro stroke.

[[[Stroke getStroke()
Wywoana na rzecz wykrelacza, dostarcza wstawione do niego piro.


Nastpujcy aplet, pokazany na ekranie Uycie pira, wykrela przektne widoku liniami przerywanymi o szerokoci 20 pikseli.

Ekran Uycie pira
### penuse.gif

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {
    
    private int w, h;
    
    public void initView()
    {
        Dimension d = getSize();   
        w = d.width;
        h = d.height;
    }
    
    public void drawView(Graphics2D pDC)
    {
            // zdefiniowanie pira
        BasicStroke myStroke = 
            new BasicStroke(
                4f,                        // szeroko
                BasicStroke.CAP_ROUND,     // zakoczenie
                BasicStroke.JOIN_BEVEL,    // poczenie
                0f,                        // wyduenie
                new float[] { 10f, 20f },  // kreskowanie
                0f                         // odskoczenie
            );
        
            // wstawienie pira do wykrelacza
        pDC.setStroke(myStroke);

            // wykrelenie prostokta i przektnych
        pDC.setColor(Color.red);
        pDC.drawRect(w/4, h/4, w/2, h/2);
        pDC.setColor(Color.green);
        pDC.drawLine(0, 0, w-1, h-1);
        pDC.drawLine(w-1, 0, 0, h-1);
    }
}


[[[Pdzel


Do wykrelacza mona wstawi pdzel: obiekt klasy implementujcej interfejs Paint. Umoliwia to malowanie obszarw kolorem, gradientem i tekstur.

Uwaga: Wstawienie do wykrelacza koloru powoduje niejawne wstawienie do niego pdzla malujcego tym kolorem.

Do definiowania pdzli su konstruktory klas Color, GradientPaint i TexturePaint, a do zarzdzania pdzlami metody setPaint i getPaint.

[[[Color(r, g, b)
Konstruuje pdzel reprezentujcy kolor o podanych skadowych RGB.

[[[GradientPaint(x, y, from, w, h, to)
Konstruuje pdzel reprezentujcy gradient, ktry w prostokcie z lewym-grnym naronikiem w (x, y), o rozmiarach w x h reprezentuje gradient od koloru from do koloru to.

[[[TexturePaint(BufferedImage image, Rectangle2D rect)
Konstruuje pdzel reprezentujcy tekstur okrelon przez image z wzorcem w prostokcie rect.


[[[void setColor(Color color)
Wywoana na rzecz wykrelacza, wstawia do niego pdzel (Paint)color.

[[[void setPaint(Paint paint)
Wywoana na rzecz wykrelacza, wstawia do niego pdzel paint.

Paint getPaint()
Wywoana na rzecz wykrelacza, dostarcza wstawiony do niego pdzel.


Nastpujcy aplet, pokazany na ekranie Uycie pdzla, pokrywa widok kolorem, gradientem i tekstur.

Ekran Uycie pdzla
### brushuse.gif

import janb.view.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

public
class Master 
    extends View {
    
    public void drawView(Graphics2D pDC)
    {   
        //  =========================== wykrelenie gradientu

            // zdefiniowanie gradientu
        GradientPaint grad = 
            new GradientPaint(
               100, 100,      // odkd (x,y)
               Color.red,     // od tego koloru
               200, 200,      // dokd (x,y)
               Color.yellow   // do tego koloru
            );
                
             // wstawienie pdzla do wykrelacza
        pDC.setPaint(grad);
       
            // wypenienie koa gradientem
        pDC.fillOval(100, 100, 100-1, 100-1);
        
            // ustawienie koloru
        pDC.setPaint(Color.black);
        
            // wykrelenie okrgu
        pDC.drawOval(100, 100, 100-1, 100-1);
                       
        //  =========================== wykrelenie tekstury

            // zdefiniowanie bufora
        BufferedImage img = 
            new BufferedImage(                
                8, 8,                        // rozmiary
                BufferedImage.TYPE_INT_RGB   // model
            );

               // utworzenie wykrelacza
        Graphics2D mDC = img.createGraphics();
        
            // zdefiniowanie elementu tekstury
        mDC.setPaint(Color.red);
        mDC.drawLine(1, 1, 6, 6);
        mDC.setPaint(Color.yellow);
        mDC.drawLine(1, 6, 6, 1);
       
            // zdefiniowanie wzorca tekstury
        Rectangle2D.Double square = 
            new Rectangle2D.Double(0, 0, 32, 32);       
        TexturePaint textRect = 
            new TexturePaint(img, square);
       
            // wstawienie wzorca do wykrelacza
        pDC.setPaint(textRect);        
       
            // wypenienie koa tekstur
        pDC.fillOval(200, 200, 120-1, 120-1);

            // ustawienie koloru
        pDC.setPaint(Color.green);
     
            // obrysowanie koa
        pDC.setStroke(new BasicStroke(10));            
        pDC.drawOval(200, 200, 120-1, 120-1);
    }
}


[[[Czcionka


Do wykrelacza mona wstawi czcionk: obiekt klasy Font. Umoliwia to wykrelanie napisw stosownie dobran czcionk.

Do definiowania czcionek suy konstruktor klasy Font, a do zarzdzania pdzlami metody setFont i getFont.

[[[Font(String typeFace, int style, int size)
Konstruuje czcionk o kroju typeFace (np. Serif, SansSerif, Monospaced), o stylu style (np. PLAIN, BOLD, ITALIC) i rozmiarze size (wyraonym w punktach).


[[[void setFont(Font font)
Wywoana na rzecz wykrelacza, wstawia do niego czcionk font.

[[[Font getFont()
Wywoana na rzecz wykrelacza, dostarcza wstawion do niego czcionk.


Nastpujcy aplet, pokazany na ekranie Uycie czcionek, wykrela zestaw napisw, posugujc si czcionkami o rnych krojach, rozmiarach i stylach.

Ekran Uycie czcionek
### fontuse.gif

import janb.view.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

public
class Master 
    extends View {
    
    private Font serif = new Font("Serif", Font.BOLD, 50),
                 mono = new Font(
                            "Monospaced", Font.ITALIC, 20
                        ),
                 sans;
 
    public void drawView(Graphics2D pDC)
    {
        pDC.setFont(serif);
        pDC.drawString("Serif font", 50, 80);
            
        pDC.setFont(mono);
        pDC.setColor(Color.red);
        pDC.drawString("Monospaced font", 100, 130);
  
        sans = new Font(
                   "Sansserif", Font.BOLD | Font.ITALIC, 20
               );
               
        pDC.setFont(sans);
        pDC.setColor(Color.blue);        
        pDC.drawString("Sansserif font", 150, 180);  

            // zdefiniowanie gradientu
        GradientPaint grad = 
            new GradientPaint(
               200, 200,      // odkd (x,y)
               Color.red,     // od tego koloru
               300, 300,      // dokd (x,y)
               Color.green    // do tego koloru
            );
                
             // wstawienie pdzla do wykrelacza
        pDC.setPaint(grad);
        
        Font font = new Font("Serif", Font.BOLD, 120);
        pDC.setFont(font);
        pDC.drawString("Serif", 20, 350);
    }
}


[[[Tryb


Do wykrelacza mona wstawi tryb wykrelania. Poniewa dwukrotne wykrelenie obiektu w tym samym trybie XOR powoduje przywrcenie pierwotnego ta wykresu, uycie trybu XOR umoliwia sporzdzanie wykresw prbnych.

Do definiowania trybu wykrelania su metody setXORMode i setPaintMode.

[[[void setXORMode(Color color)
Wywoana na rzecz wykrelacza, dostosowuje go do wykrelania w trybie XOR z podanym kolorem. Kolor wynikowy jest tworzony z podanego koloru, koloru ta i koloru biecego. Reprezentacje tych 3 kolorw, s sumowane pozycyjnie,  modulo-2.

[[[void setPaintMode()
Wywoana na rzecz wykrelacza, dostosowuje go do wykrelania w trybie zwykym.


Nastpujcy aplet, pokazany na ekranie Uycie trybu XOR, wykrela odcinek czcy punkt nacinicia i zwolnienia przycisku myszki. Podczas przecigania kursora jest wykrelany czarny odcinek prbny. Pogrubiony odcinek ostateczny jest wykrelany w kolorze przypadkowym.

Uwaga: Niektre punkty odcinka prbnego nie s czarne, poniewa wykrelanie w trybie XOR uwzgldnia kolor ta.

Ekran Uycie trybu XOR
### xoruse.gif

import janb.view.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Random;

public
class Master 
    extends View {

    private int Thick = 6;
    private BasicStroke stroke = 
        new BasicStroke(Thick);
    private Graphics2D pDC;

    public void initView()
    {
        MouseWatcher watcher = new MouseWatcher();
        addMouseListener(watcher);
        addMouseMotionListener(watcher);
        pDC = (Graphics2D)getGraphics();
    }
    
    class MouseWatcher 
        extends MouseAdapter
        implements MouseMotionListener {

        private Random rand = new Random();
        private int x0, y0, xOld, yOld;

        public void mousePressed(MouseEvent evt)
        {
            x0 = xOld = evt.getX();
            y0 = yOld = evt.getY();
            pDC.setColor(Color.black);
            pDC.setXORMode(Color.white);
            pDC.drawLine(x0, y0, xOld, yOld);
        }

        public void mouseDragged(MouseEvent evt)
        {
            pDC.drawLine(x0, y0, xOld, yOld);
            int x = evt.getX(),
                y = evt.getY();
            pDC.drawLine(x0, y0, x, y);
            xOld = x;
            yOld = y;
        }

        public void mouseReleased(MouseEvent evt)
        {
            pDC.setPaintMode();
            pDC.setColor(new Color(rand.nextInt()));
            pDC.setStroke(stroke);
            pDC.drawLine(x0, y0, evt.getX(), evt.getY());            
        }

        public void mouseMoved(MouseEvent evt)
        {
        }
    }
}


 



[[[Zadania




Kademu, kto chce si upewni, e zrozumia zasady programowania obiektowego, mona zaproponowa nastpujce zadanie


    Zrezygnowa z uywania biblioteki View, a kady aplet podany w pierwszej czci ksiki zapisa tak, aby 

    1.    Wyglda identycznie (z widokiem i klatk wcznie).
    2.    Zapewnia odtwarzanie pulpitu w metodzie paint.
    3.    Dla kadego rzeczownika, ktry pojawi w analizie rozwizywanego problemu stosowa odrbn klas.
    4.    Wszdzie tam gdzie jest to moliwe, stosowa hermetyzacj, dziedziczenie i polimorfizm.

Nastpujce aplety, ktre

    Wykrelaj w punkcie kliknicia napis wprowadzony z klatki, ale jeli jest on liczb cakowit, o wartoci wikszej ni 20, to wykrelaj kolorowy piercie, o promieniu okrelonym przez t liczb.

ilustruj wykonanie takich zada.

Ekran Napisy i piercienie
### viewjob.gif


[[[Z bibliotek

    
Aplet ilustruje, jak wygodna w uyciu jest biblioteka View. Jego przeanalizowanie nie powinno sprawi adnych trudnoci.


Plik Project.html

<applet code=janb.view.Master.class
        width=400 height=420>
</applet>


Plik Master.java

import janb.view.*;
import java.awt.*;

public
class Master 
    extends View {           // dziedziczy klas View
    
    private int radius;
    private String string = "Hello";
    private Figures figures = getFigures();
    private Font font;
    
    public void initView()
    {
        font = getFont("Serif", BoldItalic, 30);
        setFont(font);
        addButton(getButton("Clear"));
    }
    
    public void buttonPressed(Button button)
    {
        clearView();
        figures = getFigures();
    }
    
    public void dataEntered(String data)
    {
        string = null;
        if(isIntegral(data)) {
            radius = getInt(data);
            if(radius < 20) {
                beep();
                string = trim(data);
            }
        } else
            string = data;          
    }
    
    public void mouseReleased(int x, int y)
    {
        Figure figure = null;
        if(string == null) {
            int r = radius;            
                // utworzenie piercienia
            setStroke(10);
            setPaint(getColor());            
            figure = getCircle(x-r, y-r, 2*r); 
            setFill(figure, Ring);           
        } else {
               // utworzenie napisu               
           Metrics metrics = getMetrics(string);
           int w2 = getWidth(metrics)/2,
               h2 = getHeight(metrics)/2;
           setStroke(1);
           setPaint(getColor());
           figure = getString(x-w2, y-h2, string);           
        }

            // dodanie obiektu do bazy danych
        figures.add(figure);
            
           // wykrelenie obiektu
        drawFigure(figure);
    }
    
    public void drawView()
    {
        drawFigures(figures);
    }
}

    
[[[Bez biblioteki


Aplet napisano z naddatkiem moliwoci, tak aby zawarte w nim pomysy mona byo wykorzysta w innych apletach oraz do analizy Biblioteki View.

Uwaga: Jeli przerobienie apletu spowoduje, e przestanie on dziaa i bdzie wymagao uycia uruchamiacza, to poleca si uycie uruchamiacza Debug (a nie Debugger!) opisanego w ksice Java 3. W takim wypadku, poza uyciem fabrykatora new Debug(), bdzie konieczne uycie polecenia importu klas janb.debug.* oraz zdefiniowanie w kompilatorze cieki do katalogu janb\debug zawierajcego pliki *.class uruchamiacza.


Plik Project.html

<applet code=janb.noview.Master.class
        width=400 height=400>
</applet>


Plik Master.java

package janb.noview;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;

public
class Master 
    extends Applet           // dziedziczy klas Applet
    implements Names {

    private int radius;
    private String string = "Hello";
    private Figures$ figures = new Figures$();
    private Random rand = new Random();
    private Toolkit kit = 
        Toolkit.getDefaultToolkit();
    private Font font;
    private Button button;
    private TextField textField;
    private int w, h;
    private static Graphics2D pDC;
    
    public void init()
    { 
        setLayout(null);
        
        pDC = (Graphics2D)getGraphics();
        
        font = new Font(
                   "Serif", Font.BOLD | Font.ITALIC, 30
               );
        pDC.setFont(font);
        
        button = new Button("Clear");
        button.setBounds(0, 0, 60, 35);
        add(button);

        w = getWidth();
        h = getHeight();
        
        textField = new TextField(50);
        textField.setBounds(0, h-20, w, h);
        add(textField);
        
        Watcher watcher = new Watcher();
        button.addActionListener(watcher);
        textField.addActionListener(watcher);
        addMouseListener(watcher);
    }
    
    public void paint(Graphics gDC)
    {   
        Graphics2D pDC = (Graphics2D)gDC;
        figures.drawFigures(pDC);
    }    
    
    class Watcher
        extends MouseAdapter
        implements ActionListener {

        public void actionPerformed(ActionEvent evt)
        {
            Object source = evt.getSource();
            if(source instanceof Button) {
                pDC.clearRect(0, 0, w, h);
                figures = new Figures$();
            } else if(source instanceof TextField) {
                String data = textField.getText();
                if(data.trim().equals("")) {
                    kit.beep();
                    return;
                }
                string = null;                
                try {
                    radius = Integer.parseInt(data);
                }
                catch(NumberFormatException e) {
                    string = data.trim();
                    return;
                }
                
                if(radius < 20) {
                    kit.beep();
                    string = data.trim();
                }
            } else
                System.out.println("Error: Impossible");
        }
        
        public void mouseReleased(MouseEvent evt)
        {
            int x = evt.getX(),
                y = evt.getY();
            Figure figure = null;
            if(string == null) {
                int r = radius;            
                    // utworzenie piercienia
                pDC.setStroke(new BasicStroke(10));
                pDC.setPaint(getColor());  
                figure = new Ellipse(x-r, y-r, 2*r, pDC); 
                figure.setFill(Ring);           
            } else {
                   // utworzenie napisu               
               Metrics metrics = getMetrics(string, font);
               int w2 = metrics.getWidth()/2,
                   h2 = metrics.getHeight()/2;
               pDC.setStroke(new BasicStroke(1));
               pDC.setPaint(getColor());
               figure = new String$(x-w2, y-h2, string, pDC);
            }
    
                // dodanie obiektu do bazy danych
            figures.add(figure);
                
               // wykrelenie obiektu
            figure.draw(pDC);
        }
    }

    public Color getColor()
    {    
        Color color;
        int max3, min3, r, g, b;
        do {
            int rnd = rand.nextInt();
            color = new Color(rnd);
            r = color.getRed();
            g = color.getGreen();
            b = color.getBlue();
            max3 = Math.max(Math.max(r, g), b);
            min3 = Math.min(Math.min(r, g), b);
        } while(max3 - min3 < 20);
        return color;
    } 
                   
    public Metrics getMetrics(String string, Font font)
    {
        FontRenderContext frc = 
            pDC.getFontRenderContext();   
        TextLayout layout = 
            new TextLayout(string, font, frc);
        return new Metrics(layout);
    }
}

class Figures
    extends Vector {
    
    public void addFigure(Figure figure)
    {
        addFigure(figure);
    }
    
    public Figure getFigure(int pos)
    {
        return (Figure)elementAt(pos);
    }
       
    public void drawFigures(Graphics2D gDC)
    {
        int count = size();
        for(int i = 0; i < count ; i++)
            ((Drawable)elementAt(i)).draw(gDC);
    }
}

interface Drawable {

    public void draw(Graphics2D gDC);
}

abstract 
class Figure
    implements Names, Drawable {
    
    protected static int defWidth = 100;
    protected static Paint defPaint = Color.red;
    protected static Font defFont = 
                         Names.SerifBoldItalic30;
    protected static Stroke defStroke = Names.Stroke_1;
    protected static int defFill = Names.Ring;
    private int x, y, w, h;
    private Paint paint;
    private Stroke stroke;
    private Font font;
    private int fill;
        
    public Figure(int x, int y, int w, int h, Graphics gDC)
    {
        Graphics2D pDC = (Graphics2D)gDC;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;        
        if(gDC != null) {
            paint  = pDC.getPaint();
            stroke = pDC.getStroke();
            font   = pDC.getFont();
        } else {
            paint  = defPaint;
            stroke = defStroke;
            font   = defFont;
        }
        fill = defFill;
    }
    
    abstract public void draw(Graphics2D gDC);
                  
    public int getX()
    {
        return x;
    }
    
    public int getY()
    {
        return y;
    }
    
    public int getWidth()
    {
        return w;
    }
    
    public int getHeight()
    {
        return h;
    }    
        
    public Paint getPaint()
    {
        return paint;
    }
    
    public Stroke getStroke()
    {
        return stroke;
    }
        
    public Font getFont()
    {
        return font;
    }    
    
    public int getFill()
    {
        return fill;
    }        
    
    public void setXY(int x, int y)
    {
        this.x = x;
        this.y = y;
    }
       
    public void setSize(int w, int h)
    {
        this.w = w;
        this.h = h;
    }
    
     public void setPaint(Paint paint)
    {
        this.paint = paint;
    }
    
    public void setStroke(Stroke stroke)
    {
        this.stroke = stroke;
    }
    
    public void setFont(Font font)
    {
        this.font = font;
    }    
    
    public void setFill(int fill)
    {
        this.fill = fill;
    }
}

class Ellipse 
    extends Figure {    
    
    public Ellipse(int x, int y, int w, int h, Graphics gDC)
    {
        super(x, y, w, h, gDC);
    }
    
    public Ellipse(int x, int y, int w, int h)
    {
        this(x, y, w, h, null);
    }
    
    public Ellipse(int x, int y, int d, Graphics gDC)
    {
        this(x, y, d, d, gDC);
    }        
       
    public Ellipse(int x, int y, int d)
    {
        this(x, y, d, d, null);
    }    
    
    public Ellipse(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        Stroke oldStroke = gDC.getStroke();
        gDC.setStroke(getStroke());
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();
        switch(getFill()) {
            case 0:    // Line
                gDC.setStroke(Stroke_1);
                gDC.drawOval(x, y, w-1, h-1);
                break;
            case 1:    // Ring     
                BasicStroke basicStroke = 
                    (BasicStroke)getStroke();
                int width = 
                    (int)(basicStroke.getLineWidth()),
                    x2 = x + width/2,
                    y2 = y + width/2,
                    dW = w - width,
                    dH = h - width;
                gDC.setStroke(getStroke());
                gDC.drawOval(x2, y2, dW-1, dH-1);
                gDC.setColor(Color.black);
                gDC.setStroke(Stroke_1);
                gDC.drawOval(x, y, w-1, h-1);
                x += width;
                y += width;                                
                int ww = w - 2 * width,
                    hh = h - 2 * width;
                gDC.drawOval(x, y, ww-1, hh-1);
                break;
            case 2:    // Full  
                Paint paint = gDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+w, y+h,
                               colorZ
                           ); 
                    gDC.setPaint(grad);
                }
                gDC.fillOval(x, y, w, h);
                gDC.setStroke(new BasicStroke(1));
                gDC.setColor(Color.black);
                gDC.drawOval(x, y, w-1, h-1);
        }            
        gDC.setStroke(oldStroke);
        gDC.setPaint(oldPaint);
    }
}

class String$ 
    extends Figure {    
    
    private String string;
    private Rectangle2D bounds;
    private TextLayout layout;
    
    public String$(int x, int y, String string, Graphics gDC)
    {
        super(x, y, -1, -1, gDC);
        this.string = string;
        bounds = getBounds(string, getFont(), gDC);
        setSize(
            (int)bounds.getWidth(),
            (int)bounds.getHeight()
        );
    }
        
    public static Rectangle2D getBounds(
                                  String string, 
                                  Font font, 
                                  Graphics gDC
                              )
    {
        Graphics2D pDC = (Graphics2D)gDC;
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        TextLayout layout = 
            new TextLayout(string, font, frc);
        return new TextLayout(string, font, frc).
               getBounds();
    }                
    
    public static TextLayout getLayout(
                                 String string, 
                                 Font font,
                                 Graphics gDC)
    {     
        Graphics2D pDC = (Graphics2D)gDC;   
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        return new TextLayout(string, font, frc);
    }            
            
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        Font oldFont = gDC.getFont();
        gDC.setPaint(getPaint());
        gDC.setFont(getFont());

        int xL = getX(),
            yL = getY();
        TextLayout layout = 
            getLayout(string, getFont(), gDC);
        Rectangle2D bounds = layout.getBounds();
        float xB = (float)bounds.getX(),
              yB = (float)bounds.getY();
        layout.draw(gDC, -xB + xL, -yB + yL);
        gDC.setFont(oldFont);
        gDC.setPaint(oldPaint);
    }
}
class Metrics {

    private TextLayout layout;
    private Rectangle2D bounds;
    
    public Metrics(TextLayout layout)
    {
        this.layout = layout;
        bounds = layout.getBounds();
    }
    
    public int getWidth()
    {
        return (int)bounds.getWidth();
    }
    
    public int getHeight()
    {
        return (int)bounds.getHeight();
    }    
    
    public int getAscent()
    {
        return (int)layout.getAscent();
    }    

    public int getDescent()
    {
        return (int)layout.getDescent();
    }        
}

interface Names {

    public double Pi = Math.PI;
               
    public final int 
        Line = 0,
        Ring = 1,
        Full = 2;
        
    public final Font 
        SerifBoldItalic30 =
            new Font("Serif", Font.BOLD | Font.ITALIC, 30);
         
    public final Stroke
        Stroke_1 = new BasicStroke(1);
             
    public final Color 
        Red     = Color.red,
        Green   = Color.green,
        Blue    = Color.blue,
        Cyan    = Color.cyan,
        Magenta = Color.magenta,
        Yellow  = Color.yellow,
        Black   = Color.black,
        White   = Color.white;
}

 



[[[Biblioteka View




Jeli w klasycznym nauczaniu programowania najpierw wykada si jzyki C i C++, a dopiero po nim Jav, to dlaczego nie ograniczy si do Javy, ale najpierw poda j w postaci podobnej do C, a nastpnie w postaci podobnej do C++. W ten sposb mona cakowicie zrezygnowa z C i C++, a Jav wyoy jako jedyny jzyk programowania. Tak wanie uczyniono w niniejszej ksice.

W celu zrealizowania tak postawionego zadania, utworzono wyspecjalizowana Bibliotek, implementowana przez klasy pakietu view wraz z jego gwn klas View. Zapoznanie si z implementacj pakietu jest wartociow inwestycja w programowanie obiektowe. Dlatego wersj 1.0 Biblioteki przytoczono tu w caoci. Na doczonej dyskietce znajduje si nieznacznie ulepszona wersja 1.1, rozszerzona o funkcje nieudokumentowane. Ewentualne dalsze wersje bd umieszczane w serwerze Wydawnictwa.


[[[Zaoenia implementacyjne


Przyjmuje si, e posugujcy si klas View uyje jej jako klasy bazowej swojego apletu

import janb.view.View;

// ...

public 
class Master 
    extends View {

   // ...
}

oraz e pod adnym pozorem nie zdefiniuje w klasie Master bezparametrowej funkcji init

public void init()
{
    // ...
}


Uwaga: Nie wyklucza si uycia metod start, stop i destroy. Nie zabrania si uycia metody paint, poniewa zostanie zignorowana, ale zwraca si uwag, e rol init powinna peni funkcja initView, a rol paint funkcja drawView.

Jeli te wymagania zostana spenione, to funkcja init klasy View

    1.    Utworzy pulpit skadajcy si z widoku i klatki.
    2.    Pozbawi widok zarzdcy rozkadu.
    3.    Tak przygotuje obsug zdarzenia action, e nacinicie klawisza Enter, gdy celownik jest nastawiony na klatk, spowoduje wywoanie metody dataEntered.
    4.    Tak przygotuje obsug zdarze mouse widoku, e wykonanie za pomoc myszki akcji na widoku spowoduje wywoanie metody grupy mouseXXX (np. mouseReleased).
    5.    Tak przygotuje obsug zdarze key widoku, e nacinicie klawisza gdy celownik jest nastawiony na widok, spowoduje wywoanie metody grupy keyXXX (np. keyTyped).
    6.    Stworzy warunki umoliwiajce posugiwanie si buforowaniem (funkcje toBuffer i toScreen).
    7.    Wyposay aplet w uruchamiacz umoliwiajcy posugiwanie si funkcjami dbg.
    8.    Stworzy warunki do tego, aby wykonanie funkcji startRun powodowao utworzenie i odpalenie niezalenego przepywu sterowania przez funkcj run.
    9.    Uniemoliwi zmian rozmiarw apletu zawierajcego widok i klatk.
    10.    Wstpnie nastawi celownik na klatk.


[[[Obsugiwanie zdarze


Moliwo definiowania apletu jako zestawu metod obsugi zdarze, m.in. dataEntered, keyPressed, mouseMoved, wynika z zastosowania polimorfizmu. Wyjania to nastpujcy przykad.

Aby mona byo w aplecie umieci dowoln z przecionych metod mouseXXX na przykad

public 
class Master
    extends View 

    public void mouseReleased(int x, int y)
    {
        // ...
    }
}
    
w miejscu rozpoznania zdarzenia mouse jest wywoywana metoda

public void mouseReleased(int x, int y, int flags)

klasy View, ale w tej klasie dostarcza si dwie metody

public void mouseReleased(int x, int y, int flags)
{
    mouseReleased(int x, int y)
}

int void moouseReleased(int x, int y)
{
}

Ma to nastpujcy skutek

    1.    Jeli w klasie Master dostarczy si tylko metod 2-parametrow, to zostanie wywoana wanie ona.
    2.    Jeli w klasie Master dostarczy si tylko metod 1-parametrow, to zostanie wywoana 2-parametrowa metoda klasy View, ta wywoa 1-parametrow metod klasy View, a to spowoduje wywoanie 1-parametrowej metody klasy Master.
    3.    Jeli w klasie Master dostarczy si 2 metody, to zostanie wywoana tylko 2-parametrowa.
    4.    Jeli w klasie Master nie dostarczy si ani jednej metody, to zdarzenie zostanie zignorowane.

Jeli to, co napisano powyej, nie budzi adnych wtpliwoci, to czytajcy biegle opanowa zasady polimorfizmu.


[[[Wprowadzanie danych


Wygodnym sposobem komunikowania si z otoczeniem apletu jest pobieranie danych z klatki. Problem polega jedynie na tym, e wprowadzanie danych z klatki odbywa si asynchronicznie z wykonaniem apletu. Powoduje to, e jeli wykonanie metody dataEntered wie si z wykonaniem czasochonnego procesu obliczeniowego, to a do chwili zakoczenia tej metody aplet staby si niewraliwy na zdarzenia zewntrzne, w tym na nacinicie klawisza Enter. 

Aby problemowi temu zaradzi, zastosowano nastpujce rozwizanie

    1.    Po naciniciu klawisza Enter w klatce, dana zostaje odebrana i przechowana, do chwili, gdy moe j odebra metoda dataEntered. 
    2.    Sama metoda jest wykonywana w odrbnym wtku. Jeli miaoby to kolidowa z innymi wtkami, na przykad z wtkami do obsugi zdarze mouse, naley zastosowa sychronizacj.

Mechanizm asynchronicznego wprowadzania danych jest wstpnie wczony. Do jego wczania i wyczania suy funkcja setSeparate.

[[[boolean setSeparate(boolean separate)
Ustawia sposb obsugiwania danych zgodnie z wartoci separate. Dla wartoci true, metody dataEntered s wykonywane w odrbnym wtku. Dostarcza informacji o uprzednim sposobie obsugiwania danych.


 

[[[//*** Interfejs Names


package janb.view;

import java.awt.*;
import java.awt.event.KeyEvent;

public
interface Names {

    public double Pi = Math.PI;
    
    public final Font 
        SerifBoldItalic30 =
            new Font("Serif", Font.BOLD | Font.ITALIC, 30);
         
    public final Stroke
        Stroke_1 = new BasicStroke(1);    
        
    public final int 
        Left   = Label.LEFT,
        Right  = Label.RIGHT,
        Center = Label.CENTER;        

    public final String 
        Serif      = "Serif",
        Sansserif  = "Sansserif",
        Monospaced = "Monospaced";
        
    public final int
        Bold       = Font.BOLD,
        Italic     = Font.ITALIC,
        BoldItalic = Bold | Italic,
        Plain      = Font.PLAIN;
               
    public final int 
        Line = 0,
        Ring = 1,
        Full = 2;
         
    public final Color 
        Red     = Color.red,
        Green   = Color.green,
        Blue    = Color.blue,
        Cyan    = Color.cyan,
        Magenta = Color.magenta,
        Yellow  = Color.yellow,
        Black   = Color.black,
        White   = Color.white;
        
    public final int
        JoinMiter = BasicStroke.JOIN_MITER,
        JoinRound =  BasicStroke.JOIN_ROUND,
        JoinBevel =  BasicStroke.JOIN_BEVEL,
        CapButt   =  BasicStroke.CAP_BUTT,
        CapRound  =  BasicStroke.CAP_ROUND,        
        CapSquare =  BasicStroke.CAP_SQUARE;

    public final boolean
        Input  = false,
        Output = true;        
        
    public final int 
        NotNumeric = Integer.MIN_VALUE,
        MaxInt = Integer.MAX_VALUE,
        MinInt = Integer.MIN_VALUE;   
        
    public int Flow   = 0,
               Border = 1,
               Grid   = 2;
        
    public final int
        UpKey    = KeyEvent.VK_UP,
        DnKey    = KeyEvent.VK_DOWN,
        LtKey    = KeyEvent.VK_LEFT,
        RtKey    = KeyEvent.VK_RIGHT,
        HomeKey  = KeyEvent.VK_HOME,
        EndKey   = KeyEvent.VK_END,
        InsKey   = KeyEvent.VK_INSERT,
        DelKey   = KeyEvent.VK_DELETE,
        EnterKey = KeyEvent.VK_ENTER,
        SpaceKey = KeyEvent.VK_SPACE,
        BkSpKey  = KeyEvent.VK_BACK_SPACE,
        PgUpKey  = KeyEvent.VK_PAGE_UP,
        PgDnKey  = KeyEvent.VK_PAGE_DOWN,
        TabKey   = KeyEvent.VK_TAB,
        ShiftKey = KeyEvent.VK_SHIFT,
        CtrlKey  = KeyEvent.VK_CONTROL,
        AltKey   = KeyEvent.VK_ALT,
        
        F1Key    = KeyEvent.VK_F1,
        F2Key    = KeyEvent.VK_F2,
        F3Key    = KeyEvent.VK_F3,
        F4Key    = KeyEvent.VK_F4,
        F5Key    = KeyEvent.VK_F5,
        F6Key    = KeyEvent.VK_F6,
        F7Key    = KeyEvent.VK_F7,
        F8Key    = KeyEvent.VK_F8,
        F9Key    = KeyEvent.VK_F9,
        F10Key   = KeyEvent.VK_F10,
        F11Key   = KeyEvent.VK_F11,
        F12Key   = KeyEvent.VK_F12;
}


[[[//*** Interfejs Drawable


package janb.view;

import java.awt.Graphics2D;

public
interface Drawable {

    public void draw(Graphics2D gDC);
}
 

[[[//*** Klasa View


package janb.view;

import java.applet.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.awt.font.*;
import java.util.*;

import java.lang.reflect.*;
import java.net.*;
import java.io.*;

public    
class View
    extends Applet
    implements Names, Runnable {    

    private static boolean initViewDone   = false;    
    private static boolean viewClassUsed  = false;
    private static boolean separateThread = true;
    public View()
    {
        if(viewClassUsed) {
            error("Only one View allowed!");
            System.exit(0);
        } else
            viewClassUsed = true;
    }
        
    private static boolean firstPaint  = true, 
                           viewVisible = false,
                           viewReady   = false;
    private static Toolkit kit = 
        Toolkit.getDefaultToolkit();
    private static int w, h;    
    private static int pX, pY;
    private static Dimension d;
    private static View view;    
    private static ViewPanel panel;
    protected static ViewPanel viewPanel;
    protected static Graphics2D pDC, pDC1, pDC2;
    private static TextField textField;
    private static int dH = 20;        
    private static int size = 30, fill = Ring;
    private static Font resultFont = 
        new Font("Serif", Font.BOLD | Font.ITALIC, 30);
    private static Stroke thinStroke = new BasicStroke(1);
    private static Random rand = new Random();   
    private static Vector dataVector = new Vector();
    private static Object dataLock = new Object();
    private static boolean dataReady = false;
    private static int dataPos = 0;
    private static ButtonWatcher buttonWatcher;
    private static MediaTracker tracker;
    private static Image buffer;
    private static boolean isBuffered = false,
                           isDebugged = false;
    private static Point dbgLoc;
    private static Dimension dbgSize;
         
    public void init()    
    {
        view = this;
        
        setLayout(new BorderLayout());

        d = getSize();
        w = d.width;
        h = d.height - dH;
        setSize(w, d.height); 
        
        panel = new ViewPanel();   
        viewPanel = panel;
        add(panel, BorderLayout.CENTER);
        panel.setLayout(null);        
                
        MouseWatcher mouseWatcher = new MouseWatcher(panel);
        panel.addMouseListener(mouseWatcher);
        panel.addMouseMotionListener(mouseWatcher);         
        
        KeyWatcher keyWatcher = new KeyWatcher(panel);
        panel.addKeyListener(keyWatcher);
        panel.requestFocus();        
        
        textField = new DataField();
        add(textField, BorderLayout.SOUTH);               
                      
        textField.addActionListener(
            new ActionListener() {
                public void
                actionPerformed(ActionEvent evt)
                {
                    String str = evt.getActionCommand();
                    if(str.trim().equals("")) {
                        showMsg("Empty data line!");
                        beep();
                        textField.setText("");
                        requestFocus();
                        panel.requestFocus();
                        return;
                    }

                    Vector vec = new Vector();
                    while(!(str = str.trim()).equals("")) {
                        str += ' ';
                        int i = str.indexOf(' ');
                        vec.add(str.substring(0, i));
                        str = str.substring(i);
                    }
                    
                    int size = vec.size();
                    String[] data = new String [size];
                    for(int i = 0; i < size ; i++) {
                        data[i] = (String)vec.elementAt(i);
                    }
                    
                    synchronized(dataLock) {
                        if(separateThread) {
                            dataVector.add(data);
                            dataReady = true;
                            dataLock.notify();
                        } else {
                            dataEntered(data);
                            return;
                        }
                    }
                }
            }
        );
        
        new Reader();
        
        buttonWatcher = new ButtonWatcher();
               
        pDC = pDC2 = (Graphics2D)panel.getGraphics();   
        pDC1 = (Graphics2D)panel.getGraphics();   
        Font font = pDC.getFont();
        pDC.setFont(font);
        pDC1.setFont(font);

        Point loc = getLocation();
        dbgLoc  = new Point(loc.x + w + 10, loc.y);
        dbgSize = new Dimension(200, h + dH);
        
        requestFocus();
        panel.requestFocus();
    }
    
    class Reader 
        extends Thread {
        
        public Reader()
        {
            this.start();
        }
        
        public void run()
        {
            while(true) {
                synchronized(dataLock) {
                    while(!dataReady) {
                        try {
                            dataLock.wait();
                        }
                        catch(InterruptedException e) {
                        }
                    }
                    String[] data = 
                        (String [])dataVector.
                                   elementAt(dataPos);
                    dataVector.set(dataPos++, null);
                    panel.requestFocus();
                    if(data.length > 1)
                        dataEntered(data);
                    else if(data[0].length() > 1)
                        dataEntered(data[0]);
                    else
                        dataEntered(data[0].charAt(0));
                    dataReady = false;
                }
            }
        }
    }
    
    // ============================================= Panel
                           
    class ViewPanel
        extends Panel {
                
        class RunView
            extends Thread {
            
            public RunView()
            {
                this.start();
            }
            
            public void run()
            {
                runView();
            }
        }
               
        public void paint(Graphics pDC)
        {
            if(firstPaint) {
                firstPaint  = false;
                viewVisible = true;
                viewReady   = true;  
                if(!initViewDone) {
                    view.requestFocus();
                    textField.requestFocus();
                    initView(); 
                    new RunView();
                }
                if(!isValid()) {
                   viewReady = false;
                   validate();
                   viewReady = true;
                }
                if(!initViewDone)
                    startView();
                initViewDone = true;
            }
            Dimension d2 = view.getSize();             
            if(!d2.equals(d)) {      
                view.setSize(w, h + dH);
            }
            drawView((Graphics2D)pDC);            
        }                
        
        public Dimension getPreferredSize()
        {
            return new Dimension(w, h);
        }
        
        public Graphics2D getGraphics2D()
        {
            return (Graphics2D)this.getGraphics();
        }
        
        public void addButton(Button button)
        {
            super.add(button);
        }
        
        public void addButton(Button button, int pos)
        {
            super.add(button, pos);
        }               
        
        public void addLabel(Label label)
        {
            super.add(label);
        }
        
        public void addLabel(Label label, int pos)
        {
            super.add(label, pos);
        }       
    }
    
    class DataField 
        extends TextField {
        
        public Dimension getPreferredSize()
        {
            return new Dimension(100, dH);
        }
    }

    public void initView()
    {
    }
    
    public void startView()
    {
    }
    
    public void stopView()
    {
    }
    
    public void drawView(Graphics2D pDC)
    {
        drawView((Graphics)pDC);
    }
    
    public void drawView(Graphics pDC)
    {
        drawView();
    }
    
    public void drawView()
    {
    }
    
    public void exitView()
    {
        System.exit(0);
    }        
    
    public void destroyView()
    {
    }
    
    public void start()
    {
        if(firstPaint)
            return;
        view.startView();
    }
    
    public void stop()
    {
        view.stopView();
    }
    
    public void destroy()
    {
    }
    
    // ============================================= Metrics

    public static TextLayout getLayout(String string, 
                                       Font font, 
                                       Graphics2D gDC)
    {
        FontRenderContext frc = gDC.getFontRenderContext();
        return new TextLayout(string, font, frc);
    }    
        
    public static TextLayout getCurrentLayout(String string,
                                              Font font)
    {
        return getLayout(string, font, pDC);
    }    
    
    public static Metrics getMetrics(String string,
                                     Font font,
                                     Graphics2D gDC)
    {
        TextLayout layout = getLayout(string, font, gDC);
        return new Metrics(layout);
    }
    
    public static Metrics getMetrics(String string,
                                     Font font)
    {
        TextLayout layout = getLayout(string, font, pDC);
        return new Metrics(layout);
    }
    
    public static Metrics getMetrics(String string)
    {
        TextLayout layout = 
            getLayout(string, getCurrentFont(), pDC);
        return new Metrics(layout);
    }    
    
    public static Metrics getCurrentMetrics(String string,
                                            Font font)
    {
        TextLayout layout = getLayout(string, font, pDC);
        return new Metrics(layout);
    }
    
    public static int getWidth(Metrics metrics)
    {
        return metrics.getWidth();
    }
    public static int getHeight(Metrics metrics)
    {
        return metrics.getHeight();
    }
        
    public static int getAscent(Metrics metrics)
    {
        return metrics.getAscent();
    }
    
    public static int getDescent(Metrics metrics)
    {
        return metrics.getDescent();
    }    
              
    public static Rectangle2D getBounds(String string, 
                                        Font font)
    {
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        TextLayout layout = new TextLayout(string, font, frc);
        return new TextLayout(string, font, frc).getBounds();
    }
                    
    // ============================================== Graphics
    
    public void clearView(int x, int y, int w, int h)
    {
        pDC.clearRect(x-1, y-1, w+2, h+2);    
    }    
    
    public void clearView(int x, int y, int s)
    {
        clearView(x, y, s, s);
    }
    
    public void clearView()
    {
        clearView(0, 0, w, h);
    }
              
    public void showMsg(String msg)
    {
        showStatus(msg);
    }
    
    public void showMsg(long msg)
    {
        showMsg("" + msg);
    }
    
    public void repaint()
    {
        redraw();
    }
    
    public void redraw()
    {
        clearView();
        drawView(pDC);
    }
    
    // ============================================= Figures
           
    public Figure getPixel(int x, int y, Graphics gDC)
    {
        return new Pixel(x, y, gDC);
    }
    
    public Figure getPixel(int x, int y)
    {
        return new Pixel(x, y, pDC);
    }    
    
    public Figure getString(int x, int y, 
                            String string, Graphics gDC)
    {
         return new String$(x, y, string, gDC);   
    }
       
    public Figure getString(int x, int y, String string)
    {
        return new String$(x, y, string, pDC);
    }
       
    public Figure getLine(int xA, int yA, 
                          int xZ, int yZ, Graphics gDC)
    {
        return new Line(xA, yA, xZ, yZ, gDC);
    }
    
    public Figure getLine(int xA, int yA, 
                          int xZ, int yZ)
    {
        return new Line(xA, yA, xZ, yZ, pDC);
    }    

    public Figure getImage(int x, int y, 
                           int w, int h, Image image)
    {
        return new Image$(x, y, w, h, image, this);            
    }
    
    public Figure getImage(int x, int y, Image image)
    {
        return new Image$(x, y, image, this);            
    }    

    public Figure getEllipse(int x, int y, 
                             int w, int h, Graphics gDC
                  )
    {
        return new Ellipse(x, y, w, h, gDC);
    }        
    
    public Figure getEllipse(int x, int y, int w, int h)
    {
        return getEllipse(x, y, w, h, pDC);
    }
    
    public Figure getCircle(int x, int y, 
                            int d, Graphics gDC)
    {
        return new Ellipse(x, y, d, d, gDC);
    }
        
    public Figure getCircle(int x, int y, int d)
    {
        return getCircle(x, y, d, pDC);
    }
                
    public Figure getRectangle(int x, int y, 
                               int w, int h, Graphics gDC)
    {
        return new Rectangle(x, y, w, h, gDC);
    }

    public Figure getRectangle(int x, int y, int w, int h)
    {
        return new Rectangle(x, y, w, h, null);
    }
    
    public Figure getSquare(int x, int y, int d, Graphics gDC)
    {
        return getRectangle(x, y, d, d, gDC);
    }
    
    public Figure getSquare(int x, int y, int d)
    {
        return getSquare(x, y, d, pDC);
    }
    
    public Figure getDiamond(int x, int y, 
                             int w, int h, Graphics gDC)
    {
        return new Diamond(x, y, w, h, gDC);
    }
    
    public Figure getDiamond(int x, int y, int w, int h)
    {
        return new Diamond(x, y, w, h, pDC);
    }    
    
    public Figure getDiamond(int x, int y, 
                             int d, Graphics gDC)
    {   
        return getDiamond(x, y, d, d, gDC);
    }
    
    public Figure getDiamond(int x, int y, int d)
    {   
        return getDiamond(x, y, d, d, pDC);
    }    
    
    public Figures getFigures()
    {
        return new Figures();
    }

    public void drawFigures(Figures figures)
    {
        figures.drawFigures(pDC);
    }
    
    public static void drawFigure(Figure figure)
    {
        figure.draw(pDC);
    }
    
    public int length(Figures figures)
    {
       return figures.size();
    }
    
    public void addFigure(Figures figures, Figure figure)
    {
        figures.add(figure);
    }
    
    public void setFigure(Figures figures, Figure figure, int pos)
    {
        figures.set(pos, figure);
    }    
    
    public Figure getFigure(Figures figures, int pos)
    {
        return figures.getFigure(pos);
    }
    
    public void setXY(Figure figure, int x, int y)
    {
        figure.setXY(x, y);        
    }

    public void setSize(Figure figure, int w, int h)
    {
        figure.setSize(w, h);
    }
        
    public void setStroke(Figure figure, Stroke stroke)
    {
        figure.setStroke(stroke);
    }

    public void setPaint(Figure figure, Paint paint)
    {
        figure.setPaint(paint);
    }
    
    public void setColor(Figure figure, Color color)
    {
        figure.setPaint(color);
    }
    
    public void setFont(Figure figure, Font font)
    {
        figure.setFont(font);
    }

    public void setFill(Figure figure, int fill)
    {
        figure.setFill(fill);
    }
    
    public int getX(Figure figure)
    {
        return figure.getX();
    }
    
    public int getY(Figure figure)
    {
        return figure.getY();
    }
    
    public int getWidth(Figure figure)
    {
        return figure.getWidth();
    }    
    
    public int getHeight(Figure figure)
    {
        return figure.getHeight();
    }

    public Paint getPaint(Figure figure)
    {
        return figure.getPaint();
    }
    
    public Paint getColor(Figure figure)
    {
        Paint paint = figure.getPaint();
        if(paint instanceof Color)
            return paint;
        else
            return null;
    }
    
    public Stroke getStroke(Figure figure)
    {
        return figure.getStroke();
    }
    
    public Font getFont(Figure figure)
    {
        return figure.getFont();
    }
    
    public int getFill(Figure figure)
    {
        return figure.getFill();
    }

    // ============================================= (Figures)
    
    public Color getColor(int r, int g, int b)
    {
        return new Color(r, g, b);
    }
    
    public Color getColor(int argb)
    {
        return new Color(argb);
    }
           
    public Color getColor()
    {    
        Color color;
        int max3, min3, r, g, b;
        do {
            int rnd = rand.nextInt();
            color = new Color(rnd);
            r = color.getRed();
            g = color.getGreen();
            b = color.getBlue();
            max3 = max(max(r, g), b);
            min3 = min(min(r, g), b);
        } while(max3 - min3 < 20);
        return color;
    } 
                            
    public void setSizes(int size)
    {
        this.size = size;
    }
    
    public void setStroke(int width, double ratio, 
                          int cap, int butt)
    {
        float line = (float)(20 * ratio),
              gap  = (float)(20 * (1.0 - ratio));
        pDC.setStroke(
            new BasicStroke(
                width,
                cap,
                butt,
                100,
                new float[] { line, gap },
                0
            )
        );
    }    
    
    public void setStroke(int width, double ratio)
    {
        setStroke(
            width, ratio, 
            BasicStroke.CAP_BUTT,   // zakoczenie cite
            BasicStroke.JOIN_MITER  // poczenie zaostrzone
        );
    }
    
    public void setStroke(int width)
    {
        setStroke(width, 1.0f);
    }
    
    public Stroke getStroke()
    {
        return pDC.getStroke();
    } 
    
    public Stroke getStroke(int width)
    {
        return new BasicStroke(width);
    }
    
    public void setStroke(float width, int cap, int join, 
                            float miter, float[] dash, float phase)
    {
        pDC.setStroke(
            new BasicStroke(
                width, cap, join, miter, dash, phase
            )
        );
    }
    
    public Color setColor(Color color)
    {
        Color oldColor = pDC.getColor();
        pDC.setColor(color);
        return oldColor;
    }
        
    public Paint getGradient(Color from, Color to)
    {
        return new GradientPaint(0, 0, from, w, h, to);
    }

    public Paint getTexture(Image image)
    {
        BufferedImage img = 
            new BufferedImage(
                8, 8,                         // rozmiary
                BufferedImage.TYPE_INT_RGB    // model
            );
        Graphics2D mDC = img.createGraphics();
        mDC.drawImage(image, 0, 0, this);
        Rectangle2D.Double square = 
            new Rectangle2D.Double(0, 0, 32, 32);
        return new TexturePaint(img, square); 
    }
    
    public static Stroke getCurrentStroke()
    {
        return pDC.getStroke();
    }
    
    
    public static Paint getCurrentPaint()
    {
        return pDC.getPaint();
    }

    public void setPaint(Paint paint)
    {
        pDC.setPaint(paint);
    }

    public void setPaint(Color from, Color to)
    {
        setPaint(
            new GradientPaint(0, 0, from, w, h, to)
        );
    }
    
    public void setPaint(Image img)
    {
        setPaint(getTexture(img));
    }
               
    public int getRed(Color color)
    {
        return color.getRed();
    }
    
    public int getGreen(Color color)
    {
        return color.getGreen();
    }
    public int getBlue(Color color)
    {
        return color.getBlue();
    }    
    
    // ============================================= Strings
    
    public static void drawString(int x, int y, 
                                  String string)
    {
        Figure figure = new String$(x, y, string, pDC);
        drawFigure(figure);    
    }
    
    public static void drawString(int x, int y, 
                                  String string,
                                  Font font)
    {
        Font oldFont = pDC.getFont();
        pDC.setFont(font);
        drawString(x, y, string);
        pDC.setFont(oldFont);
    }                                  

    public boolean isLetter(char data)
    {
        return data >= 'a' && data <= 'z' ||
               data >= 'A' && data <= 'Z';
    }
    
    public boolean isAlpha(String data)
    {
        int length = data.length();
        boolean result = true;
        for(int i = 0; i < length; i++)
            result &= isLetter(data.charAt(i));
        return result;
    }   
    
    public boolean eq(String str1, String str2)
    {
        return str1.equals(str2);
    }
    
    public boolean ne(String str1, String str2)
    {
        return !eq(str1, str2);
    }
    
    public boolean gt(String str1, String str2)
    {
        return str1.compareTo(str2) > 0;
    }
    
    public boolean lt(String str1, String str2)
    {
        return str1.compareTo(str2) < 0;
    }
    
    public boolean ge(String str1, String str2)
    {
        return !lt(str1, str2);
    }
    
    public boolean le(String str1, String str2)
    {
        return !gt(str1, str2);
    }
    
    public String trim(String str)
    {
        return str.trim();
    }
    
    public String toLower(String str)
    {
        return str.toLowerCase();
    }

    public String toUpper(String str)
    {
        return str.toUpperCase();
    }
    
    public char toLower(char chr)
    {
        if(chr >= 'A' && chr <= 'Z')
            return (char)(chr - 'A' + 'a');
        return chr;
    }
    
    public char toUpper(char chr)
    {
        if(chr >= 'a' && chr <= 'z')
            return (char)(chr - 'a' + 'A');
        return chr;
    }
    
    public char charAt(String string, int pos)
    {
        return string.charAt(pos);
    }
    
    public int indexOf(String string, char chr)
    {
        return string.indexOf(chr);
    }
    
    public int indexOf(String string, String substr)
    {
        return string.indexOf(substr);
    }
    
    public String substring(String string, int from, int to)
    {
        return string.substring(from, to);
    }
    
    public String substring(String string, int from)
    {
        return string.substring(from);
    }
    
    // ============================================= Time
    
    
    private Calendar greg =
        GregorianCalendar.getInstance();
        
    public int getTime()
    {
        greg.setTime(new Date());
        return greg.get(Calendar.HOUR)   << 16 |    
               greg.get(Calendar.MINUTE) <<  8 |    
               greg.get(Calendar.SECOND);    
    }
        
    public int getHour(int time)
    {
        return (time >> 16) & 0xff;
    }    
    
    public int getMinute(int time)
    {
        return (time >> 8) & 0xff;
    } 
       
    public int getSecond(int time)
    {
        return time & 0xff;
    }    
    
    public long getMillis()
    {
        return System.currentTimeMillis();
    }
        
    // ============================================= Data
    
    public void setData(String string)
    {
        textField.setText(string);
    }
    
    public String getData()
    {
        return textField.getText();
    }
    
    public void showResult(String result)
    {
        Font oldFont = pDC.getFont();
        pDC.setFont(resultFont);
        clearView();
        pDC.drawString(result, 10, h/2);
        pDC.setFont(oldFont);
    }
    
    public void showResult(String result, int size)
    {
        Font font = new Font("Serif", Font.BOLD, size),
             oldFont = pDC.getFont();
        pDC.setFont(font);
        clearView();
        pDC.drawString(result, 10, h/2);
        pDC.setFont(oldFont);
    }
    
    public void showResult(double result)
    {
        showResult("" + result);
    }
    
    public void showResult(long result)
    {
        showResult("" + result);
    }
                
    public void beep()
    {
        Toolkit.getDefaultToolkit().beep();
    }    
    
    public int length(Object[] vec)
    {
        return vec.length;
    }
    
    public int length(int[] vec)
    {
        return vec.length;
    }
    
    public int length(double[] vec)
    {
        return vec.length;
    }   
    
    public int length(String string)
    {
        return string.length();
    }
    
    public void dataEntered(String[] data)
    {
        Toolkit.getDefaultToolkit().beep();
    }
    
    private String[] vector = { "" };
    
    public void dataEntered(String data)
    {
        vector[0] = data;
        dataEntered(vector);
    }
    
    public void dataEntered(char data)
    {
        String string = "" + data;
        dataEntered(string);    
    }        
       
    public int[] getValues(String[] data)
    {
        int[] values = new int [data.length];
        for(int i = 0; i < data.length ; i++) {
            try {
                values[i] = Integer.parseInt(data[i]);
            }
            catch(NumberFormatException e) {
                return null;
            }
        }
        return values;        
    }
    
    public String getString(String[] strings)
    {
        String string = "";
        for(int i = 0; i < strings.length; i ++)
            string += strings[i] + ' ';
        return string;
    }
    
    // ============================================= Math


    public int abs(int arg)
    {
        return Math.abs(arg);
    }
    
    public double abs(double arg)
    {
        return Math.abs(arg);
    }
    
    public int min(int arg1, int arg2)
    {
        return Math.min(arg1, arg2);
    }
    
    public int max(int arg1, int arg2)
    {
        return Math.max(arg1, arg2);
    }    
    
    public double min(double arg1, double arg2)
    {
        return Math.min(arg1, arg2);
    }
    
    public double max(double arg1, double arg2)
    {
        return Math.max(arg1, arg2);
    }
    
    public int getRandom(int min, int max)
    {
        int span = max - min + 1;
        return Math.abs(rand.nextInt()) % span + min;
    }
    
    public int getRandom(int range)
    {
        return getRandom(0, range-1);
    }
    
    public int getRandom()
    {
        return rand.nextInt();
    }
    
    public double sin(double v)
    {
        return Math.sin(v);
    }

    public double cos(double v)
    {
        return Math.cos(v);
    }
    
    public double tan(double v)
    {
        return Math.tan(v);
    }    

    public double sqrt(double v)
    {
        return Math.sqrt(v);
    }    
    
    public double pow(double b, double e)
    {
        return Math.pow(b, e);
    }
    
    public double log(double v)
    {
        return Math.log(v);
    }
    
    // ============================================= Fonts
    
    public static Font getCurrentFont()
    {
        return pDC.getFont();
    }
    
    public void setFont(Font font)
    {
        pDC.setFont(font);
    }   
    
    public Font getFont(String face, int style, int size)
    {
        return new Font(face, style, size);
    }
    
    // ============================================= Cursors
    
    public void setCursor(Cursor cursor)
    {
        panel.setCursor(cursor);
    }   
    
    public Cursor getCursor(String string, Point pHot)
    {
        URL docBase = getDocumentBase();
        Image img = getImage(string);
        return kit.createCustomCursor(img, pHot, string);
    }
    
    public Cursor getCursor(
                      String string, int xHot, int yHot
                  )
    {
        return getCursor(string, new Point(xHot, yHot));
    }
    
    
    // ============================================= Graphics        
    
    public void setFill(int fill)
    {
        this.fill = fill;
    }
          
    public void drawString(String string, int x, int y)
    {
        pDC.drawString(string, x, y);
    }   
    
    public void drawPixel(int x, int y)
    {
        drawLine(x, y, x, y);
    }
    
    public void drawPixel(Point p)
    {
        drawLine(p.x, p.y, p.x, p.y);
    }
    
    public void drawLine(int xA, int yA, int xZ, int yZ)
    {
        pDC.drawLine(xA, yA, xZ, yZ);
    }
    
    public void drawLine(Point pA, Point pZ)
    {
        pDC.drawLine(pA.x, pA.y, pZ.x, pZ.y);
    }    
    
    public void moveTo(Point p)
    {
        pX = p.x;
        pY = p.y;
    }
    
    public void moveTo(int x, int y)
    {
        pX = x;
        pY = y;
    }
    
    public void lineTo(int x, int y)
    {
        pDC.drawLine(pX, pY, pX = x, pY = y);
    }       
    
    public void lineTo(Point p)
    {
        lineTo(p.x, p.y);
    }       
    
    public void drawCircle(int x, int y, int d, int f)
    {
        Paint oldPaint = pDC.getPaint();
        Stroke oldStroke = pDC.getStroke();                
        switch(f) {
            case 0:    // Line
                pDC.drawOval(x, y, d-1, d-1);
                break;
            case 1:    // Ring            
                BasicStroke bs = (BasicStroke)oldStroke;
                int width = (int)(bs.getLineWidth()),
                    x2 = x + width/2,
                    y2 = y + width/2,
                    d2 = d - width;
                pDC.drawOval(x2, y2, d2-1, d2-1);
                pDC.setColor(Color.black);
                pDC.setStroke(thinStroke);
                pDC.drawOval(x, y, d-1, d-1);
                x += width;
                y += width;                                
                d -= 2 * width;
                pDC.drawOval(x, y, d-1, d-1);
                break;
            case 2:    // Full  
                Paint paint = pDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+d, y+d,
                               colorZ
                           ); 
                    pDC.setPaint(grad);
                }
                pDC.fillOval(x, y, d, d);
                pDC.setStroke(thinStroke);
                pDC.setColor(Color.black);
                pDC.drawOval(x, y, d-1, d-1);
        }            
        pDC.setPaint(oldPaint);
        pDC.setStroke(oldStroke);
    }
    
    public void drawCircle(int x, int y, int d)
    {
        drawCircle(x, y, d, fill);
    }
    
    public void drawCircle(int x, int y)
    {
        Color oldColor = pDC.getColor();
        pDC.setColor(getColor());
        drawCircle(x, y, size, fill);
        pDC.setColor(oldColor);
    }
    
    public void drawEllipse(int x, int y, 
                            int w, int h, int f)
    {
        Paint oldPaint = pDC.getPaint();
        Stroke oldStroke = pDC.getStroke();
        switch(f) {
            case 1:   
                System.out.println(
                    "\n\n Wrong argument: Ring\n\n"
                );
            case 0:    // Line
                pDC.drawOval(x, y, w-1, h-1);
                break;
            case 2:    // Full  
                Paint paint = pDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+w, y+h,
                               colorZ
                           ); 
                    pDC.setPaint(grad);
                }
                pDC.fillOval(x, y, w, h);
                pDC.setStroke(thinStroke);
                pDC.setColor(Color.black);
                pDC.drawOval(x, y, w-1, h-1);
        }            
        pDC.setPaint(oldPaint);
        pDC.setStroke(oldStroke);
    }
    
    public void drawEllipse(int x, int y, 
                            int w, int h)
    {
        drawEllipse(x, y, w, h, Line);
    }
       
    public void drawSquare(int x, int y, int d, int fill)
    {
        Paint oldPaint = pDC.getPaint();
        Stroke oldStroke = pDC.getStroke();    
        switch(fill) {
            case 0:    // Line
                pDC.drawRect(x, y, d-1, d-1);
                break;
            case 1:    // Ring
                BasicStroke bs = (BasicStroke)oldStroke;
                int width = (int)(bs.getLineWidth()),  
                    x2 = x + width/2,
                    y2 = y + width/2,
                    d2 = d - width;
                pDC.drawRect(x2, y2, d2-1, d2-1);                
                pDC.setColor(Color.black);
                pDC.setStroke(thinStroke);
                pDC.drawRect(x, y, d-1, d-1);
                x += width;
                y += width;                                
                d -= 2 * width;
                pDC.drawRect(x, y, d-1, d-1);                
                break;            
            case 2:    // Full
                Paint paint = pDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+d, y+d,
                               colorZ
                           ); 
                    pDC.setPaint(grad);
                }
                pDC.fillRect(x, y, d, d);
                pDC.setStroke(thinStroke);                
                pDC.setColor(Color.black);
                pDC.drawRect(x, y, d-1, d-1);
        }            
        pDC.setPaint(oldPaint);
        pDC.setStroke(oldStroke);        
    }
    
    public void drawSquare(int x, int y, int d)
    {
        drawSquare(x, y, d, fill);
    }
       
    public void drawSquare(int x, int y)
    {
        Color oldColor = pDC.getColor();
        pDC.setColor(getColor());    
        drawSquare(x, y, size, fill);
        pDC.setColor(oldColor);
    }
    
    public void drawRectangle(int x, int y, 
                              int w, int h, int f)
    {
        Paint oldPaint = pDC.getPaint();
        Stroke oldStroke = pDC.getStroke();
        switch(f) {
            case 1:   
                System.out.println(
                    "\n\n Wrong argument: Ring\n\n"
                );
            case 0:    // Line
                pDC.drawRect(x, y, w-1, h-1);
                break;
            case 2:    // Full  
                Paint paint = pDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+w, y+h,
                               colorZ
                           ); 
                    pDC.setPaint(grad);
                }
                pDC.fillRect(x, y, w, h);
                pDC.setStroke(thinStroke);
                pDC.setColor(Color.black);
                pDC.drawRect(x, y, w-1, h-1);
        }            
        pDC.setPaint(oldPaint);
        pDC.setStroke(oldStroke);
    }
    
    public void drawRectangle(int x, int y, 
                              int w, int h)
    {
        drawRectangle(x, y, w, h, Line);
    }
    
    // ============================================= Cheats
    
    public static void warning(String warning)
    {
        System.out.println(
            "\n\nWarning: " + warning + "\n\n"
        );
    }
    
    public static void error(String error)
    {
        System.out.println(
            "\n\nError: " + error + "\n\n"
        );
    }    
    
    public void requestFocus()
    {
        super.requestFocus();
        panel.requestFocus();
    }
    
    public Component add(Component component)
    {
        panel.add(component); 
        return component;
    }           
    
    public Component add(Component component, String pos)
    {
        if(viewReady)
            panel.add(component, pos); 
        else
            super.add(component, pos);
        return component;
    }               
          
    public Component add(String pos, Component component)
    {
        if(viewReady)
            panel.add(pos, component); 
        else
            super.add(pos, component);
        return component;
    }               
       
    public void addMouseListener(MouseListener listener)
    {
        panel.addMouseListener(listener);
    }
    
    public void addMouseMotionListener(
                    MouseMotionListener listener
                )
    {
        panel.addMouseMotionListener(listener);
    }
    
    public void addKeyListener(KeyListener listener)
    {
        panel.addKeyListener(listener);
    }       
    
    public Graphics getGraphics()
    {    
        if(panel == null) {
            error(
                "You used illegal " +
                "\"public void init()\" method!"
            );
            return null;
        }
        return panel.getGraphics();
    }
   
    public void setBackground(Color color)
    {
        panel.setBackground(color);
        super.setBackground(color);
    }
    
    public void setLayout(LayoutManager manager)
    {
        super.setLayout(manager);
        if(viewReady)
            panel.setLayout(manager);
    }
       
    public Dimension getSize()
    {
        if(!viewReady)
            return super.getSize();
        else
            return new Dimension(w, h);
    }                          
    
    public int getWidth()
    {
       return w;
    }
    
    public int getHeight()
    {
        return h;
    }
    
    // ============================================= Images
    
    public int getWidth(Image img)
    {
        return img.getWidth(this);
    }
    
    public int getHeight(Image img)
    {
        return img.getHeight(this);
    }    
    
    public Image[] getImages(String[] names)
    {
        Image[] images = new Image [names.length];
        tracker = new MediaTracker(this);
        URL dataBase = getDocumentBase();
        for(int i = 0; i < names.length ; i++) {
            images[i] = getImage(dataBase, names[i]);
            tracker.addImage(images[i], 0);
        }
        try {
            tracker.waitForID(0);
        }
        catch(InterruptedException e) {
        }
        return images;
    }
    
    public Image getImage(String name)
    {
        return getImages(new String [] { name })[0];
    }
       
    public void drawImage(Image img, int x, int y)
    {
        pDC.drawImage(img, x, y, this);
    }
    
    public void drawImage(Image img, int x, int y, 
                          int w, int h)
    {
        pDC.drawImage(img, x, y, w, h, this);
    }    
    
    // ============================================= Mouse
    
    public void mousePressed(int x, int y, int flags) 
    {
        mousePressed(x, y);
    }        
        
    public void mouseReleased(int x, int y, int flags) 
    {
        mouseReleased(x, y);
    }
    
    public void mouseClicked(int x, int y, int flags) 
    {
        mouseClicked(x, y);
    }    
       
    public void mouseMoved(int x, int y, int flags)
    {
        mouseMoved(x, y);
    }

    public void mouseDragged(int x, int y, int flags)
    {
        mouseDragged(x, y);
    }
    
    public void mouseEntered(int x, int y, int flags)
    {
        mouseEntered(x, y);
    }
    
    public void mouseExited(int x, int y, int flags)
    {
        mouseExited(x, y);
    }
    
    public void mousePressed(int x, int y)
    {
    }
    
    public void mouseReleased(int x, int y)
    {
    }
    
    public void mouseClicked(int x, int y)
    {
    }
    
    public void mouseMoved(int x, int y)
    {
    }
    
    public void mouseDragged(int x, int y)
    {
    }
    
    public void mouseEntered(int x, int y)
    {
    }
    
    public void mouseExited(int x, int y)
    {
    }
       
    class MouseWatcher 
        extends MouseAdapter
        implements MouseMotionListener {
        
        ViewPanel panel;
        
        public MouseWatcher(ViewPanel panel)
        {
            this.panel = panel;
        }
        
        public void mousePressed(MouseEvent evt) 
        {
            requestFocus();
            panel.requestFocus();
        
            int flags = evt.getModifiers() & 0xf;
            view.mousePressed(evt.getX(), evt.getY(), flags);
        }        
        
        public void mouseReleased(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;
            if(evt.getClickCount() == 2)
                flags |= 0x10;                
            view.mouseReleased(evt.getX(), evt.getY(), flags);
        }                
        
        public void mouseClicked(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;
            if(evt.getClickCount() == 2)
                flags |= 0x10;                
            view.mouseClicked(evt.getX(), evt.getY(), flags);
        }                        
        
        public void mouseMoved(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseMoved(evt.getX(), evt.getY(), flags);
        }

        public void mouseDragged(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseDragged(evt.getX(), evt.getY(), flags);        
        }        
        
        public void mouseEntered(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseEntered(evt.getX(), evt.getY());
        }

        public void mouseExited(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseExited(evt.getX(), evt.getY());        
        }                
    }
    
    // ============================================= Keyboard
      
    public boolean isShift(int flags)
    {
        return (flags & InputEvent.SHIFT_MASK) != 0;
    }
    
    public boolean isCtrl(int flags)
    {
        return (flags & InputEvent.CTRL_MASK) != 0;
    }

    public boolean isAlt(int flags)
    {
        return (flags & InputEvent.ALT_MASK) != 0;
    }

    public boolean isMeta(int flags)
    {
        return (flags & InputEvent.META_MASK) != 0;
    }
    
    public boolean isClick2(int flags)
    {
        return (flags & 1 << 4) != 0;
    }    
    
    public boolean isUnicode(int flags)
    {
        return (flags & 0x80000000) != 0;
    }

    public void keyPressed(int key, int flags) 
    {
        keyPressed(key);
    }        
    
    public void keyReleased(int key, int flags) 
    {
        keyReleased(key);    
    }
    
    public void keyTyped(char key, int flags) 
    {
        keyTyped(key);    
    }
    
    public void keyPressed(int key)
    {
    }
    
    public void keyReleased(int key)
    {
    }
    
    public void keyTyped(char key)
    {
    }
            
    class KeyWatcher 
        extends KeyAdapter {
        
        ViewPanel panel;
        
        public KeyWatcher(ViewPanel panel)
        {
            this.panel = panel;
        }
        
        public void keyPressed(KeyEvent evt) 
        {    
            int flags = evt.getModifiers() & 0xf;
            boolean unicode = 
                evt.getKeyChar() != KeyEvent.CHAR_UNDEFINED;
            if(unicode)
                flags |= 0x80000000;   // jb Unicode flag
            view.keyPressed(evt.getKeyCode(), flags);
        }        
        
        public void keyReleased(KeyEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;
            view.keyReleased(evt.getKeyCode(), flags);
        }
        
        public void keyTyped(KeyEvent evt)
        {
            int flags = evt.getModifiers() & 0xf;        
            view.keyTyped(evt.getKeyChar(), flags);
        }
    }    
    
    // ============================================= Threads
    
    public void exitBrowser()
    {
        System.exit(0);
    }
    public boolean setSeparate(boolean separate)
    {
        boolean oldSeparate = separateThread;
        separateThread = separate;
        return oldSeparate;
    }
    
    public void runView()
    {
    }
          
    public void run()
    {
    }
    
    public Thread startRun()
    {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }
    
    public Thread startRun(Runner runner)
    {
        return runner;
    }
           
    public Object getLock()
    {
        return new Object();
    }
        
    public static void sleep(int time)
    {
        try {
            Thread.sleep(time);
        }
        catch(InterruptedException e) {
        }
    }
    
    public void interrupt(Thread thread)
    {
        thread.interrupt();
    }
    
    public void join(Thread thread)
        throws InterruptedException
    {    
        thread.join();
    }
    
    public boolean isInterrupted(Thread thread)
    { 
        return thread.isInterrupted();
    }    
    
    public boolean isInterrupted()
    {
        return isInterrupted(Thread.currentThread());
    }
     
    // ============================================= Audio

    public AudioClip getAudio(String name)
    {
        URL where = getDocumentBase();
        return getAudioClip(where, name);
    }
    
    public void playAudio(AudioClip clip)
    {
        clip.play();
    }
    
    public void loopAudio(AudioClip clip)
    {
        clip.loop();
    }    
    
    public void stopAudio(AudioClip clip)
    {
        clip.stop();
    }
       
    // ============================================= Layouts
    
    public void setNullLayout()
    {
        panel.setLayout(null);
    }
    
    public void setFlowLayout()
    {
        panel.setLayout(new FlowLayout());    
    }
    
    public void setBorderLayout()
    {
        panel.setLayout(new BorderLayout());    
    }

    public void setGridLayout(int row, int col)
    {
        panel.setLayout(new BorderLayout(row, col));    
    }    
    
    // ============================================= Buttons
    
    public void buttonPressed(Button button)
    {
    }
    
    class ButtonWatcher
        implements ActionListener {
        
        public void actionPerformed(ActionEvent evt)
        {
            buttonPressed((Button)evt.getSource());
        }
    }
    
    public static void setLabel(Button button, String text)
    {
        if(viewReady)
            button.setLabel(text);
    }
    
    public void setBounds(Button button, int x, int y, 
                          int w, int h)
    {
        button.setBounds(x, y, w, h);
    }
    
    public void setLocation(Button button, int x, int y)
    {
        button.setLocation(x, y);
    }
    
    public void setSize(Button button, int w, int h)
    {
        button.setSize(w, h);
    }
    
    public Button getButton(String label, 
                            int x, int y, int w, int h)
    {
        Button button = new Button(label);
        button.setLocation(x, y);
        button.setSize(w, h);
        return button;
    }
    
    public Button getButton(String label, int x, int y)
    {
        return getButton(label, x, y, 60, 25);
    }
    
    public Button getButton(String label)
    {
        return getButton(label, 0, 0);
    }
    
    public void addButton(Button button)
    {
        button.addActionListener(buttonWatcher);    
        panel.addButton(button);
    }
    
    public void addButton(Button button, int pos)
    {
        button.addActionListener(buttonWatcher);    
        panel.addButton(button, pos);
    }
    
    // ============================================= Labels
    
    public static void setLabel(Label label, String text)
    {
        if(viewReady)    
            label.setText(text);
    }
    
    public void setBounds(Label label, int x, int y, 
                          int w, int h)
    {
        label.setBounds(x, y, w, h);
    }
    
    public void setLocation(Label label, int x, int y)
    {
        label.setLocation(x, y);
    }
    
    public void setSize(Label label, int w, int h)
    {
        label.setSize(w, h);
    }
    
    public static Label getLabel(String label, 
                          int x, int y, 
                          int w, int h, int align)
    {
        Label label2 = new Label(label, align);
        label2.setLocation(x, y);
        label2.setSize(w, h);
        return label2;
    }
    
    public Label getLabel(String label, 
                          int x, int y, 
                          int w, int h)
    {
        return getLabel(label, x, y, w, h, Left);
    }
    
    public Label getLabel(String label, 
                          int x, int y, int align)
    {
        return getLabel(label, x, y, 60, 25, align);
    }
    
    
    public Label getLabel(String label, int x, int y)
    {
        return getLabel(label, x, y, Left);
    }
    
    public Label getLabel(String label, int align)
    {
        return getLabel(label, 0, 0, align);
    }
    
    public Label getLabel(String label)
    {
        return getLabel(label, Left);
    }
    
    public void addLabel(Label label)
    {
        panel.addLabel(label, Left);
    }
    
    public void addLabel(Label label, int pos)
    {
        panel.addLabel(label, pos);
    }
        
    // ============================================= Buffering
    
    public void toBuffer(int w, int h)
    {        
        Stroke stroke = pDC.getStroke();
        Paint paint   = pDC.getPaint();
        Color color   = pDC.getColor();
        buffer = createImage(w, h);        
        pDC = (Graphics2D)buffer.getGraphics();
        pDC.setStroke(stroke);
        pDC.setPaint(paint);
        pDC.setColor(color);
        pDC.clearRect(0, 0, w, h);        
        isBuffered = true;
    }
    
    public void toBuffer()
    {       
        toBuffer(w, h);
    }
    
    public Image getBuffer()
    {
        return buffer;
    }
    
    public void toBuffer(Image buffer)
    {
        pDC = (Graphics2D)buffer.getGraphics();
        isBuffered = true;    
    }
    
    public void toScreen(boolean keep)
    {
        if(pDC != pDC2 && !keep)
            pDC.dispose();
        pDC = pDC2;
        redraw();
        isBuffered = false;
    }
    
    public void toScreen()
    {
        toScreen(false);
    }
        
    public void drawBuffer(int x, int y)
    {
        if(isBuffered)
            pDC2.drawImage(buffer, x, y, this);
    }
    
    public void drawBuffer()
    {
        drawBuffer(0, 0);
    }
    
    public void clearRect(int x, int y, int w, int h)
    {
        Paint oldPaint = pDC.getPaint();
        pDC.setColor(Color.white);
        pDC.fillRect(0, 0, w, h);
        pDC.setPaint(oldPaint);
    }
    
    public void clearRect()
    {
        clearRect(0, 0, w, h);
    }
       
    // ============================================= Numbers           
    
    public boolean isNumeric(String data)
    {
        try {
            Double.parseDouble(data);
            return true;
        }
        catch(NumberFormatException e) {
            return false;
        }    
    }       
    
    public boolean isNumeric(String[] data)
    {
        for(int i = 0; i < data.length ; i++)
            if(!isNumeric(data[i]))
                return false;
        return true;
    }
    
    public boolean isDouble(String string)
    {
        if(!isNumeric(string))
            return false;
        return string.indexOf('.') > -1 || 
               string.indexOf('e') > -1 ||
               string.indexOf('E') > -1;
    }
        
    public boolean isInt(String string)
    {
        double number;
        try {
            Integer.parseInt(string);
            return true;            
        }
        catch(NumberFormatException e) {
            return false;
        }
    } 
    
    public boolean isIntegral(String string)
    {
        try {
            double number = Double.parseDouble(string);
            return number == (int)number;
        }
        catch(NumberFormatException e) {
            return false;
        }
    }        
    
    public double getDouble(String string)
    {
        try {
            return Double.parseDouble(string);
        }
        catch(NumberFormatException e) {
            error("Wrong getDouble argument");        
            return Double.NaN;
        }
    }
    
    public int getInt(String string)
    {
        try {
            return (int)Double.parseDouble(string);
        }
        catch(NumberFormatException e) {
            error("Wrong getInt argument");
            return Integer.MIN_VALUE;
        }
    }    
    
    // ============================================= Streams
        
    public void close(Stream stream)
    {
        stream.close();
    }
    
    public Stream open(String name, boolean forOutput)
    {
        if(forOutput) {
            try {
                return new Output$(name);
            }
            catch(IOException e) {
            }
        } else {
            try {
                return new Input$(name);
            }
            catch(FileNotFoundException e) {
                showMsg(name + " not found");
            }
        }
        return null;
    }
    
    public Stream open(String name)
    {
        return open(name, false);
    }        
        
    public String read(Stream stream)
    {
        if(!(stream instanceof Input$))
            return null;
        return ((Input$)stream).read();
    }
    
    public boolean isEOL(String string)
    {
        return string.equals("");
    }   
    
    public Stream reset(Stream stream)
    {
        stream.close();
        try {
            if(stream instanceof Input$)
                return ((Input$)stream).reset();
        }
        catch(FileNotFoundException e) {
        }
        return null;
    }         
            
    public void write(Stream out, String string)
    {
        if(!(out instanceof Output$))
            return;
        ((Output$)out).write(string);
    }
        
    public void writeEOL(Stream out)
    {
        if(!(out instanceof Output$))
            return;
        ((Output$)out).write("");
    }
    
    // ============================================= Debugger
        
    private static boolean debuggerStopped = false;
    
    public static void setNotDebugged()
    {
       isDebugged = false;
    }
    
    public static void check()
    {
        if(!isDebugged) {
            new Debugger(view, dbgLoc, dbgSize);
            isDebugged = true;
            view.requestFocus();
            panel.requestFocus();
        }
    }    
    
    public static void dbg(Object one, Object two)
    {
        dbg(one + "  " + two);
    }
    
    public static void dbg(String msg)
    {  
        if(debuggerStopped)
            return;
        check();
        Debugger.toFrame(msg);
    }

    public static void dbg(char val)
    {
        dbg("" + val);
    }    
    
    public static void dbg(int val)
    {
        dbg("" + val);
        panel.requestFocus();
    }
    
    public static void dbg(double val)
    {
        dbg("" + val);
    }
    
    public static void dbg(boolean val)
    {
        dbg("" + val);
    }
    
    public static void dbg(Object obj)
    {
        if(debuggerStopped)
            return;       
        check();
        Debugger.toFrame(obj);
    }
    
    public static void dbg()
    {
        dbg("");
    }
    
    public static void dbgOff()
    {
        if(debuggerStopped)
            return;    
        Debugger.off();
    }
    
    public static void dbgAssert(String what, boolean isTrue)
    {
        if(debuggerStopped)
            return;    
        check();
        Debugger.assert(what, isTrue);
    }
     
    public static void dbgClear()
    {
        if(debuggerStopped)
            return;    
        check();
        Debugger.clear();
    }   
    
    public static void dbgOn()
    {
        if(debuggerStopped)
            return;    
       Debugger.on();
    }       
    
    public static void dbgFont(int size)
    {
        if(debuggerStopped)
            return;
        Debugger.setFontSize(size);
    }
    
    public static void dbgSize(int w, int h)
    {
        if(debuggerStopped)
            return; 
       setNotDebugged();
       dbgSize = new Dimension(w, h);
    }
    
    public static void dbgLoc(int x, int y)
    {
        if(debuggerStopped)
            return;    
       dbgLoc = new Point(x, y);
    }
    
    public static void dbgLimit(int limit)
    {
        if(debuggerStopped)
            return;    
        Debugger.setLimit(limit);
    }       
    
    public static void dbgStop()
    {
        debuggerStopped = true;
    }


   // ============================================= Monitor
   
   public Monitor getMonitor(boolean state)
   {
       return new Monitor(state);
   }
   
   public Monitor getMonitor()
   {
       return getMonitor(false);
   }   
    
    public void mWait(Monitor m)
    {    
        m.jbWait();
    }
    
    public void mPause(Monitor m)
    {
        m.jbPause();
    }

    public void mNotify(Monitor m)
    {
        m.jbNotify();
    }
    
    public void mNotifyAll(Monitor m)
    {
        m.jbNotifyAll();
    }    

    public void mWaitBreak(Monitor m)
        throws InterruptedException
    {
        m.jbWaitBreak();
    }
}

// Not implemented

 /*      
    public void startRun(final Class runClass)
    {
        class Runner
            extends Thread {
            
            public Runner()
            {
                this.start();
            }
            
            public void run()  
            {   
                Object runner = null;
                try {       
                    runner = runClass.newInstance();
                    Class nullParam[] = new Class[] { };
                    Method method = 
                        runClass.getDeclaredMethod(
                                    "run", nullParam
                                 );
                    Object[] nullArgs = new Object[] { };
                    method.invoke(runner, nullArgs);
                }
                catch(Exception e) {
                    error(runClass + " is not external!");
                }                
            }
        }
        
        new Runner();
    }
    */
 

[[[//*** Klasa Runner


package janb.view;

public class Runner 
    extends Thread {

    public Runner()
    {
        start();
    }

    public void run()
    {
    }
    
    public void sleep(int time)
    {
        try {
            Thread.sleep(time);
        }
        catch(InterruptedException e) {
        }
    }
}
 

[[[//*** Klasa Stream


package janb.view;

public
class Stream {

    public void close()
    {
        if(this instanceof Input$)
            ((Input$)this).close();
        else
            ((Output$)this).close();
    }
}


[[[//*** Klasa Input$


package janb.view;

import java.io.*;

public
class Input$ 
    extends Stream {

    private String name;
    private FileReader reader;
    private StreamTokenizer inp;
    private int what;
    private boolean tokenReady = false;
    private String token;
    
    static final
    int EOF    = StreamTokenizer.TT_EOF,
        WORD   = StreamTokenizer.TT_WORD,
        NUMBER = StreamTokenizer.TT_NUMBER,
        EOL    = StreamTokenizer.TT_EOL;
        
    public Input$(String name)
        throws FileNotFoundException
    {
        this.name = name;
        reset();
    }
    
    public Stream reset()
        throws FileNotFoundException
    {      
        reader = new FileReader(name);
        inp = new StreamTokenizer(reader);
        inp.eolIsSignificant(true);
        inp.quoteChar('"');
        inp.parseNumbers();
        return this;        
    }
    
    public String read()
    {
        if(tokenReady && what == WORD) {
            tokenReady = false;
            return token;
        }

        if(!tokenReady) {
            try {
                what = inp.nextToken();
            }
            catch(IOException e) {
                what = EOF;
            }
        }
        tokenReady = false;
        
        switch(what) {            
            case EOF:             
                try {
                    reader.close();
                }
                catch(IOException e) {
                }
                return null;                    
            case EOL:                    
                return "";
            case NUMBER:
                String result = inp.nval + "";
                try {
                    what = inp.nextToken();       
                    tokenReady = true;
                }
                catch(IOException e) {
                    what = EOF;
                }
                
                String tail;
                if(what == WORD && 
                   (tail = inp.sval).charAt(0) == 'e' &&
                   tail.length() > 1 
                    ) {
                    tail = tail.substring(1);
                    try {
                        Integer.parseInt(tail);
                        tokenReady = false;
                        result += 'e' + tail;
                    }
                    catch(NumberFormatException e) {
                        what = WORD;
                        token = 'e' + tail;
                    }
                }
                return result;
            case WORD:
                return inp.sval;
            case '"':
                return inp.sval;
            default:
                return (char)what + " ";
        }
    }
           
    public void close()
    {
        try {
            reader.close();
        }
        catch(IOException e) {
        }
    }
}


[[[//*** Klasa Output$


package janb.view;

import java.io.*;

public
class Output$
    extends Stream {
    
    private String name;
    private FileWriter writer; 
    PrintWriter out;       
    
    public Output$(String name)
        throws IOException
    {
        writer = new FileWriter(name);
        out = new PrintWriter(writer);
    }
    
    public void write(String string)
    {
        if(!string.equals(""))
            out.print(string + ' ');
        else
            out.print('\n');
    }
    
    public void close()
    {
        try {
            writer.close();
        }
        catch(IOException e) {
        }
    }
}

 

[[[//*** Klasa Metrics


package janb.view;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;

public
class Metrics {

    private TextLayout layout;
    private Rectangle2D bounds;
    
    public Metrics(TextLayout layout)
    {
        this.layout = layout;
        bounds = layout.getBounds();
    }
    
    public int getWidth()
    {
        return (int)bounds.getWidth();
    }
    
    public int getHeight()
    {
        return (int)bounds.getHeight();
    }    
    
    public int getAscent()
    {
        return (int)layout.getAscent();
    }    

    public int getDescent()
    {
        return (int)layout.getDescent();
    }        
}


[[[//*** Klasa Figures


package janb.view;

import java.awt.Graphics2D;
import java.util.Vector;

public 
class Figures 
    extends Vector {
    
    public void addFigure(Figure figure)
    {
        addFigure(figure);
    }
    
    public Figure getFigure(int pos)
    {
        return (Figure)get(pos);
    }
       
    public void drawFigures(Graphics2D gDC)
    {
        int count = size();
        for(int i = 0; i < count ; i++)
            ((Drawable)elementAt(i)).draw(gDC);
    }
}


[[[//*** Klasa Figure


package janb.view;

import java.awt.*;

public abstract 
class Figure
    implements Names, Drawable {
    
    protected static int defWidth = 100;
    protected static Paint defPaint = Color.red;
    protected static Font defFont = 
                         Names.SerifBoldItalic30;
    protected static Stroke defStroke = Names.Stroke_1;
    protected static int defFill = Names.Ring;
    private int x, y, w, h;
    private Paint paint;
    private Stroke stroke;
    private Font font;
    private int fill;
        
    public Figure(int x, int y, int w, int h, Graphics gDC)
    {
        Graphics2D pDC = (Graphics2D)gDC;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;        
        if(gDC != null) {
            paint  = pDC.getPaint();
            stroke = pDC.getStroke();
            font   = pDC.getFont();
        } else {
            paint  = defPaint;
            stroke = defStroke;
            font   = defFont;
        }
        fill = defFill;
    }
    
    abstract public void draw(Graphics2D gDC);
                  
    public int getX()
    {
        return x;
    }
    
    public int getY()
    {
        return y;
    }
    
    public int getWidth()
    {
        return w;
    }
    
    public int getHeight()
    {
        return h;
    }    
        
    public Paint getPaint()
    {
        return paint;
    }
    
    public Stroke getStroke()
    {
        return stroke;
    }
        
    public Font getFont()
    {
        return font;
    }    
    
    public int getFill()
    {
        return fill;
    }        
    
    public void setXY(int x, int y)
    {
        this.x = x;
        this.y = y;
    }
       
    public void setSize(int w, int h)
    {
        this.w = w;
        this.h = h;
    }
    
     public void setPaint(Paint paint)
    {
        this.paint = paint;
    }
    
    public void setStroke(Stroke stroke)
    {
        this.stroke = stroke;
    }
    
    public void setFont(Font font)
    {
        this.font = font;
    }    
    
    public void setFill(int fill)
    {
        this.fill = fill;
    }
}


[[[//*** Klasa Pixel


package janb.view;

import java.awt.*;

public
class Pixel 
    extends Figure {    
    
    public Pixel(int x, int y, Graphics gDC)
    {
        super(x, y, 1, 1, gDC);
    }
    
    public Pixel(int x, int y)
    {
        this(x, y, null);
    }
        
    public void draw(Graphics2D gDC)
    {
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();    
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        gDC.drawLine(x, y, x, y);
        gDC.setPaint(oldPaint);
    }
}


[[[//*** Klasa Line


package janb.view;

import java.awt.*;

public
class Line 
    extends Figure { 
    
    private int xZ, yZ;   
    
    public Line(int xA, int yA, int xZ, int yZ, Graphics gDC)
    {
        super(xA, yA, Math.abs(xA-xZ), 
              Math.abs(yA-yZ), gDC);
        this.xZ = xZ;
        this.yZ = yZ;
    }
    
    public Line(int xA, int yA, int xZ, int yZ)
    {
        this(xA, yA, xZ, yZ, null);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        gDC.drawLine(getX(), getY(), xZ, yZ);
        gDC.setPaint(oldPaint);
    }
}


[[[//*** Klasa Ellipse


package janb.view;

import java.awt.*;

public
class Ellipse 
    extends Figure {    
    
    public Ellipse(int x, int y, int w, int h, Graphics gDC)
    {
        super(x, y, w, h, gDC);
    }
    
    public Ellipse(int x, int y, int w, int h)
    {
        this(x, y, w, h, null);
    }
    
    public Ellipse(int x, int y, int d, Graphics gDC)
    {
        this(x, y, d, d, gDC);
    }        
       
    public Ellipse(int x, int y, int d)
    {
        this(x, y, d, d, null);
    }    
    
    public Ellipse(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        Stroke oldStroke = gDC.getStroke();
        gDC.setStroke(getStroke());
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();
        switch(getFill()) {
            case 0:    // Line
                gDC.setStroke(Stroke_1);
                gDC.drawOval(x, y, w-1, h-1);
                break;
            case 1:    // Ring     
                BasicStroke basicStroke = 
                    (BasicStroke)getStroke();
                int width = 
                    (int)(basicStroke.getLineWidth()),
                    x2 = x + width/2,
                    y2 = y + width/2,
                    dW = w - width,
                    dH = h - width;
                gDC.setStroke(getStroke());
                gDC.drawOval(x2, y2, dW-1, dH-1);
                gDC.setColor(Color.black);
                gDC.setStroke(Stroke_1);
                gDC.drawOval(x, y, w-1, h-1);
                x += width;
                y += width;                                
                int ww = w - 2 * width,
                    hh = h - 2 * width;
                gDC.drawOval(x, y, ww-1, hh-1);
                break;
            case 2:    // Full  
                Paint paint = gDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+w, y+h,
                               colorZ
                           ); 
                    gDC.setPaint(grad);
                }
                gDC.fillOval(x, y, w, h);
                gDC.setStroke(new BasicStroke(1));
                gDC.setColor(Color.black);
                gDC.drawOval(x, y, w-1, h-1);
        }            
        gDC.setStroke(oldStroke);
        gDC.setPaint(oldPaint);
    }
}


[[[//*** Klasa Rectangle


package janb.view;

import java.awt.*;

public
class Rectangle 
    extends Figure {
       
    public Rectangle(int x, int y, int w, int h, Graphics gDC)
    {
        super(x, y, w, h, gDC);
    }
    
    public Rectangle(int x, int y, int w, int h)
    {
        this(x, y, w, h, null);    
    }
    
    public Rectangle(int x, int y, int d, Graphics gDC)
    {
        this(x, y, d, d, gDC);
    }    
    
    public Rectangle(int x, int y, int s)
    {
        this(x, y, s, s, null);
    }
       
    public Rectangle(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());        
        Stroke oldStroke = gDC.getStroke();
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();        
        switch(getFill()) {
            case 0:    // Line
                gDC.setStroke(Stroke_1);
                gDC.drawRect(x, y, w-1, h-1);
                break;
            case 1:    // Ring            
                BasicStroke bs = 
                    (BasicStroke)getStroke();
                int width  = (int)(bs.getLineWidth()),  
                    x2 = x + width/2,
                    y2 = y + width/2,
                    dW = w - width,
                    dH = h - width;
                gDC.setStroke(getStroke());
                gDC.drawRect(x2, y2, dW-1, dH-1);
                gDC.setColor(Color.black);
                gDC.setStroke(Stroke_1);
                gDC.drawRect(x, y, w-1, h-1);
                x += width;
                y += width;                                
                int ww = w - 2 * width,
                    hh = h - 2 * width;
                gDC.drawRect(x, y, ww-1, hh-1);
                break;
            case 2:    // Full  
                Paint paint = gDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+w, y+h,
                               colorZ
                           ); 
                    gDC.setPaint(grad);
                }
                gDC.fillRect(x, y, w, h);
                gDC.setStroke(new BasicStroke(1));
                gDC.setColor(Color.black);
                gDC.drawRect(x, y, w-1, h-1);
        }            
        gDC.setStroke(oldStroke);
        gDC.setPaint(oldPaint);
    }
}


[[[//*** Klasa Diamond


package janb.view;

import java.awt.*;

public
class Diamond 
    extends Figure {
    
    private Polygon polyOuter, polyDraw, polyInner;
                    
    private Polygon makePolygon(int x, int y, int w, int h)
    {
        Polygon polygon = new Polygon();
        int w2 = w/2,
            h2 = h/2;
        polygon.addPoint(x+w2, y);
        polygon.addPoint(x+w, y+h2);
        polygon.addPoint(x+w2, y+h);
        polygon.addPoint(x, y+h2);    
        return polygon;
    }   
    
    public void makePolygons()
    {
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();
        int ll = (int)
                 (((BasicStroke)getStroke()).getLineWidth()),
            l2 = ll/2;
        polyOuter = makePolygon(x, y, w, h);
        polyDraw  = makePolygon(x+l2, y+l2, w-ll, h-ll);
        polyInner = makePolygon(x+ll, y+ll, w-2*ll, h-2*ll);    
    }                 
       
    public Diamond(int x, int y, int w, int h, Graphics gDC)
    {
        super(x, y, w, h, gDC); 
        makePolygons();
    }
       
    public Diamond(int x, int y, int w, int h)
    {
        this(x, y, w, h, null);    
    }
    
    public Diamond(int x, int y, int d, Graphics gDC)
    {
        this(x, y, d, d, gDC);
    }    
    
    public Diamond(int x, int y, int s)
    {
        this(x, y, s, s, null);
    }
       
    public Diamond(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        Stroke oldStroke = gDC.getStroke();
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();        
        switch(getFill()) {
            case 0:    // Line
                gDC.setStroke(Stroke_1);
                gDC.drawPolygon(polyDraw);
                break;
            case 1:    // Ring     
                gDC.setStroke(getStroke());            
                gDC.drawPolygon(polyDraw);
                gDC.setColor(Color.black);
                gDC.setStroke(new BasicStroke(1));
                gDC.drawPolygon(polyOuter);
                gDC.drawPolygon(polyInner);
                break;
            case 2:    // Full  
                Paint paint = gDC.getPaint();
                Color colorA = null, colorZ = null;
                if(paint instanceof GradientPaint) {
                    GradientPaint grad = 
                       (GradientPaint)paint;
                    colorA = grad.getColor1();
                    colorZ = grad.getColor2();
                    grad = new GradientPaint(
                               x, y,
                               colorA,
                               x+w, y+h,
                               colorZ
                           ); 
                    gDC.setPaint(grad);
                }
                gDC.fillPolygon(polyOuter);
                gDC.setStroke(new BasicStroke(1));
                gDC.setColor(Color.black);
                gDC.drawPolygon(polyOuter);
        }            
        gDC.setStroke(oldStroke);
        gDC.setPaint(oldPaint);
    }
    
    public void setXY(int x, int y)
    {
        super.setXY(x, y);
        makePolygons();
    }
    
    public void setSize(int w, int h)
    {
        super.setSize(w, h);
        makePolygons();
    }
    
    public void setStroke(Stroke stroke)
    {
        super.setStroke(stroke);
        makePolygons();
    }    
}


[[[//*** Klasa String$


package janb.view;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;

public
class String$ 
    extends Figure {    
    
    private String string;
    private Rectangle2D bounds;
    private TextLayout layout;
    
    public String$(int x, int y, String string, Graphics gDC)
    {
        super(x, y, -1, -1, gDC);
        this.string = string;
        bounds = getBounds(string, getFont(), gDC);
        setSize(
            (int)bounds.getWidth(),
            (int)bounds.getHeight()
        );
    }
        
    public static Rectangle2D getBounds(
                                  String string, 
                                  Font font, 
                                  Graphics gDC
                              )
    {
        Graphics2D pDC = (Graphics2D)gDC;
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        TextLayout layout = 
            new TextLayout(string, font, frc);
        return new TextLayout(string, font, frc).
               getBounds();
    }                
    
    public static TextLayout getLayout(
                                 String string, 
                                 Font font,
                                 Graphics gDC)
    {     
        Graphics2D pDC = (Graphics2D)gDC;   
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        return new TextLayout(string, font, frc);
    }            
            
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        Font oldFont = gDC.getFont();
        gDC.setPaint(getPaint());
        gDC.setFont(getFont());

        int xL = getX(),
            yL = getY();
        TextLayout layout = 
            getLayout(string, getFont(), gDC);
        Rectangle2D bounds = layout.getBounds();
        float xB = (float)bounds.getX(),
              yB = (float)bounds.getY();
        layout.draw(gDC, -xB + xL, -yB + yL);
        gDC.setFont(oldFont);
        gDC.setPaint(oldPaint);
    }
}


[[[//*** Klasa Image$


package janb.view;

import java.awt.*;
import java.awt.image.ImageObserver;

public
class Image$ 
    extends Figure {    
    
    private Image image;
    private ImageObserver obs;
    private boolean isScaled;
        
    public Image$(int x, int y, 
                  int w, int h, Image image, 
                  ImageObserver obs)
    {
        super(x, y, w, h, null);
        this.image = image;
        this.obs = obs;
        isScaled = true;
    }    
    
    public Image$(int x, int y, Image image, 
                  ImageObserver obs)
    {  
        this(x, y, -1, -1, image, obs);
        setSize(
            image.getWidth(obs),
            image.getHeight(obs)
        );
        isScaled = false;
    }    
        
    public void draw(Graphics2D gDC)
    {
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();            
        if(isScaled) 
            gDC.drawImage(image, x, y, w, h, obs);
        else
            gDC.drawImage(image, x, y, obs);
    }
}


[[[//*** Klasa Monitor


package janb.view;

import java.util.*;

public
class Monitor {

    private boolean monitorFlag;
    private Object monitor = new Object();
    private static Object cloneLock = new Object();
    private static Vector monitors = new Vector();

    public Monitor(boolean flag)
    {
        monitorFlag = flag;
        synchronized(cloneLock) {
            monitors.add(this);
        }
    }

    public void jbWaitBreak()
        throws InterruptedException
    {
        synchronized(monitor) {
            while(!monitorFlag)
                monitor.wait();
            monitorFlag = false;
        }
    }

    public void jbNotify()
    {
        synchronized(monitor) {
            monitorFlag = true;
            monitor.notify();
        }
    }
    
    public void jbNotifyAll()
    {
        Vector clone;
        synchronized(cloneLock) {
            clone = (Vector)monitors.clone();
        }
        int count = clone.size();
        for(int i = 0; i < count ; i++) {
            Object object = clone.get(i);
            Monitor monitor = ((Monitor)object);
            synchronized(monitor.monitor) {
                monitor.monitorFlag = true;
                monitor.monitor.notify();
            }
        }
    }
    

        // wersja nieprzerywalna, zbdne try
    public void jbWait()
    {
        synchronized(monitor) {
            while(!monitorFlag) {
                try {
                    monitor.wait();
                }
                catch(InterruptedException e) {
                }
            }
            monitorFlag = false;
        }
    }

    public void jbPause()
    {
        synchronized(monitor) {
        }
    }
}

 
[[[//*** Klasa Debugger


package janb.view;

import java.awt.*;
import java.awt.event.*;

public
class Debugger 
    extends Frame {

    private static Debugger frame;
    private static Font font =
        new Font("Monospaced", Font.BOLD, 10);
    private static int limit = -1000000;
    private static String NULL = "NULL String";
    private static int tally = 0;

    public static synchronized 
    boolean check()
    {
        if(limit == 0) {
            textArea.append("\nLimit reached!\n");
            limit = 1;
        }
        if(limit < 0) {
            limit++;
            return true;
        } else
            return false;
    }

    public Font getFont()
    {
        return frame.font;
    }

    class MyTextArea extends TextArea {

        public MyTextArea(String header)
        {
            super(header);
        }
        
        public synchronized
        void paint(Graphics gDC)
        {
            gDC.setFont(frame.getFont());
        }
    }

    String header = "Debugger\n========\n";
    static MyTextArea textArea;
    static boolean opened = false,
                   active = false;
    int xLoc = 320, yLoc = 0;
    private View view;
   
    public Debugger(View view, Point loc, Dimension size)
    {
        this(loc.x, loc.y, size.width, size.height);
        this.view = view;
    }
    
    public Debugger(int x, int y, int width, int height)
    {
        super("Debugger");
        frame = this;
        setLocation(x, y);
        opened = true;
        active = true;
        setSize(width, height);
        textArea = new MyTextArea(header);
        add(textArea, BorderLayout.CENTER);
        addWindowListener(
            new WindowAdapter() {
                public void
                windowClosing(WindowEvent evt)
                {
                    setVisible(false);
                    dispose();
                    opened = false;
                    view.setNotDebugged();
                }
            }
        );
        setVisible(true);
    }
    
    public static synchronized
    void toFrame(String string)
    {
        if(active && check()) {
            if(string != null)
                tally += string.length() + 1;
            else
                tally += NULL.length() + 1;
            if(tally > 50000) {
                String msg = "Window FORCEFULLY cleared!\n";
                textArea.setText(msg);
                tally = msg.length() + string.length() + 1;
            }
            if(string == null)
                string = NULL;
            textArea.append(string + '\n');            
        }
    }
    
    public static synchronized
    void toFrame()
    {
        toFrame("");
    }  
      
    public static synchronized
    void toFrame(int num)
    {
        toFrame("" + num);
    }
    
    public static synchronized    
    void toFrame(boolean bool)
    {
        toFrame("" + bool);
    }
    
    public static synchronized
    void toFrame(double num)
    {
        toFrame("" + num);
    }
    
    public static synchronized
    void toFrame(Object object)
    {
        if(active && check()) {
            if(object != null)
                toFrame(object.toString());
            else
                toFrame("NULL Object");
        }
    }
    
    public static synchronized
    void assert(String what, boolean isTrue)
    {
        if(what == null)
            what = "";
        if(active && !isTrue)
            toFrame("Assertion \"" + what + "\" failed\n");
    }
    
    public static synchronized 
    void on()
    {
        if(opened)
            active = true;
    }
    
    public static synchronized 
    void off()
    {
        active = false;
    }
    
    public static synchronized 
    void setLoc(int x, int y)
    {
        if(active)
            frame.setLocation(x, y);
    }
    
    public static synchronized 
    void setFontSize(int size)
    {
        //if(active)
            font = new Font(
                       "Monospaced", Font.BOLD, size
                   );
    }
    
    public static synchronized 
    void clear()
    {
        if(active)
            textArea.setText("Window cleared!\n");
    }
    
    public static synchronized 
    void setLimit(int limit)
    {
        if(active) {
            if(limit <= 0)
                return;
            Debugger.limit = -limit;
        }
    }
}