package janb.view;

import java.awt.*;

public
class Circle 
    extends Figure {    
    
    public Circle(int x, int y, int w, int h, Paint p)
    {
        super(x, y, w, h, p);
    }
    
    public Circle(int x, int y, int w, int h)
    {
        this(x, y, w, h, View.getPaint());
    }
    
    public Circle(int x, int y, int d, Paint p)
    {
        this(x, y, d, d, p);
    }
    
    public Circle(int x, int y, int d)
    {
        this(x, y, d, d);
    }    
    
    public Circle(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(p);
        gDC.fillOval(x, y, w, h);
        gDC.setColor(Color.black);
        gDC.drawOval(x, y, w-1, h-1);
        gDC.setPaint(oldPaint);
    }
}