package com.javapowertools.taxcalculator.domain;

import java.util.ArrayList;
import java.util.List;

/**
 * Kalkulator podatkowy
 *
 * @author wakaleo
 *
 */
public class TaxCalculator {

    public static final List<TaxRate> TAX_RATES = new ArrayList<TaxRate>();

    static {
        TAX_RATES.add(new TaxRate(0, 43405, 0.19));
        TAX_RATES.add(new TaxRate(43405, 85528, 0.30));
        TAX_RATES.add(new TaxRate(85528, 0, 0.40));
    }

    public TaxCalculator() {
    }

    public double calculateIncomeTax(double totalRevenue) {

        assert totalRevenue >= 0 : "Dochd nie moe by ujemny";

        double totalTax = 0.0;
        for (TaxRate rate : TAX_RATES) {
            totalTax += rate.calculateTax(totalRevenue);
        }
        return totalTax;
    }
} 