/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.util.ShapeUtilities;

public class ImageMapDemo7 {
    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(21.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(50.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(152.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(184.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(299.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(275.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(121.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(98.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(103.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(210.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(198.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(165.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(55.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(34.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(77.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 5"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createLineChart("Line Chart Demo 7", "Category", "Count", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setSeriesShapesVisible(0, true);
        lineAndShapeRenderer.setSeriesShapesVisible(1, false);
        lineAndShapeRenderer.setSeriesShapesVisible(2, true);
        lineAndShapeRenderer.setSeriesLinesVisible(2, false);
        lineAndShapeRenderer.setSeriesShape(2, ShapeUtilities.createDiamond((float)4.0f));
        lineAndShapeRenderer.setDrawOutlines(true);
        lineAndShapeRenderer.setUseFillPaint(true);
        lineAndShapeRenderer.setFillPaint(Color.white);
        MyCategorySeriesLabelGenerator myCategorySeriesLabelGenerator = new MyCategorySeriesLabelGenerator();
        lineAndShapeRenderer.setLegendItemURLGenerator(myCategorySeriesLabelGenerator);
        lineAndShapeRenderer.setLegendItemToolTipGenerator(myCategorySeriesLabelGenerator);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        CategoryDataset categoryDataset = ImageMapDemo7.createDataset();
        JFreeChart jFreeChart = ImageMapDemo7.createChart(categoryDataset);
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo(new StandardEntityCollection());
            File file = new File("ImageMapDemo7.png");
            ChartUtilities.saveChartAsPNG(file, jFreeChart, 600, 400, chartRenderingInfo);
            File file2 = new File("ImageMapDemo7.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            printWriter.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            printWriter.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">");
            printWriter.println("<head><title>JFreeChart Image Map Demo 7</title></head>");
            printWriter.println("<body><p>");
            ImageMapUtilities.writeImageMap(printWriter, "chart", chartRenderingInfo);
            printWriter.println("<img src=\"ImageMapDemo7.png\" width=\"600\" height=\"400\" usemap=\"#chart\" alt=\"ImageMapDemo7.png\"/>");
            printWriter.println("</p></body>");
            printWriter.println("</html>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static class MyCategorySeriesLabelGenerator
    implements CategorySeriesLabelGenerator {
        MyCategorySeriesLabelGenerator() {
        }

        public String generateLabel(CategoryDataset categoryDataset, int n) {
            return "series-" + n + ".html";
        }
    }
}

