/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.parser;

import java.util.Date;
import net.objectlab.qalab.util.QALabTags;

public class SingleStat {
    private static final int FULL_COVERAGE = 100;
    private static final String COBERTURA_BRANCH = "cobertura-branch";
    private static final String COBERTURA_LINE = "cobertura-line";
    private Date datetime = null;
    private int statvalue = -1;
    private String type;

    public final void setDate(Date date) {
        this.datetime = new Date(date.getTime());
    }

    public final Date getDate() {
        if (this.datetime != null) {
            return new Date(this.datetime.getTime());
        }
        return null;
    }

    public final void setStatValue(int errors) {
        this.statvalue = errors;
        if (this.type != null) {
            this.checkForInversion();
        }
    }

    private void checkForInversion() {
        if (this.statvalue != -1 && (COBERTURA_BRANCH.equals(this.type) || COBERTURA_LINE.equals(this.type))) {
            this.statvalue = 100 - this.statvalue;
        }
    }

    public final int getStatValue() {
        return this.statvalue;
    }

    public final void setType(String statisticsType) {
        this.type = statisticsType;
        this.checkForInversion();
    }

    public final String getType() {
        return this.type;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type).append(" - ");
        buf.append(QALabTags.DEFAULT_DATETIME_FORMAT.format(this.datetime));
        buf.append(" - V:").append(this.statvalue);
        return buf.toString();
    }
}

