/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.ant;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import net.objectlab.qalab.parser.BuildStatMoverHandler;
import net.objectlab.qalab.util.QALabTags;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BuildStatMoverTask
extends Task
implements TaskLogger {
    private static final int MIN_DATE_SIZE = 18;
    private File inputFile = null;
    private String startTimeHoursOffset;
    private String types;
    private File outputXMLfile;
    private boolean quiet = false;
    private boolean weekendAdjustment = false;
    private String startTimeWindow = null;
    private String endTimeWindow = null;
    private Integer hoursOffsetForLastRun = null;

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean noLog) {
        this.quiet = noLog;
    }

    public final void execute() {
        this.validate();
        if (!this.quiet) {
            this.log("inputFile='" + this.inputFile.getPath() + "', type='" + this.getTypes() + "'" + " output='" + this.getOutputXMLfile().getPath() + "' adjustForWeekend='" + this.isWeekendAdjustment() + "'" + " startTimeOffset='" + this.getStartTimeHoursOffset() + "'" + " startTimeWindow='" + this.getStartTimeWindow() + "'" + " endTimeWindow='" + this.getEndTimeWindow() + "'");
        }
        try {
            BuildStatMoverHandler handler = new BuildStatMoverHandler(new InputSource(new FileReader(this.getInputFile())), this.getTypes(), new FileWriter(this.getOutputXMLfile()), this.isWeekendAdjustment(), this, this.quiet);
            if (this.startTimeWindow != null) {
                handler.setStartTimeWindow(QALabTags.DEFAULT_DATETIME_FORMAT.parse(this.startTimeWindow));
            }
            if (this.endTimeWindow != null) {
                handler.setEndTimeWindow(QALabTags.DEFAULT_DATETIME_FORMAT.parse(this.endTimeWindow));
            }
            if (this.getStartTimeHoursOffset() != null) {
                handler.setOffsetHours(this.getStartTimeHoursOffset());
            }
            if (this.getHoursOffsetForLastRun() != null) {
                handler.setHoursOffsetForLastRun(this.hoursOffsetForLastRun);
            }
            handler.process();
        }
        catch (ParserConfigurationException e) {
            this.log(e.toString());
        }
        catch (SAXException e) {
            this.log(e.toString());
        }
        catch (IOException e) {
            this.log(e.toString());
        }
        catch (ParseException e) {
            throw new BuildException("Date Parse issue", (Throwable)e);
        }
    }

    private void validate() {
        if (this.inputFile == null) {
            throw new BuildException("inputFile is mandatory");
        }
        if (this.startTimeHoursOffset != null && this.startTimeWindow != null) {
            throw new BuildException("use startTimeHoursOffset OR startTimeWindow, not both.");
        }
    }

    public final void log(String text) {
        super.log(text);
    }

    public final String getStartTimeHoursOffset() {
        return this.startTimeHoursOffset;
    }

    public final void setStartTimeHoursOffset(String hours) {
        this.startTimeHoursOffset = hours;
    }

    public final String getTypes() {
        return this.types;
    }

    public final void setTypes(String type) {
        this.types = type;
    }

    public final File getOutputXMLfile() {
        return this.outputXMLfile;
    }

    public final void setOutputXMLfile(File outputFile) {
        this.outputXMLfile = outputFile;
    }

    public final File getInputFile() {
        return this.inputFile;
    }

    public final void setInputFile(File inputXML) {
        this.inputFile = inputXML;
    }

    public final void setWeekendAdjustment(boolean wkendadj) {
        this.weekendAdjustment = wkendadj;
    }

    public final boolean isWeekendAdjustment() {
        return this.weekendAdjustment;
    }

    public final void setEndTimeWindow(String endTime) {
        this.endTimeWindow = endTime.trim();
        if (this.endTimeWindow.length() < 18) {
            this.endTimeWindow = this.endTimeWindow + " 00:00:00";
        }
    }

    public final String getEndTimeWindow() {
        return this.endTimeWindow;
    }

    public final void setStartTimeWindow(String startTime) {
        this.startTimeWindow = startTime.trim();
        if (this.startTimeWindow.length() < 18) {
            this.startTimeWindow = this.startTimeWindow + " 00:00:00";
        }
    }

    public final String getStartTimeWindow() {
        return this.startTimeWindow;
    }

    public Integer getHoursOffsetForLastRun() {
        return this.hoursOffsetForLastRun;
    }

    public void setHoursOffsetForLastRun(Integer hoursOffsetForLastRun) {
        this.hoursOffsetForLastRun = hoursOffsetForLastRun;
    }
}

