/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Window;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYAreaChartDemo2
extends ApplicationFrame {
    public XYAreaChartDemo2(String string) {
        super(string);
        JPanel jPanel = XYAreaChartDemo2.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries("Random 1");
        double d = 0.0;
        Day day = new Day();
        for (int i = 0; i < 200; ++i) {
            d = d + Math.random() - 0.5;
            timeSeries.add((RegularTimePeriod)day, d);
            day = (Day)day.next();
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        return timeSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYAreaChart("XY Area Chart Demo 2", "Time", "Value", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        DateAxis dateAxis = new DateAxis("Time");
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        xYPlot.setDomainAxis(dateAxis);
        xYPlot.setForegroundAlpha(0.5f);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        xYItemRenderer.setToolTipGenerator(new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("#,##0.00")));
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        return new ChartPanel(XYAreaChartDemo2.createChart(XYAreaChartDemo2.createDataset()));
    }

    public static void main(String[] stringArray) {
        XYAreaChartDemo2 xYAreaChartDemo2 = new XYAreaChartDemo2("XY Area Chart Demo 2");
        xYAreaChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)xYAreaChartDemo2));
        xYAreaChartDemo2.setVisible(true);
    }
}

