/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class MultipleAxisDemo3
extends ApplicationFrame {
    public MultipleAxisDemo3(String string) {
        super(string);
        JPanel jPanel = MultipleAxisDemo3.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(600, 270));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart() {
        XYDataset xYDataset = MultipleAxisDemo3.createDataset("Series 1", 100.0, new Minute(), 200);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Multiple Axis Demo 3", "Time of Day", "Primary Range Axis", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        xYItemRenderer.setPaint(Color.black);
        NumberAxis numberAxis = new NumberAxis("Domain Axis 2");
        numberAxis.setAutoRangeIncludesZero(false);
        xYPlot.setDomainAxis(1, numberAxis);
        xYPlot.setDomainAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        NumberAxis numberAxis2 = new NumberAxis("Domain Axis 3");
        numberAxis.setAutoRangeIncludesZero(false);
        xYPlot.setDomainAxis(2, numberAxis2);
        xYPlot.setDomainAxisLocation(2, AxisLocation.BOTTOM_OR_LEFT);
        NumberAxis numberAxis3 = new NumberAxis("Range Axis 2");
        xYPlot.setRangeAxis(1, numberAxis3);
        xYPlot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        XYDataset xYDataset2 = MultipleAxisDemo3.createDataset("Series 2", 1000.0, new Minute(), 170);
        xYPlot.setDataset(1, xYDataset2);
        xYPlot.mapDatasetToDomainAxis(1, 1);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        return jFreeChart;
    }

    private static XYDataset createDataset(String string, double d, RegularTimePeriod regularTimePeriod, int n) {
        TimeSeries timeSeries = new TimeSeries(string, regularTimePeriod.getClass());
        RegularTimePeriod regularTimePeriod2 = regularTimePeriod;
        double d2 = d;
        for (int i = 0; i < n; ++i) {
            timeSeries.add(regularTimePeriod2, d2);
            regularTimePeriod2 = regularTimePeriod2.next();
            d2 *= 1.0 + (Math.random() - 0.495) / 10.0;
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = MultipleAxisDemo3.createChart();
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        MultipleAxisDemo3 multipleAxisDemo3 = new MultipleAxisDemo3("Multiple Axis Demo 3");
        multipleAxisDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)multipleAxisDemo3));
        multipleAxisDemo3.setVisible(true);
    }
}

