import java.util.*;
import java.util.logging.*;

public class BuggyTaskQueue {
    private ArrayList scheduledTasks = new ArrayList();
    private ArrayList completedTasks = new ArrayList();

    public void addScheduledTask(Task t) {
        scheduledTasks.add(t);
    }
    public void addCompletedTask(Task t) {
        completedTasks.add(t);
    }
    public void performTask() {
        Task taskToDo = null;
        try {
            synchronized (this) {
                if (hasTasks()) {
                    taskToDo = getTask();
                    int result = taskToDo.runTask();
                    if (result == Status.SUCCESS) {
                        addCompletedTask(taskToDo);
                    } else if (result == Status.WAIT) {
                        addScheduledTask(taskToDo);
                    } else {
                        Logger.getLogger("default").warning(
                                "Pojawi si problem podczas dziaania"
                                        + taskToDo);
                    }
                }
            }
        } catch (RuntimeException exc) {
            Logger.getLogger("default").log(Level.SEVERE,
                    "Wyjtek w czasie dziaania" + taskToDo, exc);
            System.out.println(scheduledTasks);
            System.out.println(completedTasks);
        }
    }

    public Task getTask() {
        return (Task) scheduledTasks.remove(0);
    }
    public boolean hasTasks() {
        return (scheduledTasks.size() > 0);
    }
}