
import java.sql.*;
import javax.sql.*;
import javax.naming.*;

public class AccountDAO implements CustomerDAO, AddressDAO, PaymentInfoDAO {
    private DataSource dbmsConnectionFactory;

    private void initDataSource() {
        try {
            Context ctx = new InitialContext();
            dbmsConnectionFactory = (DataSource) ctx
                    .lookup("java:comp/env/jdbc/customerDB");
        } catch (NamingException exc) {

        }
    }

    public void insertCustomer(Customer c) 
    	throws CustomerExistsException, SQLException {
        String selectSql = 
            "SELECT * FROM Customer WHERE first_name=? AND last_name=?";
        String insertSql = "INSERT INTO Customer VALUES(?, ?)";
        try {
            Connection conn = dbmsConnectionFactory.getConnection();
            PreparedStatement selectStmt = conn.prepareStatement(selectSql);
            selectStmt.setString(1, c.getFirstName());
            selectStmt.setString(2, c.getLastName());
            ResultSet rs = selectStmt.executeQuery();
            if (rs.next()) {
                // W tym miejscu okazuje si, e w bazie danych
                // istnieje ju okrelony rekord
                throw new CustomerExistsException(
                        "Niemoliwe dodanie danych klienta " + c, c);
            } 
            else {
                PreparedStatement insertStmt = conn.prepareStatement(insertSql);
                insertStmt.setString(1, c.getFirstName());
                insertStmt.setString(2, c.getLastName());
                int status = insertStmt.executeUpdate();
            }
        } 
        catch (SQLException exc) {
            Logger.log(exc);
            throw exc;
        }
    }

    public void insertCustomerJustInsert(Customer c)
            throws CustomerExistsException {
        String insertSql = "INSERT INTO Customer VALUES(?, ?)";
        try {
            Connection conn = dbmsConnectionFactory.getConnection();
            PreparedStatement insertStmt = conn.prepareStatement(insertSql);
            insertStmt.setString(1, c.getFirstName());
            insertStmt.setString(2, c.getLastName());
            int status = insertStmt.executeUpdate();
            if (status == 0) {
                throw new CustomerExistsException(
                        "Niemoliwe dodanie klienta " + c, c);
            }
        } catch (SQLException exc) {
            throw new CustomerExistsException("Niemoliwe dodanie klienta " + c, c);
        }
    }

    public void insertAddress(Address addr) {
    }

    public void insertPaymentInfo(PaymentInfo p) {
    }
}