import java.net.*;
import java.io.*;

public class ClientNetwork{
    private Socket connection;
    private ObjectInputStream input;
    private ObjectOutputStream output;
    
    public void connect(String host, int port)throws IOException{
        connection = new Socket(host, port);
        input = new ObjectInputStream(connection.getInputStream());
        output = new ObjectOutputStream(connection.getOutputStream());
    }
    
    public void disconnect(){
        if (connection != null){
            try{
                connection.close();
            }
            catch (IOException exc){
                // Nie podejmujemy adnej akcji,
                // wyjtek nie wymaga obsugi
            }
            finally{
                connection = null;
                input = null;
                output = null;
            }
        }
    }
    
    public Object sendData(Serializable data)throws IOException{
        Object returnValue = null;
        output.writeObject(data);
        try{
            returnValue = input.readObject();
        }
        catch (ClassNotFoundException exc){
            System.err.println("Serwer nie zwrci wymaganej klasy");
        }
        return returnValue;
    }
}
