import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class HandlerController extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse rsp)
            throws ServletException, IOException {
        processRequest(req, rsp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp)
            throws ServletException, IOException {
        processRequest(req, rsp);
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse rsp)
            throws ServletException, IOException {
        String action = NavigateConstants.NO_ACTION;
        try {
            action = req.getParameter(NavigateConstants.NAV_FORM_NAME);
            if (action.equals(NavigateConstants.NAV_LOGIN)) {
                RequestDispatcher rd = req
                        .getRequestDispatcher(NavigateConstants.LOGIN);
                rd.forward(req, rsp);
            } else if (action.equals(NavigateConstants.NAV_REGISTER)) {
                RequestDispatcher rd = req
                        .getRequestDispatcher(NavigateConstants.REGISTER);
                rd.forward(req, rsp);
            } else if (action.equals(NavigateConstants.NAV_LOGOUT)) {
                RequestDispatcher rd = req
                        .getRequestDispatcher(NavigateConstants.LOGOUT);
                rd.forward(req, rsp);
            }
        } catch (Exception exc) {
            SystemHealthVO health = HealthCheckService.checkSystemHealth();
            LoggingManager.log("Wystpi wyjtek wewntrz procesu biznesowego"
                    + action);
            LoggingManager.log("Stos: ", exc);
            LoggingManager.log("Stan systemu:  ", health);
        }
    }
}