import java.util.Date;
import java.text.SimpleDateFormat;

public class Profile{
    private Runtime runtime;
    private long startTime, stopTime, timeElapsed;
    private SimpleDateFormat formatter = new SimpleDateFormat("mm:ss.SSSS");
    
    public Profile(){
        runtime = Runtime.getRuntime();
    }
    
    public void startTimer(){
        startTime = System.currentTimeMillis();
    }
    public void stopTimer(){
        stopTime = System.currentTimeMillis();
        timeElapsed += stopTime - startTime;
    }
    public void clearTimer(){
        startTime = stopTime = timeElapsed = 0;
    }
    
    public long getStartTimeMillis(){
        return startTime;
    }
    public long getStopTimeMillis(){
        return stopTime;
    }
    public long getStartStopTimeMillis(){
        return stopTime - startTime;
    }
    public long getTimeElapsedMillis(){
        return timeElapsed;
    }
    
    public Date getStartTime(){
        return new Date(startTime);
    }
    public Date getStopTime(){
        return new Date(stopTime);
    }
    public Date getStartStopTime(){
        return new Date(stopTime - startTime);
    }
    public Date getTimeElapsed(){
        return new Date(stopTime);
    }
    
    public String getTimeElapsedAsString(){
        StringBuffer buffer = new StringBuffer();
        return formatter.format(new Date(timeElapsed));
    }
    public String getStartStopTimeAsString(){
        StringBuffer buffer = new StringBuffer();
        return formatter.format(new Date(stopTime - startTime));
    }
    
    public long getFreeMemory(){
        runtime.gc();
        try{
            Thread.sleep(100);
        }
        catch (InterruptedException exc){}
        return runtime.freeMemory();
    }

	public long getTotalMemory(){
        runtime.gc();
        try{
            Thread.sleep(100);
        }
        catch (InterruptedException exc){}
        return runtime.totalMemory();
    }
}
