public class ExceptionHandlingFramework{
    private final HandlerStrategy strategy;
    private BusinessService bizService;
    
    public ExceptionHandlingFramework(HandlerStrategy strat){
        strategy = strat;
    }
    public ExceptionHandlingFramework(HandlerStrategy strat, BusinessService bizSvc){
        strategy = strat;
        bizService = bizSvc;
    }
    
    public void businessOperation() throws BusinessException{
        try{
            bizService.businessOperation();
        }
        catch (Throwable exc){
            strategy.handleException(exc);
        }
    }
}