import java.sql.*;
import javax.naming.*;
import javax.sql.*;

public class CustomerDAO {
    private DataSource dataSce;
    private String dsName = "java:comp/env/jdbc/DBSource";

    public CustomerDAO() throws NamingException, ClassCastException {
        Context ctx = new InitialContext();
        dataSce = (DataSource) ctx.lookup(dsName);
    }

    public CustomerVO getCustomer(String cid) throws CustomerException {
        CustomerVO rtnVal = new CustomerVO();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            conn = dataSce.getConnection();
            ps = conn.prepareStatement("SELECT * FROM Customer WHERE cid = ?");
            ps.setString(1, cid);
            rs = ps.executeQuery();
            if (rs.next()) {
                rtnVal.setName(rs.getString(1));
                rtnVal.setId(cid);
            }
        } catch (SQLException exc) {
            throw new CustomerException(
                    "Niemoliwy dostp do klienta, wyjtek SQLException", exc);
        } finally {
            close(rs, ps, conn);
        }
        return rtnVal;
    }

    public void updateCustomer(CustomerVO cust) throws CustomerException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = dataSce.getConnection();
            ps = conn
                    .prepareStatement("UPDATE Customer SET name = ? WHERE cid = ?");
            ps.setString(1, cust.getName());
            ps.setString(2, cust.getId());
            ps.executeUpdate();
        } catch (SQLException exc) {
            throw new CustomerException(
                    "Niemoliwa aktualizacja danych klienta, wyjatek SQLException",
                    exc);
        } finally {
            close(null, ps, conn);
        }
    }

    private void close(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException exc) {
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            } catch (SQLException exc) {
            }
        }
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException exc) {
            }
        }
    }
}