package db.przyklad4.server.processors;

import java.sql.*;
import java.util.*;
import java.io.*;

import db.przyklad4.objects.*;

public class SQLProcessor2
{
  protected Connection _connection = null;
  protected String _dbUrl = null;

  protected File _logFile = new File("SQLProcessor2.log");
  protected ObjectProcessor _objectProcessor = null;
  protected ReportProcessor _reportProcessor = null;

  public SQLProcessor2(String drivers, String dbUrl)
  {
    _dbUrl = dbUrl;

    Properties properties = System.getProperties();
    properties.put("jdbc.drivers", "sun.jdbc.odbc.JdbcOdbcDriver:interbase.interclient.Driver");

    if(null != drivers)
    {
      String str = (String) properties.get("jdbc.drivers");
      properties.put("jdbc.drivers", str + ":" + drivers);
    }
  }

  public SQLProcessor2(String dbUrl)
  {    
    this(null, dbUrl);
  }

  public boolean openConnection(String user, String password)
  {
    try
    {
      _connection = DriverManager.getConnection(_dbUrl, user, password);
      DriverManager.setLogWriter(new PrintWriter(new FileOutputStream(_logFile)));

      _connection.setAutoCommit(false);

      _objectProcessor = new ObjectProcessor(_connection);
      _reportProcessor = new ReportProcessor(_connection);
    }
    catch(Exception e)
    {
      e.printStackTrace(DriverManager.getLogWriter());

      _connection =  null;

      _objectProcessor = null;
      _reportProcessor = null;
      
      return false;
    }

    return true;
  }

  public void closeConnection()
  {
    if(null != _connection)
    {
      try
      {
        _connection.close();
      }
      catch(SQLException e)
      {
        e.printStackTrace(DriverManager.getLogWriter());
      }
      finally
      {
        _connection = null;
        
        _objectProcessor = null;
        _reportProcessor = null;
      }
    }
  }

  public ObjectProcessor getObjectProcessor()
  {
    return _objectProcessor;
  }

  public ReportProcessor getReportProcessor()
  {
    return _reportProcessor;
  }
}