package db.przyklad4.server.processors;
   
import java.sql.*;
import java.util.*;
import java.io.*;

import db.przyklad4.objects.*;

public class ReportProcessor
{    
  private Connection _connection = null;

  public ReportProcessor(Connection connection)
  {
    _connection = connection;
  }

  public String createReport(int employeeId)
  {
    String sql = "SELECT sale_date, sale_name, sale_val, cust_fname, cust_lname " +
                 "FROM sales_tab s LEFT OUTER JOIN customer_tab c " +
                 "ON s.cust_pesel = c.cust_pesel " +  
                 "WHERE s.emp_id = ? " +
                 "ORDER BY sale_date, sale_name, sale_val, cust_lname, cust_fname;";

    try
    {
      PreparedStatement prepStatement = _connection.prepareStatement(sql);
      prepStatement.setInt(1, employeeId);

      return createReport(prepStatement);
    }
    catch(SQLException e)
    {                 
      e.printStackTrace(DriverManager.getLogWriter());
      return null;
    }
  }

  public String createReport(int employeeId, java.sql.Date period)
  {                  
    String sql = "SELECT sale_date, sale_name, sale_val, cust_fname, cust_lname " +
                 "FROM sales_tab s LEFT OUTER JOIN customer_tab c " +
                 "ON s.cust_pesel = c.cust_pesel " +
                 "WHERE s.emp_id = ? AND s.sale_date >= ? " +
                 "ORDER BY sale_date, sale_name, sale_val, cust_lname, cust_fname;";

    try
    {
      PreparedStatement prepStatement = _connection.prepareStatement(sql);
      prepStatement.setInt(1, employeeId);
      prepStatement.setDate(2, period);

      return createReport(prepStatement);
    }
    catch(SQLException e)
    {                 
      e.printStackTrace(DriverManager.getLogWriter());
      return null;
    }
  }

  public String createReport(int employeeId, double money)
  {
    String sql = "SELECT sale_date, sale_name, sale_val, cust_fname, cust_lname " +
                 "FROM sales_tab s LEFT OUTER JOIN customer_tab c " +
                 "ON s.cust_pesel = c.cust_pesel " +
                 "WHERE s.emp_id = ? AND s.sale_val >= ? " +
                 "ORDER BY sale_date, sale_name, sale_val, cust_lname, cust_fname;";

    try
    {
      PreparedStatement prepStatement = _connection.prepareStatement(sql);
      prepStatement.setInt(1, employeeId);
      prepStatement.setDouble(2, money);

      return createReport(prepStatement);
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
      return null;
    }
  }   

  public String createReport(int employeeId, double money, java.sql.Date period)
  {
    String sql = "SELECT sale_date, sale_name, sale_val, cust_fname, cust_lname " +
                 "FROM sales_tab s LEFT OUTER JOIN customer_tab c " +
                 "ON s.cust_pesel = c.cust_pesel " +
                 "WHERE s.emp_id = ? AND s.sale_val >= ? AND s.sale_date >= ? " +
                 "ORDER BY sale_date, sale_name, sale_val, cust_lname, cust_fname;";

    try
    {
      PreparedStatement prepStatement = _connection.prepareStatement(sql);
      prepStatement.setInt(1, employeeId);
      prepStatement.setDouble(2, money);
      prepStatement.setDate(3, period);

      return createReport(prepStatement);
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
      return null;
    }
  }

  private String createReport(PreparedStatement statement) throws SQLException
  {
    StringBuffer buffer = new StringBuffer("");
    
    if(!statement.execute())
      return "<BR><BR><CENTER>No sales</CENTER>";

    do
    {
      ResultSet resultSet = statement.getResultSet();
      buffer.append("<TABLE>");

      while(resultSet.next())
      {
        buffer.append("<TR><TD>" + resultSet.getDate("sale_date").toString() + "&nbsp;</TD>");
        buffer.append("<TD><STRONG>" + resultSet.getString("sale_name") + "</STRONG>&nbsp;</TD>");
        buffer.append("<TD ALIGN='right'>" + resultSet.getString("sale_val") + "&nbsp;</TD>");
        buffer.append("<TD><FONT SIZE='-1'>klient:&nbsp;</FONT>&nbsp;" + resultSet.getString("cust_lname"));
        buffer.append("&nbsp;" + resultSet.getString("cust_fname") + "&nbsp;</TD></TR>");
      }

      buffer.append("</TABLE>");
    }
    while(statement.getMoreResults());
    
    return buffer.toString();
  }
} 