package db.przyklad4.server.processors;
 
import java.sql.*;
import java.util.*;
import java.io.*;

import db.przyklad4.objects.*;

public class ObjectProcessor
{
  private Connection _connection = null;

  public ObjectProcessor(Connection connection)
  {
    _connection = connection;
  }

  public Departament[] getDepartaments()
  {
    String sql = "SELECT * FROM departament_tab;";
    Departament[] departaments = null;

    try
    {
      Vector vector = new Vector(10, 5);

      Statement statement = _connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next())
      {
        Departament departament = new Departament(resultSet.getInt(1),
                                                  resultSet.getString(2),
                                                  resultSet.getInt(3),
                                                  resultSet.getDouble(4));

        vector.addElement(departament);
      }

      vector.trimToSize();
      departaments = new Departament[vector.size()];
      vector.copyInto(departaments);
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
    }

    return departaments;
  }

  public boolean addDepartament(String departament)
  {
    String sql = "{call add_new_departament(?)}";

    try
    {
      CallableStatement callStatement = _connection.prepareCall(sql);
      callStatement.setString(1, departament);
      callStatement.executeUpdate();

      return true;
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
      return false;
    }
  }

  public boolean setDepartamentHead(int depId, int employeeId)
  {
    String sql = "UPDATE departament_tab SET dep_head_id = ? WHERE dep_id = ?;";

    try
    {
      PreparedStatement prepStatement = _connection.prepareStatement(sql);
      prepStatement.setInt(1, depId);
      prepStatement.setInt(2, employeeId);

      int count = prepStatement.executeUpdate();

      return (1 == count);
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
      return false;
    }
  }

  public Employee[] getEmployeesForDepartament(int depId)
  {
    String sql = "SELECT emp_id, emp_fname, emp_lname, emp_sales FROM employee_tab WHERE dep_id = ?;";
    Employee[] employees = null;

    try
    {
      Vector vector = new Vector(50, 10);
      
      PreparedStatement prepStatement = _connection.prepareStatement(sql);
      prepStatement.setInt(1, depId);
      ResultSet resultSet = prepStatement.executeQuery();

      while(resultSet.next())
      {
        Employee employee = new Employee(resultSet.getInt(1),
                                         resultSet.getString(2),
                                         resultSet.getString(3),
                                         depId,
                                         resultSet.getDouble(4));

        vector.addElement(employee);
      }

      vector.trimToSize();
      employees = new Employee[vector.size()];
      vector.copyInto(employees);
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
    }

    return employees;
  }

  public boolean addEmployee(int depId, String firstName, String lastName, double salary)
  {
    String sql = "{call add_new_employee(?, ?, ?, ?)}";

    try
    {
      CallableStatement callStatement = _connection.prepareCall(sql);
      callStatement.setInt(1, depId);
      callStatement.setString(2, firstName);
      callStatement.setString(3, lastName);
      callStatement.setDouble(4, salary);

      callStatement.executeUpdate();
      return true;
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
      return false;
    }
  }

  public boolean addCustomer(long pesel, String firstName, String lastName, char sex)
  {
    String sql = "{call add_new_customer(?, ?, ?, ?)}";

    try
    {
      CallableStatement callStatement = _connection.prepareCall(sql);
      callStatement.setLong(1, pesel);
      callStatement.setString(2, firstName);
      callStatement.setString(3, lastName);
      callStatement.setString(4, String.valueOf(sex));

      callStatement.executeUpdate();
      return true;
    }
    catch(SQLException e)
    {
      e.printStackTrace(DriverManager.getLogWriter());
      return false;
    }
  }

  public boolean addSale(long pesel, int employeeId, String description, double value)
  {
    String sql = "{call add_new_sale(?, ?, ?, ?)}";

    try
    {
      CallableStatement callStatement = _connection.prepareCall(sql);
      callStatement.setLong(1, pesel);
      callStatement.setInt(2, employeeId);
      callStatement.setString(3, description);
      callStatement.setDouble(4, value);

      callStatement.executeUpdate();
      return true;
    }
    catch(SQLException e)
    {   
      e.printStackTrace(DriverManager.getLogWriter());
      return false;
    }
  }
}