/* this is PL/SQL template */

/* ------------------ EMPLOYEE TABLE ---------------------- */
CREATE TABLE employee_tab
(
	emp_id INTEGER NOT NULL,
	dep_id INTEGER NOT NULL,
	emp_fname VARCHAR(50) NOT NULL,
	emp_lname VARCHAR(50) NOT NULL,
	emp_salary DECIMAL(10,2),
	emp_sales DECIMAL(10,2) DEFAULT 0,

	PRIMARY KEY(emp_id),
	FOREIGN KEY (dep_id) REFERENCES departament_tab(dep_id)
		ON DELETE CASCADE
		ON UPDATE CASCADE,
	CHECK (emp_salary > 0),
	CHECK (0 <= emp_sales)
);

CREATE GENERATOR emp_id_gen;

CREATE TRIGGER emp_id_trig FOR employee_tab
BEFORE INSERT
AS
BEGIN
 employee_tab.emp_id = GEN_ID(emp_id_gen, 1);
END;

CREATE TRIGGER delete_employee_trig FOR employee_tab
BEFORE DELETE
AS
BEGIN
	UPDATE departament_tab
	SET departament_tab.dep_head_id = NULL
	WHERE departament_tab.dep_head_id = OLD.emp_id;
END;

/* ------------------- DEPARTAMENT TABLE ---------------------- */
CREATE TABLE departament_tab
(
	dep_id INTEGER NOT NULL,
	dep_name VARCHAR(30) NOT NULL,
	dep_head_id INTEGER DEFAULT NULL,
	dep_sales DECIMAL(15,2) DEFAULT 0,

	PRIMARY KEY (dep_id),
	CHECK (0 <= dep_sales)
);

ALTER TABLE departament_tab 
	ADD CONSTRAINT dep_head_id_constr CHECK ( (dep_head_id IS NULL) OR 
                                            (dep_head_id IN (SELECT emp_id FROM employee_tab)) );

CREATE GENERATOR dep_id_gen;

CREATE TRIGGER dep_id_trig FOR departament_tab
BEFORE INSERT
AS
BEGIN
	departament_tab.dep_id = GEN_ID(dep_id_gen, 1);
END;

/* ---------------- DEPARTAMENT LOCATION TABLE ---------------- */
CREATE TABLE location_tab
(
	loc_id INTEGER NOT NULL,
	dep_id INTEGER NOT NULL,
	loc_country VARCHAR(50) NOT NULL,
	loc_city VARCHAR(50) NOT NULL,

	PRIMARY KEY (loc_id),
	FOREIGN KEY (dep_id) REFERENCES departament_tab(dep_id)
		ON UPDATE CASCADE
		ON DELETE CASCADE
);

CREATE GENERATOR loc_id_gen;

CREATE TRIGGER loc_id_trig FOR location_tab
BEFORE INSERT
AS
BEGIN
	location_tab.loc_id = GEN_ID(loc_id_gen, 1);
END;

/* ------------------ CUSTORME TABLE ------------------------------ */
CREATE TABLE customer_tab
(
	cust_pesel NUMERIC(11) NOT NULL,
	cust_fname VARCHAR(50) NOT NULL,
	cust_lname VARCHAR(50) NOT NULL,
	cust_sex CHAR(1) DEFAULT NULL,
	cust_phone VARCHAR(20) DEFAULT NULL,
	cust_contact_address VARCHAR(50) DEFAULT NULL,
	cust_memo VARCHAR(250) DEFAULT NULL,

	PRIMARY KEY (cust_pesel),
	CHECK ((cust_sex IS NULL) OR ( cust_sex IN ('F', 'M', 'f', 'm') ))
);

/* ------------------ SALES TABLE --------------------------------- */
CREATE TABLE sales_tab
(
	sale_id INTEGER NOT NULL,
	cust_pesel NUMERIC(11) NOT NULL,
	emp_id INTEGER NOT NULL,
	sale_name VARCHAR(50) DEFAULT NULL,
	sale_date DATE DEFAULT 'TODAY' NOT NULL,
	sale_val DECIMAL(10,2) NOT NULL,
	
	PRIMARY KEY (sale_id),
	CHECK (0 <= sale_val)
);

CREATE GENERATOR sale_id_gen;

CREATE TRIGGER sale_added_trig FOR sales_tab
BEFORE INSERT
AS
BEGIN
	sales_tab.sale_id = GEN_ID(sale_id_gen, 1);

	UPDATE employee_tab
	SET emp_sales = emp_sales + NEW.sale_val
	WHERE employee_tab.emp_id = NEW.emp_id;

	UPDATE departament_tab
	SET dep_sales = dep_sales + NEW.sale_val
	WHERE dep_id = (SELECT dep_id 
									FROM employee_tab 
									WHERE employee_tab.emp_id = NEW.emp_id);
END;

CREATE TRIGGER sale_changed_trig FOR sales_tab
BEFORE UPDATE
AS
BEGIN
  UPDATE employee_tab
	SET emp_sales = emp_sales + (NEW.sale_val - OLD.sale_val)
	WHERE employee_tab.emp_id = NEW.emp_id;

	UPDATE departament_tab
	SET dep_sales = dep_sales + (NEW.sale_val - OLD.sale_val)
	WHERE dep_id = (SELECT dep_id 
									FROM employee_tab 
									WHERE employee_tab.emp_id = NEW.emp_id);
END;

/* ------------------- PROCEDURES ------------------------ */

CREATE PROCEDURE add_new_sale(cust_pesel NUMERIC(11), emp_id INTEGER, sale_name VARCHAR(50), sale_val DECIMAL(10,2))
AS
BEGIN
	INSERT INTO sales_tab(cust_pesel, emp_id, sale_name, sale_val)
	VALUES(:cust_pesel, :emp_id, :sale_name, :sale_val);
END;

CREATE PROCEDURE update_sale_value(sale_id INTEGER, sale_val DECIMAL(10,1))
AS
BEGIN
	UPDATE sales_tab
	SET sale_val = :sale_val
	WHERE sale_id = :sale_id;
END;