package db.przyklad4.client;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;  
import javax.swing.event.*;
import java.rmi.*;
import java.util.*;

import db.przyklad4.*;
import db.przyklad4.objects.*;

public class MainFrame extends JFrame
{
  JMenuBar menuBar = new JMenuBar();
  JMenu menuFile = new JMenu();
  JMenuItem menuExit = new JMenuItem();
  BorderLayout borderLayout1 = new BorderLayout();
  JMenuItem menuConnect = new JMenuItem();
  JMenuItem menuDisconnect = new JMenuItem();
  JMenu menuOptions = new JMenu();
  JMenuItem menuForce = new JMenuItem();
  JSplitPane splitPane = new JSplitPane();
  JPanel leftPanel = new JPanel();
  JPanel rigthPanel = new JPanel();
  BorderLayout borderLayout2 = new BorderLayout();
  BorderLayout borderLayout3 = new BorderLayout();
  JScrollPane treeScrollPane = new JScrollPane();
  JScrollPane listScrollPane = new JScrollPane();

  DefaultListModel listModel = new DefaultListModel();
  JList list = new JList(listModel);

  DefaultMutableTreeNode root = new DefaultMutableTreeNode(new String("All Departaments"), true);
  DefaultTreeModel treeModel = new DefaultTreeModel(root);
  CheckboxTree tree = new CheckboxTree(treeModel);

  JPanel topPanel = new JPanel();
  JScrollPane reportScrollPane = new JScrollPane();
  HTMLPanel report = new HTMLPanel();
  JRadioButton wholePeriodRadioButton = new JRadioButton();
  JRadioButton selectPeriodRadioButton = new JRadioButton();

  String[] periods = {"1 day", " 2 days", "1 week", "1 mnoth", "2 months", "6 months", "1 year"};
  JComboBox periodComboBox = new JComboBox(periods);
  
  JRadioButton anyAmountRadioButton = new JRadioButton();
  JRadioButton selectAmountRadioButton = new JRadioButton();

  String[] money = {"500 PLN", "1'000 PLN", "2'000 PLN", "5'000 PLN", "10'000 PLN", "50'000 PLN"};
  JComboBox moneyComboBox = new JComboBox(money);

  JButton submitButton = new JButton();

  private Connection _connection = null;
  private Session _session = null;
  private String _user = "";
  private Vector selectedDeps = new Vector();

  //Construct the frame
  public MainFrame()
  {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try 
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception 
  {
    this.getContentPane().setLayout(borderLayout1);
    this.setSize(new Dimension(800, 600));
    this.setTitle("Report Generator");
    menuFile.setText("File");
    menuExit.setText("Exit");
    menuExit.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        exit_actionPerformed(e);
      }
    });
    menuConnect.setText("Connect");
    menuConnect.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        menuConnect_actionPerformed(e);
      }
    });
    menuDisconnect.setText("Disconnect");
    menuDisconnect.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        menuDisconnect_actionPerformed(e);
      }
    });
    menuOptions.setText("Options");
    menuForce.setText("Force server to reload departaments");
    menuForce.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        menuForce_actionPerformed(e);
      }
    });
    leftPanel.setMinimumSize(new Dimension(100, 100));
    leftPanel.setPreferredSize(new Dimension(100, 100));
    leftPanel.setLayout(borderLayout2);
    rigthPanel.setMinimumSize(new Dimension(100, 100));
    rigthPanel.setPreferredSize(new Dimension(200, 200));
    rigthPanel.setLayout(borderLayout3);
    splitPane.setDividerSize(2);
    treeScrollPane.setPreferredSize(new Dimension(200, 200));
    topPanel.setMinimumSize(new Dimension(110, 110));
    topPanel.setPreferredSize(new Dimension(110, 110));
    topPanel.setLayout(null);
    report.setContentType("text/html");
    report.setText("");
    wholePeriodRadioButton.setSelected(true);
    wholePeriodRadioButton.setText("Whole period");
    wholePeriodRadioButton.setBounds(new Rectangle(9, 10, 167, 18));
    wholePeriodRadioButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        wholePeriodRadioButton_actionPerformed(e);
      }
    });
    selectPeriodRadioButton.setText("Select period of time");
    selectPeriodRadioButton.setBounds(new Rectangle(9, 37, 167, 18));
    selectPeriodRadioButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        selectPeriodRadioButton_actionPerformed(e);
      }
    });
    periodComboBox.setBorder(BorderFactory.createLoweredBevelBorder());
    periodComboBox.setBounds(new Rectangle(32, 66, 203, 26));
    periodComboBox.setSelectedIndex(1);
    periodComboBox.setEnabled(false);
    anyAmountRadioButton.setSelected(true);
    anyAmountRadioButton.setText("Any amount of money");
    anyAmountRadioButton.setBounds(new Rectangle(277, 10, 167, 18));
    anyAmountRadioButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        anyAmountRadioButton_actionPerformed(e);
      }
    });
    selectAmountRadioButton.setText("Select amount of money");
    selectAmountRadioButton.setBounds(new Rectangle(277, 37, 167, 18));
    selectAmountRadioButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        selectAmountRadioButton_actionPerformed(e);
      }
    });
    moneyComboBox.setBorder(BorderFactory.createLoweredBevelBorder());
    moneyComboBox.setBounds(new Rectangle(300, 66, 203, 26));
    moneyComboBox.setSelectedIndex(0);
    moneyComboBox.setEnabled(false);
    submitButton.setMinimumSize(new Dimension(25, 25));
    submitButton.setPreferredSize(new Dimension(25, 25));
    submitButton.setText("Submit Report");
    submitButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        submitButton_actionPerformed(e);
      }
    });
    menuDisconnect.setEnabled(false);
    list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    tree.setShowsRootHandles(true);
    tree.addItemListener(new ItemListener()
    {
      public void itemStateChanged(ItemEvent e)
      {
        tree_itemStateChanged(e);
      }
    });

    menuBar.add(menuFile);
    menuBar.add(menuOptions);
    menuFile.add(menuConnect);
    menuFile.add(menuDisconnect);
    menuFile.addSeparator();
    menuFile.add(menuExit);
    menuOptions.add(menuForce);
    this.getContentPane().add(splitPane, BorderLayout.CENTER);
    splitPane.add(leftPanel, JSplitPane.LEFT);
    leftPanel.add(treeScrollPane, BorderLayout.SOUTH);
    treeScrollPane.getViewport().add(tree, null);
    leftPanel.add(listScrollPane, BorderLayout.CENTER);
    listScrollPane.getViewport().add(list, null);
    splitPane.add(rigthPanel, JSplitPane.RIGHT);
    rigthPanel.add(topPanel, BorderLayout.NORTH);
    topPanel.add(wholePeriodRadioButton, null);
    topPanel.add(selectPeriodRadioButton, null);
    topPanel.add(periodComboBox, null);
    topPanel.add(anyAmountRadioButton, null);
    topPanel.add(selectAmountRadioButton, null);
    topPanel.add(moneyComboBox, null);
    rigthPanel.add(reportScrollPane, BorderLayout.CENTER);
    rigthPanel.add(submitButton, BorderLayout.SOUTH);
    reportScrollPane.getViewport().add(report, null);
    this.setJMenuBar(menuBar);
    splitPane.setDividerLocation(200);
  }

  //File | Exit action performed
  public void exit_actionPerformed(ActionEvent e)
  {
    try
    {
      _connection.disconnect(_user);
    }
    catch(Exception ee)
    {
      System.out.println(ee.getMessage());
    }

    System.exit(0);
  }

  //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if(e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      exit_actionPerformed(null);
    }
  }

  void wholePeriodRadioButton_actionPerformed(ActionEvent e)
  {
    periodComboBox.setEnabled(false);
    selectPeriodRadioButton.setSelected(false);
    wholePeriodRadioButton.setSelected(true);
  }

  void selectPeriodRadioButton_actionPerformed(ActionEvent e)
  {
    periodComboBox.setEnabled(true);
    selectPeriodRadioButton.setSelected(true);
    wholePeriodRadioButton.setSelected(false);
  }

  void anyAmountRadioButton_actionPerformed(ActionEvent e)
  {
    moneyComboBox.setEnabled(false);
    selectAmountRadioButton.setSelected(false);
    anyAmountRadioButton.setSelected(true);
  }

  void selectAmountRadioButton_actionPerformed(ActionEvent e)
  {
    moneyComboBox.setEnabled(true);
    selectAmountRadioButton.setSelected(true);
    anyAmountRadioButton.setSelected(false);
  }

  void menuConnect_actionPerformed(ActionEvent e)
  {
    try
    {
      _user = "MG";

      _connection = (Connection)Naming.lookup("Przyklad4_connection");
      _session = _connection.connect(_user, "mg");

      //load departaments

      loadDepartaments(_session.getAllDepartaments());
      menuConnect.setEnabled(false);
      menuDisconnect.setEnabled(true);
    }
    catch(Exception ee)
    {
      _connection = null;
      _session = null;

      System.out.println(ee.getMessage());
    }
  }

  void menuDisconnect_actionPerformed(ActionEvent e)
  {
    try
    {
      _connection.disconnect(_user);   
                                        
      report.setText("");
      listModel.removeAllElements();
      unloadDepartament();
      menuConnect.setEnabled(true);
      menuDisconnect.setEnabled(false);
    }
    catch(Exception ee)
    {          
      System.out.println(ee.getMessage());
    }
    finally
    {      
      _connection = null;
      _session = null;
    }
  }

  protected void loadDepartaments(Departament[] departament)
  {
    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();

    for(int i=0; i<departament.length; i++)
    {
      DefaultMutableTreeNode node = new DefaultMutableTreeNode(departament[i]);
      model.insertNodeInto(node, root, i);
    }
    
    ((DefaultTreeModel)tree.getModel()).reload();
  }

  protected void unloadDepartament()
  {
    root.removeAllChildren();
    ((DefaultTreeModel)tree.getModel()).reload();
  }

  void menuForce_actionPerformed(ActionEvent e)
  {
    if(null != _session)
    {
      try
      {
        this.report.setText("");
        this.listModel.removeAllElements();
        this.unloadDepartament();
        this.loadDepartaments(_session.getAllDepartaments());
      }
      catch(RemoteException ee)
      {
        System.out.println(ee.getMessage());
      }
    }
  }

  void tree_itemStateChanged(ItemEvent e)
  {
    setCursor(Cursor.WAIT_CURSOR);

    Departament departament = (Departament)e.getItem();
    if(null != departament)
    {
      if(1 == e.getStateChange()) //departament added
      {
        try
        {
          Employee[] employees = _session.getEmployees(departament.id);

          for(int i=0; i<employees.length; i++)
          {
            int j = 0;
            for(j=0; j<listModel.getSize(); j++)
            {
              Employee employee = (Employee)listModel.elementAt(j);

              if(employees[i].lastName.compareTo(employee.lastName) < 0)
              {
                break;
              }
            }

            listModel.insertElementAt(employees[i], j);
          }
        }
        catch(RemoteException ee)
        {
          System.out.println(ee.getMessage());
        }
      }
      else //0 == e.getStateChange() - departament removed
      {
        //departament was removed
        for(int i=listModel.getSize(); 0<i; i--)
        {
          Employee employee = (Employee)listModel.elementAt(i-1);
          if(employee.depId == departament.id)
          {
            listModel.removeElementAt(i-1);
          }
        }
      }
    }

    setCursor(Cursor.DEFAULT_CURSOR);
  }

  void submitButton_actionPerformed(ActionEvent e)
  {                   
    report.setText("");
    
    if(null == _session)
    {
      return;
    }
    if(list.getSelectedIndex() < 0 || listModel.getSize() <= list.getSelectedIndex())
    {
      return;
    }
    
    if(selectPeriodRadioButton.isSelected())
    {
      if(selectAmountRadioButton.isSelected())
      {
        //report by amount and time 
        try
        {
          Employee employee = (Employee) listModel.getElementAt(list.getSelectedIndex());

          String value = (String) periodComboBox.getSelectedItem();
          java.sql.Date period = getDate(value);

          value = (String) moneyComboBox.getSelectedItem();
          double money = getMoney(value);

          String text = _session.getReport(employee.id, money, period);

          report.setText(text);
        }
        catch(RemoteException ee)
        {
          System.out.println(ee.getMessage());
        }
      }
      else
      {
        //report by time only
        try
        {
          Employee employee = (Employee) listModel.getElementAt(list.getSelectedIndex());
          String value = (String) periodComboBox.getSelectedItem();
          java.sql.Date period = getDate(value);

          String text = _session.getReport(employee.id, period);

          report.setText(text);
        }
        catch(RemoteException ee)
        {
          System.out.println(ee.getMessage());
        }
      }
    }
    else
    {  
      if(selectAmountRadioButton.isSelected())
      {
        //report by amount only 
        try
        {
          Employee employee = (Employee) listModel.getElementAt(list.getSelectedIndex());
          String value = (String) moneyComboBox.getSelectedItem();
          double money = getMoney(value);

          String text = _session.getReport(employee.id, money);

          report.setText(text);
        }
        catch(RemoteException ee)
        {
          System.out.println(ee.getMessage());
        }
      }
      else
      {
        //the simplest report
        try
        {
          Employee employee = (Employee) listModel.getElementAt(list.getSelectedIndex());
          String text = _session.getReport(employee.id);

          report.setText(text);
        }
        catch(RemoteException ee)
        {
          System.out.println(ee.getMessage());
        }
      }
    }
  }

  double getMoney(String money)
  {
    StringBuffer buffer = new StringBuffer("");

    for(int i=0; i<money.length(); i++)
    {
      char ch = money.charAt(i);
      if(48 <= ch && ch <= 57)
      {
        buffer.append(ch);
      }
    }

    try
    {
      return Double.parseDouble(buffer.toString());
    }
    catch(Exception e)
    {
      System.out.println(e.getMessage());
      return 0.0;
    }
  }

  java.sql.Date getDate(String date)
  {
    GregorianCalendar calendar = new GregorianCalendar();
    date = date.trim();

    if(date.equals("1 day"))
    {
      calendar.roll(Calendar.DAY_OF_YEAR, -1);
    }
    else if(date.equals("2 days"))
    {
      calendar.roll(Calendar.DAY_OF_YEAR, -2);
    }
    else if(date.equals("1 week"))
    {
      calendar.roll(Calendar.DAY_OF_MONTH, -7);
    }
    else if(date.equals("1 mnoth"))
    {
      calendar.roll(Calendar.MONTH, -1);
    }
    else if(date.equals("2 months"))
    {
      calendar.roll(Calendar.MONTH, -2);
    }
    else if(date.equals("6 months"))
    {
      calendar.roll(Calendar.MONTH, -6);
    }
    else if(date.equals("1 year"))
    {
      calendar.roll(Calendar.YEAR, -1);
    }

    java.sql.Date day = new java.sql.Date(calendar.getTime().getTime());
    return day;
  }
}