package db.przyklad4.client;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;

import db.przyklad4.objects.*;

public class CheckboxTree extends JTree implements TreeCellRenderer,
                                               TreeSelectionListener,
                                               ItemSelectable
{           
  private EventListenerList listenerList = new EventListenerList();
  private Vector selectedNodes = new Vector();

  public CheckboxTree(TreeModel treeModel)
  {
    super(treeModel);

    getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    setCellRenderer(this);
    addTreeSelectionListener(this);
    setAutoscrolls(true);
  }

  public Component getTreeCellRendererComponent(JTree tree, Object value,
                                        boolean selected, boolean expanded,
                                        boolean leaf, int row,boolean hasFocus)
  {
    String name = value.toString();
    DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;

    if(!name.equals("All Departaments"))
    {
      Departament departament = (Departament) node.getUserObject();
      
      JCheckBox renderer = new JCheckBox( value.toString() );
      renderer.setBackground(getParent().getComponent(0).getBackground());

      if(selectedNodes.contains(departament))
      {
        renderer.setSelected(true);
      }
      else
      {
        renderer.setSelected(false);
      }

      return renderer;
    }
    else
    {
      JLabel renderer = new JLabel(name);  
      renderer.setBackground(getParent().getComponent(0).getBackground());

      return renderer;
    }
  }
  
  public void valueChanged( TreeSelectionEvent e )
  {
    Departament departament = null;
    int stateChange = 0;

    TreePath path = e.getPath();
    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent( path.getPathCount() - 1 );

    String nodeName = node.toString();

    if(nodeName.equals("All Departaments"))
    {
      //do nothing
    }
    else
    {                               
      departament = (Departament) node.getUserObject();
      
      if(selectedNodes.contains(departament))
      {
        selectedNodes.removeElement(departament);
        stateChange = 0;
      }
      else
      {
        selectedNodes.addElement(departament);
        stateChange = 1;
      }
    }

    removeTreeSelectionListener( this );
    super.clearSelection();

    for( int i = 0; i < listenerList.getListenerCount(); i++ )
    {
      ItemEvent event = new ItemEvent(this, 1, departament, stateChange);
      try
      {
        ((ItemListener)(listenerList.getListenerList()[i+1])).itemStateChanged( event );
      }
      catch(ClassCastException ee)
      {
        //do nothing
      }
    }

    addTreeSelectionListener( this );

    repaint();
  }

  public Object[] getSelectedObjects()
  {
    Departament[] result = new Departament[selectedNodes.size()];
    selectedNodes.copyInto(result);
    return result;
  }

  public void addItemListener( ItemListener l )
  {
    listenerList.add( ItemListener.class, l );
  }

  public void removeItemListener( ItemListener l )
  {
    listenerList.remove( ItemListener.class, l );
  }
}