package db.przyklad3;

import java.sql.*;
import java.util.*;


public class SQLProcessor
{
  protected Connection _connection = null;
  protected String _dbUrl = null;
  private String STRING_NULL = "NULL";
  private char STRING_EMPTY = ' ';
  private String STRING_NEW_LINE = "\n";

  public SQLProcessor(String drivers, String dbUrl)
  {
    _dbUrl = dbUrl;

    Properties properties = System.getProperties();
    properties.put("jdbc.drivers", "sun.jdbc.odbc.JdbcOdbcDriver:interbase.interclient.Driver");

    if(null != drivers)
    {
      String str = (String) properties.get("jdbc.drivers");
      properties.put("jdbc.drivers", str + ":" + drivers);
    }
  }

  public SQLProcessor(String dbUrl)
  {    
    this(null, dbUrl);
  }

  public boolean openConnection(String user, String password)
  {
    try
    {
      _connection = DriverManager.getConnection(_dbUrl, user, password);
    }
    catch(Exception e)
    {
      System.out.println(e.getMessage());

      _connection =  null;
      return false;
    }

    return true;
  }

  public void closeConnection()
  {
    if(null != _connection)
    {
      try
      {
        _connection.close();
      }
      catch(SQLException e)
      {
        System.out.println(e.getMessage());
      }
      finally
      {
        _connection = null;
      }
    }
  }

  public void setAutoCommit(boolean autocommit)
  {
    try
    {
      if(null != _connection)
      {
        _connection.setAutoCommit(autocommit);
      }
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
    }
  }

  public boolean commit()
  {
    if(null == _connection)
      return false;

    try
    {
      _connection.commit();
      return true;
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return false;
    }
  }

  public boolean rollback()
  {
    if(null == _connection)
      return false;

    try
    {
      _connection.rollback();
      return true;
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return false;
    }
  }

  public String executeSQL(String sql)
  {
    String response = "";

    if(null == _connection)
      return response;
    if(null == sql || 0 == sql.length())
      return response;

    try
    {
      Statement statement = _connection.createStatement();

      boolean result = statement.execute(sql);
      response = createOutputText(result, statement);
    }
    catch(SQLException e)
    {
      response = sql + "\nError code: " + Integer.toString(e.getErrorCode()) +
                       STRING_NEW_LINE + e.getMessage() + "\n\n";
    }

    return response;
  }

  String createOutputText(boolean result, Statement statement) throws SQLException
  {
    String outputText = "";

    if(!result)
    {
      int count = statement.getUpdateCount();
      if(0 <= count)
        outputText = String.valueOf(count) + " record(s) was added or modified\n";
    }
    else
    {
      ResultSet resultSet = null;
      int[] columnSizes = null;
      String[] columnNames = null;

      do
      {
        Vector rekords = new Vector(10,10);
        resultSet = statement.getResultSet();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();

        if(null != columnNames)
        {
          if(columnNames.length != columnCount)
          {
            columnNames = null;
            columnSizes = null;

            outputText += "\n\tNext table\n";
          }
        }
        if(null == columnNames)
        {
          columnNames = new String[columnCount];
          columnSizes = new int[columnCount];
        }
        for(int i=0; i<columnCount; i++)
        {
          columnNames[i] = metaData.getColumnLabel(i+1);
          columnSizes[i] = columnNames[i].length();
        }

        while(resultSet.next())
        {
          String[] row = new String[columnCount];

          for(int j=0; j<columnCount; j++)
          {
            row[j] = resultSet.getString(j+1);
            if(resultSet.wasNull())
            {
              row[j] = STRING_NULL;
              columnSizes[j] = (columnSizes[j] < STRING_NULL.length()) ? STRING_NULL.length() : columnSizes[j];
            }
            else
            {
              columnSizes[j] = (columnSizes[j] < row[j].length()) ? row[j].length() : columnSizes[j];
            }
          }

          rekords.addElement(row);
        }

        outputText += addDataToOutputText(rekords, columnNames, columnSizes);
      }
      while(statement.getMoreResults());
    }

    return outputText + STRING_NEW_LINE;
  }

  private String addDataToOutputText(Vector rekords, String[] columnNames, int[] columnSizes)
  {
    StringBuffer buffer = new StringBuffer("");
    int suma = 0;

    rekords.trimToSize();

    for(int i=0; i<columnNames.length; i++)
    {
      buffer.append(columnNames[i]);
      buffer.append( emptyString((columnSizes[i] - columnNames[i].length()) + 1) );
      suma += (columnSizes[i] + 1);
    }

    buffer.append(STRING_NEW_LINE);
    buffer.append(emptyString('-', suma + 1));
    buffer.append(STRING_NEW_LINE);

    for(int i=0; i<rekords.size(); i++)
    {
      String[] row = (String[]) rekords.elementAt(i);

      for(int j=0; j<columnNames.length; j++)
      {
        buffer.append(row[j]);
        buffer.append( emptyString((columnSizes[j] - row[j].length()) + 1) );
      }
      buffer.append(STRING_NEW_LINE);
    }

    return buffer.toString();
  }

  private String emptyString(char ch, int length)
  {
    StringBuffer buffer = new StringBuffer("");

    for(int i=0; i<length; i++)
    {
      buffer.append(ch);
    }

    return buffer.toString();
  }  

  private String emptyString(int length)
  {
    return emptyString(STRING_EMPTY, length);
  }
} 