package db.przyklad2;

import java.sql.*;
import java.util.*;

public class DbProcessor2
{
  protected Connection _connection = null;
  protected String _driver = null;
  protected String _dbUrl = null;

  public DbProcessor2(String driver, String dbUrl)
  {
    this._driver = driver;
    this._dbUrl = dbUrl;
  }

  public boolean openConnection(String user, String password)
  {
    try
    {
      Class.forName(_driver);
      _connection = DriverManager.getConnection(_dbUrl, user, password);
      
      _connection.setAutoCommit(false);
    }
    catch(Exception e)
    {                      
      System.out.println(e.getMessage());
      
      _connection =  null;
      return false;
    }

    return true;
  }

  public void closeConnection()
  {
    if(null != _connection)
    {
      try
      {
        _connection.close();
      }
      catch(SQLException e)
      {
        System.out.println(e.getMessage());
      }
      finally
      {    
        _connection = null;
      }
    }
  }

  public boolean addNewFriend(String lastName, String firstName, java.sql.Date birthDate, char sex)
  {
    try
    {      
      CallableStatement cstm = _connection.prepareCall("{call add_new_friend(?,?,?,?)}");
      cstm.setString(1, lastName);
      cstm.setString(2, firstName);
      cstm.setDate(3, birthDate);
      cstm.setString(4, String.valueOf(sex));

      cstm.executeUpdate();
      _connection.commit();
    }
    catch(SQLException e)
    {
      try
      {
        _connection.rollback();
        return false;
      }
      catch(SQLException ee)
      {
        System.out.println(ee.getMessage());
        System.exit(1);
      }
    }

    return true;
  }

  public FriendInfo[] getFriends()
  {
    String sql = "SELECT friend_id, lastname, firstname FROM friends2_tab ORDER BY lastname;";
    Vector friends = new Vector(0, 1);
    FriendInfo[] info = null;
    
    try
    {
      Statement statement = _connection.createStatement(/*java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
                                                        java.sql.ResultSet.CONCUR_READ_ONLY*/);

      ResultSet resultSet = statement.executeQuery(sql);
      //resultSet.beforeFirst();

      while(resultSet.next())
      {
        FriendInfo friendInfo = new FriendInfo(resultSet.getInt(1),
                                               resultSet.getString(2),
                                               resultSet.getString(3));

        friends.addElement(friendInfo);
      }

      info = new FriendInfo[friends.size()];
      friends.copyInto(info);

      return info;
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return null;
    }
  }

  public java.sql.Date getFriendDate(int friendId)
  {
    String sql = "SELECT birthdate FROM friends2_tab WHERE friend_id = ?;";
    
    try
    {
      PreparedStatement pstm = _connection.prepareStatement(sql/*,
                                                            java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
                                                            java.sql.ResultSet.CONCUR_READ_ONLY*/);
      pstm.setInt(1, friendId);
      
      ResultSet resultSet = pstm.executeQuery();
      if(resultSet.next()/*resultSet.first(); */)
      {
        return resultSet.getDate(1);
      }
      else
      {
        return null;
      }

    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return null;
    }
  }

  public String getFriendDescription(int friendId)
  {
    String sql = "SELECT description FROM friends2_tab WHERE friend_id = ?;";
    
    try
    {
      //CallableStatement cstm = _connection.prepareCall("{? = call get_description_by_id(?)}");
      //cstm.registerOutParameter(1, Types.VARCHAR);                       
      //cstm.setInt(2, friendId);

      //cstm.execute();

      //return cstm.getString(1);

      PreparedStatement pstm = _connection.prepareStatement(sql);
      pstm.setInt(1, friendId);

      ResultSet resultSet = pstm.executeQuery();
      if(resultSet.next())
      {
        return resultSet.getString(1);
      }
      else
      {
        return null;
      }
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return null;
    }
  }

  public boolean setFriendDescription(int friendId, String description)
  {
    try
    {
      CallableStatement cstm = _connection.prepareCall("{call add_description_by_id(?,?)}");
      cstm.setInt(1, friendId);
      cstm.setString(2, description);

      cstm.executeUpdate();
      _connection.commit();
    }
    catch(Exception e)
    {  
      try
      {
        _connection.rollback();
        return false;
      }
      catch(SQLException ee)
      {
        System.out.println(ee.getMessage());
        System.exit(1);
      }
    }

    return true;
  }

  public boolean addNewAddress(int friendId, String city, String street, String phone)
  {
    try
    {
      CallableStatement cstm = _connection.prepareCall("{call add_new_address(?,?,?,?)}");
      cstm.setInt(1, friendId);
      cstm.setString(2, city);
      cstm.setString(3, street);
      cstm.setString(4, phone);

      cstm.executeUpdate();
      _connection.commit();
    }
    catch(SQLException e)
    {       
      try
      {
        _connection.rollback();
        return false;
      }
      catch(SQLException ee)
      {
        System.out.println(ee.getMessage());
        System.exit(1);
      }
    }

    return true;
  }

  public AddressInfo[] getFriendAddresses(int friendId)
  {
    String sql = "SELECT address_id, city, street, phone " +
                 "FROM address_tab WHERE friend_id = ? ORDER BY city;";
    Vector addresses = new Vector(0, 1);
    AddressInfo[] info = null;
    
    try
    {
      PreparedStatement pstm = _connection.prepareStatement(sql/*,
                                                            java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
                                                            java.sql.ResultSet.CONCUR_READ_ONLY*/);
      pstm.setInt(1, friendId);

      ResultSet resultSet = pstm.executeQuery();
      //resultSet.beforeFirst();

      while(resultSet.next())
      {
        AddressInfo addressInfo = new AddressInfo(resultSet.getInt(1),
                                                  resultSet.getString(2),
                                                  resultSet.getString(3),
                                                  resultSet.getString(4));

        addresses.addElement(addressInfo);
      }

      info = new AddressInfo[addresses.size()];
      addresses.copyInto(info);

      return info;
    }
    catch(SQLException e)
    {    
      System.out.println(e.getMessage());
      return null;
    }
  }   

}