package db.przyklad2;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;

public class DbFrame extends JFrame
{
  DbProcessor2 dbProcessor = null;
  
  JTabbedPane tabbedPane = new JTabbedPane();
  JPanel viewPanel = new JPanel();
  JPanel addPanel = new JPanel();
  JComboBox allFriendsCombo1 = new JComboBox();
  JLabel birthDateLabel = new JLabel();
  JTextArea descriptionArea = new JTextArea();
  JScrollPane scrollPane = new JScrollPane();
  JList addressesList = new JList();
  JToggleButton offOn = new JToggleButton();
  BorderLayout borderLayout = new BorderLayout();
  JPanel addFriendPanel = new JPanel();
  TitledBorder userTitledBorder;
  JPanel addAddressPanel = new JPanel();
  TitledBorder addressTitledBorder;
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JTextField lastName = new JTextField();
  JTextField firstName = new JTextField();
  JTextField birthDate = new JTextField();
  JTextField sex = new JTextField();
  JButton addFriendButton = new JButton();
  JComboBox allFriendsCombo2 = new JComboBox();
  JButton addDescriptionButton = new JButton();
  JTabbedPane tabbedPane2 = new JTabbedPane();
  JPanel descriptionPanel = new JPanel();
  JPanel addAddress = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  JScrollPane scrollPane2 = new JScrollPane();
  JTextArea description = new JTextArea();
  JLabel jLabel5 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();
  JTextField city = new JTextField();
  JTextField street = new JTextField();
  JTextField phone = new JTextField();

  public DbFrame()
  {
    try 
    {
      jbInit();
      
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      SwingUtilities.updateComponentTreeUI(this);
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  public static void main(String[] args)
  {
    DbFrame frame = new DbFrame();
    frame.setVisible(true);
  }

  public void setVisible(boolean visible)
  {
    super.setVisible(visible);
    if(!visible)
    {
      dbProcessor.closeConnection();
      System.exit(0);
    }
  }

  private void jbInit() throws Exception
  {
    dbProcessor = new DbProcessor2("interbase.interclient.Driver",
                                   "jdbc:interbase://pc90/C:/Documents and Settings/mg/My Documents/Databases/friends.gdb");

    userTitledBorder = new TitledBorder("add a friend");
    addressTitledBorder = new TitledBorder("add an address");
    this.setResizable(false);
    this.setTitle("Db Przyklad 2");
    this.setSize(500, 330);
    tabbedPane.setTabPlacement(JTabbedPane.BOTTOM);
    tabbedPane.setRequestFocusEnabled(fals//e);
    viewPanel.setMinimumSize(new Dimension(100, 100));
    viewPanel.setPreferredSize(new Dimension(100, 100));
    viewPanel.setLayout(null);
    allFriendsCombo1.setBorder(BorderFactory.createLoweredBevelBorder());
    allFriendsCombo1.setBounds(new Rectangle(22, 22, 184, 25));
    allFriendsCombo1.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        allFriendsCombo1_actionPerformed(e);
      }
    });
    birthDateLabel.setBorder(BorderFactory.createEtchedBorder());
    birthDateLabel.setHorizontalAlignment(SwingConstants.CENTER);
    birthDateLabel.setBounds(new Rectangle(222, 22, 128, 25));
    descriptionArea.setLineWrap(true);
    descriptionArea.setWrapStyleWord(true);
    descriptionArea.setBorder(BorderFactory.createLoweredBevelBorder());
    descriptionArea.setEditable(false);
    descriptionArea.setBounds(new Rectangle(22, 67, 445, 78));
    scrollPane.setBorder(null);
    scrollPane.setBounds(new Rectangle(22, 168, 445, 78));
    addressesList.setBorder(BorderFactory.createLoweredBevelBorder());
    offOn.setText("off");
    offOn.setRequestFocusEnabled(false);
    offOn.setBounds(new Rectangle(415, 22, 50, 25));
    offOn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        offOn_actionPerformed(e);
      }
    });
    jLabel1.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel1.setText("Nazwisko");
    jLabel1.setBounds(new Rectangle(20, 20, 113, 22));
    jLabel2.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel2.setText("Imie");
    jLabel2.setBounds(new Rectangle(20, 46, 113, 22));
    jLabel3.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel3.setText("Data urodzenia");
    jLabel3.setBounds(new Rectangle(20, 72, 113, 22));
    jLabel4.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel4.setText("Plec");
    jLabel4.setBounds(new Rectangle(20, 96, 113, 22));
    lastName.setBounds(new Rectangle(150, 20, 211, 22));
    firstName.setBounds(new Rectangle(150, 46, 111, 22));
    birthDate.setText("yyyy-mm-rr");
    birthDate.setBounds(new Rectangle(150, 72, 71, 22));
    sex.setText("?");
    sex.setBounds(new Rectangle(150, 96, 25, 22));
    addFriendButton.setText("Dodaj");
    addFriendButton.setBounds(new Rectangle(371, 71, 90, 29));
    addFriendButton.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        addFriendButton_actionPerformed(e);
      }
    });
    allFriendsCombo2.setBounds(new Rectangle(278, 32, 184, 25));
    allFriendsCombo2.setBorder(BorderFactory.createLoweredBevelBorder());
    addDescriptionButton.setBounds(new Rectangle(371, 81, 90, 29));
    addDescriptionButton.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        addDescriptionButton_actionPerformed(e);
      }
    });
    addDescriptionButton.setText("Dodaj");
    tabbedPane2.setBounds(new Rectangle(7, 18, 269, 115));
    descriptionPanel.setLayout(borderLayout1);
    addAddress.setLayout(null);
    description.setLineWrap(true);
    description.setWrapStyleWord(true);
    jLabel5.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel5.setText("Miasto");
    jLabel5.setBounds(new Rectangle(4, 8, 85, 22));
    jLabel6.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel6.setText("Ulica");
    jLabel6.setBounds(new Rectangle(4, 30, 85, 22));
    jLabel7.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel7.setText("Telefon");
    jLabel7.setBounds(new Rectangle(4, 54, 85, 22));
    city.setBounds(new Rectangle(112, 8, 147, 22));
    street.setBounds(new Rectangle(112, 30, 147, 22));
    phone.setBounds(new Rectangle(112, 54, 147, 22));
    this.getContentPane().add(tabbedPane, BorderLayout.CENTER);
    tabbedPane.add(viewPanel, "View      ");
    viewPanel.add(allFriendsCombo1, null);
    viewPanel.add(birthDateLabel, null);
    viewPanel.add(descriptionArea, null);
    viewPanel.add(scrollPane, null);
    scrollPane.getViewport().add(addressesList, null);
    viewPanel.add(offOn, null);
    //tabbedPane.add(addPanel, "Add      ");
    addPanel.setLayout(borderLayout);
    addPanel.add(addFriendPanel, BorderLayout.NORTH);
    addFriendPanel.setBorder(userTitledBorder);
    addFriendPanel.setPreferredSize(new Dimension(10, 130));
    addFriendPanel.setLayout(null);
    addFriendPanel.add(jLabel1, null);
    addFriendPanel.add(jLabel2, null);
    addFriendPanel.add(jLabel3, null);
    addFriendPanel.add(jLabel4, null);
    addFriendPanel.add(lastName, null);
    addFriendPanel.add(firstName, null);
    addFriendPanel.add(birthDate, null);
    addFriendPanel.add(sex, null);
    addFriendPanel.add(addFriendButton, null);
    addPanel.add(addAddressPanel, BorderLayout.CENTER);
    addAddressPanel.add(allFriendsCombo2, null);
    addAddressPanel.add(addDescriptionButton, null);
    addAddressPanel.add(tabbedPane2, null);
    tabbedPane2.add(descriptionPanel, "Opis   ");
    descriptionPanel.add(scrollPane2, BorderLayout.CENTER);
    scrollPane2.getViewport().add(description, null);
    tabbedPane2.add(addAddress, "Adres");
    addAddress.add(jLabel5, null);
    addAddress.add(jLabel6, null);
    addAddress.add(jLabel7, null);
    addAddress.add(city, null);
    addAddress.add(street, null);
    addAddress.add(phone, null);
    addPanel.setLayout(borderLayout);
    addAddressPanel.setBorder(addressTitledBorder);
    addAddressPanel.setLayout(null);
    disableComponents(false);
  }

  void offOn_actionPerformed(ActionEvent e)
  {
    if(offOn.isSelected())
    {
      offOn.setText("?");
      offOn.paintImmediately(0, 0, 50, 25);
      
      if(dbProcessor.openConnection("mg", "michal"))
      {
        offOn.setText("On");
        disableComponents(true);
        tabbedPane.add(addPanel, "Add      ");   
        SwingUtilities.updateComponentTreeUI(this);

        FriendInfo[] friendInfo = dbProcessor.getFriends();
        for(int i=0; i<friendInfo.length; i++)
        {
          allFriendsCombo1.addItem(friendInfo[i]);
          allFriendsCombo2.addItem(friendInfo[i]);
        }
      }
      else
      {
        offOn.setText("Off");
        offOn.setSelected(false);
      }
    }
    else
    {
      offOn.setText("Off");
      disableComponents(false);

      tabbedPane.remove(addPanel);
      clearComponents();

      dbProcessor.closeConnection();
    }
  }

  void disableComponents(boolean disable)
  {
    this.allFriendsCombo1.setEnabled(disable);
    this.descriptionArea.setEnabled(disable);
    this.addressesList.setEnabled(disable);
  }

  void allFriendsCombo1_actionPerformed(ActionEvent e)
  {
    if(allFriendsCombo1.isEnabled())
    {
      FriendInfo friendInfo = (FriendInfo) allFriendsCombo1.getSelectedItem();
      if(null == friendInfo) return;
      
      java.sql.Date date = dbProcessor.getFriendDate(friendInfo.friendId);
      birthDateLabel.setText("");
      if(null != date) birthDateLabel.setText(date.toString());

      String text = dbProcessor.getFriendDescription(friendInfo.friendId);
      descriptionArea.setText("");
      if(null != text) descriptionArea.setText(text);
      descriptionArea.repaint();

      AddressInfo[] addressInfo = dbProcessor.getFriendAddresses(friendInfo.friendId);
      addressesList.removeAll();
      if(null != addressInfo) addressesList.setListData(addressInfo);
    }
  }

  void addFriendButton_actionPerformed(ActionEvent e)
  {
    String seks = 0 < sex.getText().length() ? sex.getText().toUpperCase() : "?";
    
    if(dbProcessor.addNewFriend(lastName.getText(),
                                firstName.getText(),
                                java.sql.Date.valueOf(birthDate.getText()),
                                seks.charAt(0)))
    {
      lastName.setText("");
      firstName.setText("");
      birthDate.setText("yyyy-mm-rr");
      sex.setText("?");

      refreshData();
    };
  }

  void addDescriptionButton_actionPerformed(ActionEvent e)
  {
    FriendInfo friendInfo = (FriendInfo) allFriendsCombo2.getSelectedItem();
    if(null == friendInfo) return;

    if(0 == tabbedPane2.getSelectedIndex())
    {
      String text = (249 < this.description.getText().length()) ?
                            this.description.getText().substring(0, 249) : this.description.getText();
                            
      dbProcessor.setFriendDescription(friendInfo.friendId, text);

      this.description.setText("");
    }
    else
    {
      dbProcessor.addNewAddress(friendInfo.friendId,
                                city.getText(),
                                street.getText(),
                                phone.getText());

      city.setText("");
      street.setText("");
      phone.setText("");
    }

    refreshData();
  }

  void refreshData()
  {
    allFriendsCombo1.removeAllItems();
    allFriendsCombo2.removeAllItems();

    FriendInfo[] friendInfo = dbProcessor.getFriends();
    for(int i=0; i<friendInfo.length; i++)
    {
      allFriendsCombo1.addItem(friendInfo[i]);
      allFriendsCombo2.addItem(friendInfo[i]);
    }
  }

  void clearComponents()
  {       
    allFriendsCombo1.removeAllItems();
    allFriendsCombo2.removeAllItems();
    birthDateLabel.setText("");
    descriptionArea.setText("");
    addressesList.removeAll();
  }
}