package db.przyklad1;

import java.sql.*;
import java.util.*;
//import interbase.interclient.*;

public class DbProcessor
{
  protected java.sql.Connection _connection = null;
  protected String _driver = null;
  protected String _dbUrl = null;
  protected java.sql.Statement _statement = null;

  public DbProcessor(String driver, String _dbUrl)
  {
    this._driver = driver;
    this._dbUrl = _dbUrl;
  }

  public boolean openConnection(String user, String password)
  {
    try
    {
      Class.forName(_driver);
      _connection = DriverManager.getConnection(_dbUrl, user, password);

      //_statement = _connection.createStatement(java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE,
      //                                         java.sql.ResultSet.CONCUR_READ_ONLY);
      _statement = _connection.createStatement();
    }
    catch(Exception e)
    {                      
      System.out.println(e.getMessage());
      
      _connection =  null;
      _statement = null;
      return false;
    }

    return true;
  }

  public void closeConnection()
  {
    if(null != _connection)
    {
      try
      {
        _connection.close();
      }
      catch(SQLException e)
      {
        System.out.println(e.getMessage());
      }
      finally
      {    
        _connection = null;
        _statement = null;
      }
    }
  }

  public ShortFriend[] getAllFriends()
  {
    try
    {
      java.sql.ResultSet resultSet =
        _statement.executeQuery("SELECT pesel, lastname, firstname FROM friends_tab ORDER BY lastname;");
       Vector vector = new Vector();

      //resultSet.beforeFirst();
      while(resultSet.next())
      {
        ShortFriend shortFriend = new ShortFriend(resultSet.getLong("pesel"),
                                                  resultSet.getString("lastname"),
                                                  resultSet.getString("firstname"));
        vector.addElement(shortFriend);
      }

      ShortFriend[] shortFriends = new ShortFriend[vector.size()];
      vector.toArray(shortFriends);
      return shortFriends;
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return null;
    }
  }

  public Friend getFriendByPrimaryKey(long pesel, String lastName)
  {
    String sql = "SELECT pesel, lastname, firstname, birthdate, description " +
                 "FROM friends_tab " +
                 "WHERE pesel = " + Long.toString(pesel) +
                 "AND lastname = '" + lastName + "';";
    try
    {
      java.sql.ResultSet resultSet = _statement.executeQuery(sql);
      if(resultSet.next()/*resultSet.first()*/)
      {
        return new Friend(resultSet.getLong("pesel"),
                          resultSet.getString("lastname"),
                          resultSet.getString("firstname"),
                          resultSet.getString("birthdate"),
                          resultSet.getString("description"));
      }
      else
      {
        return null;
      }
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return null;
    }
  }

  public boolean addFriend(Friend friend)
  {
    String sql = null;
    if((null != friend.description) && (0 < friend.description.length()))
    {
      if(100 < friend.description.length())
      {
        friend.description = friend.description.substring(0, 99);
      }
      
      sql = "INSERT " +
            "INTO friends_tab(pesel, lastname, firstname, birthdate, description) " +
            "VALUES('" + Long.toString(friend.pesel) +
            "', '" + friend.lastName +
            "', '" + friend.firstName +
            "', '" + friend.birthDate +
            "', '" + friend.description + "')";
    }
    else
    {
      sql = "INSERT " +
            "INTO friends_tab(pesel, lastname, firstname, birthdate) " +
            "VALUES('" + Long.toString(friend.pesel) +
            "', '" + friend.lastName +
            "', '" + friend.firstName +
            "', '" + friend.birthDate + "')";
    }
    try
    {
      int updateCount = _statement.executeUpdate(sql);
      return (1 == updateCount);
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return false;
    }
  }

  public boolean updateDescriptionByPrimaryKey(ShortFriend shortFriend, String description)
  {
    if(100 < description.length())
    {
      description = description.substring(0, 99);
    }

    String sql = "UPDATE friends_tab SET description = '" +  description + "' " +
                 "WHERE pesel = " + shortFriend.pesel +
                 " AND lastname = '" + shortFriend.lastName + "' ;";

    try
    {
      int updateCount = _statement.executeUpdate(sql);
      return (1 == updateCount);
    }
    catch(SQLException e)
    {
      System.out.println(e.getMessage());
      return false;
    }
  }
}