package db.przyklad1;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.sql.*;

public class DbDialog extends JDialog
{
  JPanel mainPanel = new JPanel();
  BorderLayout borderLayout = new BorderLayout();
  JPanel topPanel = new JPanel();
  JSplitPane splitPane = new JSplitPane();
  JScrollPane scrollPane = new JScrollPane();
  JPanel rightPanel = new JPanel();
  JList list = new JList();
  JLabel jLabel1 = new JLabel();
  JTextField pesel = new JTextField();
  JLabel jLabel2 = new JLabel();
  JTextField birthDate = new JTextField();              
  BorderLayout borderLayout1 = new BorderLayout();
  JTextArea description = new JTextArea();
  JPanel panel = new JPanel();
  JRadioButton listing = new JRadioButton();
  JRadioButton changeDesc = new JRadioButton();
  JRadioButton addNew = new JRadioButton();
  JButton save = new JButton();
  JLabel jLabel3 = new JLabel();
  JTextField firstName = new JTextField();
  JLabel jLabel4 = new JLabel();
  JTextField lastName = new JTextField();
  JButton add = new JButton();

  DbProcessor dbProcessor = null;

  public DbDialog(Frame frame, String title, boolean modal)
  {
    super(frame, title, modal);
    try
    {
      setSize(500, 350);
      setResizable(false);
      
      Dimension dialogSize = getSize();
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

      if (dialogSize.height > screenSize.height) dialogSize.height = screenSize.height;
      if (dialogSize.width > screenSize.width) dialogSize.width = screenSize.width;
      setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);

      jbInit();
                                    
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
      SwingUtilities.updateComponentTreeUI(this);
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  public DbDialog()
  {
    this(null, "", false);
  }

  void jbInit() throws Exception
  {
    dbProcessor = new DbProcessor("interbase.interclient.Driver",
                                  "jdbc:interbase://pc90/C:/Documents and Settings/mg/My Documents/Databases/friends.gdb");
    if(!dbProcessor.openConnection("mg", "michal"))
      System.exit(1);

    ShortFriend[] shortFriends = dbProcessor.getAllFriends();
    list.setListData(shortFriends);

    mainPanel.setPreferredSize(new Dimension(500, 350));
    mainPanel.setLayout(borderLayout);
    topPanel.setPreferredSize(new Dimension(10, 50));
    topPanel.setLayout(null);
    scrollPane.setMinimumSize(new Dimension(50, 24));
    scrollPane.setPreferredSize(new Dimension(150, 4));
    splitPane.setLastDividerLocation(100);
    jLabel1.setText("Pesel");
    jLabel1.setBounds(new Rectangle(15, 15, 40, 22));
    pesel.setEnabled(false);
    pesel.setBounds(new Rectangle(59, 15, 139, 22));
    jLabel2.setText("Birth Date");
    jLabel2.setBounds(new Rectangle(216, 15, 65, 22));
    birthDate.setEnabled(false);
    birthDate.setBounds(new Rectangle(288, 15, 129, 22));
    rightPanel.setLayout(borderLayout1);
    description.setLineWrap(true);
    description.setPreferredSize(new Dimension(70, 100));
    description.setWrapStyleWord(true);
    description.setBorder(BorderFactory.createEtchedBorder());
    description.setEnabled(false);
    description.setMinimumSize(new Dimension(70, 100));
    list.addMouseListener(new java.awt.event.MouseAdapter()
    {

      public void mouseClicked(MouseEvent e)
      {
        list_mouseClicked(e);
      }
    });
    panel.setLayout(null);
    listing.setSelected(true);
    listing.setText("listing only");
    listing.setBounds(new Rectangle(11, 16, 198, 26));
    listing.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        listing_actionPerformed(e);
      }
    });
    changeDesc.setText("change description");
    changeDesc.setBounds(new Rectangle(11, 50, 198, 26));
    changeDesc.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        changeDesc_actionPerformed(e);
      }
    });
    addNew.setText("add new friend");
    addNew.setBounds(new Rectangle(11, 84, 198, 26));
    addNew.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        addNew_actionPerformed(e);
      }
    });
    save.setEnabled(false);
    save.setText("Save");
    save.setBounds(new Rectangle(230, 49, 87, 26));
    save.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        save_actionPerformed(e);
      }
    });
    jLabel3.setText("First Name");
    jLabel3.setBounds(new Rectangle(28, 115, 85, 22));
    firstName.setEnabled(false);
    firstName.setBounds(new Rectangle(27, 137, 117, 22));
    jLabel4.setBounds(new Rectangle(167, 115, 85, 22));
    jLabel4.setText("Last Name");
    lastName.setEnabled(false);
    lastName.setBounds(new Rectangle(166, 137, 156, 22));
    add.setEnabled(false);
    add.setText("Add");
    add.setBounds(new Rectangle(230, 84, 87, 26));
    add.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        add_actionPerformed(e);
      }
    });
    getContentPane().add(mainPanel);
    mainPanel.add(topPanel, BorderLayout.NORTH);
    topPanel.add(jLabel1, null);
    topPanel.add(pesel, null);
    topPanel.add(jLabel2, null);
    topPanel.add(birthDate, null);
    mainPanel.add(splitPane, BorderLayout.CENTER);
    splitPane.add(scrollPane, JSplitPane.LEFT);
    scrollPane.getViewport().add(list, null);
    splitPane.add(rightPanel, JSplitPane.RIGHT);
    rightPanel.add(description, BorderLayout.NORTH);
    rightPanel.add(panel, BorderLayout.CENTER);
    panel.add(listing, null);
    panel.add(changeDesc, null);
    panel.add(addNew, null);
    panel.add(save, null);
    panel.add(jLabel3, null);
    panel.add(firstName, null);
    panel.add(jLabel4, null);
    panel.add(lastName, null);
    panel.add(add, null);
    splitPane.setDividerLocation(150);
  }

  public void setVisible(boolean visible)
  {
    super.setVisible(visible);

    if(!visible)
    {
      dbProcessor.closeConnection();
      System.exit(0);
    }
  }

  static public void main(String[] agrs)
  {
    DbDialog dialog = new DbDialog(null, "Db przyklad 1", false);
    dialog.setVisible(true);
  }

  void listing_actionPerformed(ActionEvent e)
  {
    if(listing.isSelected())
    {
      changeDesc.setSelected(false);
      addNew.setSelected(false);

      save.setEnabled(false);
      add.setEnabled(false);
      firstName.setEnabled(false);
      lastName.setEnabled(false);

      pesel.setEnabled(false);
      birthDate.setEnabled(false);  
      description.setEnabled(false);
    }
  }

  void changeDesc_actionPerformed(ActionEvent e)
  {
    if(changeDesc.isSelected())
    {
      listing.setSelected(false);
      addNew.setSelected(false);    

      save.setEnabled(true);    
      add.setEnabled(false);
      firstName.setEnabled(false);
      lastName.setEnabled(false);      

      pesel.setEnabled(false);
      birthDate.setEnabled(false);
      description.setEnabled(true);
    }
  }

  void addNew_actionPerformed(ActionEvent e)
  {
    if(addNew.isSelected())
    {
      changeDesc.setSelected(false);
      listing.setSelected(false);     

      save.setEnabled(false);       
      add.setEnabled(true);
      firstName.setEnabled(true);
      lastName.setEnabled(true);    

      pesel.setEnabled(true);
      birthDate.setEnabled(true);
      description.setEnabled(true);
    }
  }

  void list_mouseClicked(MouseEvent e)
  {
    ShortFriend shortFriend = (ShortFriend) list.getSelectedValue();
    pesel.setText(String.valueOf(shortFriend.pesel));

    Friend friend = dbProcessor.getFriendByPrimaryKey(shortFriend.pesel, shortFriend.lastName);
    birthDate.setText(friend.birthDate.toString());

    description.setText("");
    description.setText(friend.description);
    description.repaint();
  }

  void save_actionPerformed(ActionEvent e)
  {
    if((null != description.getText()) && (0 < description.getText().length()))
    {
      ShortFriend shortFriend = (ShortFriend) list.getSelectedValue();
      dbProcessor.updateDescriptionByPrimaryKey(shortFriend,
                                           description.getText());
    }
  }

  void add_actionPerformed(ActionEvent e)
  {
    String desc = description.getText();
    Friend friend = new Friend(Long.parseLong(pesel.getText()),
                               lastName.getText(),
                               firstName.getText(),
                               birthDate.getText(),
                               desc);

    if(dbProcessor.addFriend(friend))
    {
      ShortFriend[] shortFriends = dbProcessor.getAllFriends();
      list.setListData(shortFriends);
    }
  }
}
