package db.przyklad4;

import java.rmi.*;
import java.rmi.server.*;

import db.przyklad4.objects.*;
import db.przyklad4.server.processors.*;

public class SessionImpl extends UnicastRemoteObject implements Session
{
  protected SQLProcessor2 processor = null;

  public SessionImpl(String dbUrl) throws RemoteException
  {
    processor = new SQLProcessor2(dbUrl);
  }

  public boolean openDatabase(String user, String password)
  {
    return processor.openConnection(user, password);
  }

  public void closeDatabase()
  {
    processor.closeConnection();
  }

  public Departament[] getAllDepartaments() throws RemoteException
  {
    return processor.getObjectProcessor().getDepartaments();
  }

  public boolean setNewDepartament(String departament) throws RemoteException
  {
    return processor.getObjectProcessor().addDepartament(departament);
  }

  public boolean setDepartamentHead(int depId, int employeeId) throws RemoteException
  {
    return processor.getObjectProcessor().setDepartamentHead(depId, employeeId);
  }

  public Employee[] getEmployees(int depId) throws RemoteException
  {
    return processor.getObjectProcessor().getEmployeesForDepartament(depId);
  }

  public boolean setNewEmployee(int depId, String firstName, String lastName, double salary) throws RemoteException
  {
    return processor.getObjectProcessor().addEmployee(depId, firstName, lastName, salary);
  }

  public boolean setNewCustomer(long pesel, String firstName, String lastName, char sex) throws RemoteException
  {
    return processor.getObjectProcessor().addCustomer(pesel, firstName, lastName, sex);
  }

  public boolean setNewSale(long pesel, int employeeId, String description, double value) throws RemoteException
  {
    return processor.getObjectProcessor().addSale(pesel, employeeId, description, value);
  }

  public String getReport(int employeeId) throws RemoteException
  {
    StringBuffer buffer = new StringBuffer("<HTML><HEAD><TITLE> Sale Report </TITLE></HEAD><BODY>");
    buffer.append(processor.getReportProcessor().createReport(employeeId));
    buffer.append("</BODY></HTML>");

    return buffer.toString();
  }

  public String getReport(int employeeId, java.sql.Date period) throws RemoteException
  {
    StringBuffer buffer = new StringBuffer("<HTML><HEAD><TITLE> Sale Report </TITLE></HEAD><BODY>");
    buffer.append(processor.getReportProcessor().createReport(employeeId, period));
    buffer.append("</BODY></HTML>");

    return buffer.toString();
  }

  public String getReport(int employeeId, double money) throws RemoteException
  {       
    StringBuffer buffer = new StringBuffer("<HTML><HEAD><TITLE> Sale Report </TITLE></HEAD><BODY>");
    buffer.append(processor.getReportProcessor().createReport(employeeId, money));
    buffer.append("</BODY></HTML>");

    return buffer.toString();
  }

  public String getReport(int employeeId, double money, java.sql.Date period) throws RemoteException
  {    
    StringBuffer buffer = new StringBuffer("<HTML><HEAD><TITLE> Sale Report </TITLE></HEAD><BODY>");
    buffer.append(processor.getReportProcessor().createReport(employeeId, money, period));
    buffer.append("</BODY></HTML>");

    return buffer.toString();
  }
} 