package db.przyklad4;

import java.rmi.*;
import java.rmi.server.*;
import java.util.*;
import java.net.*;

import db.przyklad4.objects.*;
import db.przyklad4.server.processors.*;

public class ConnectionImpl extends UnicastRemoteObject implements Connection
{
  Properties properties = null;

  public ConnectionImpl() throws RemoteException
  {
    properties = new Properties();
  }

  public synchronized Session connect(String user, String password) throws RemoteException
  {
    if(properties.containsKey(user))
    {
      return (SessionImpl) properties.get(user);
    }
    else
    {
      SessionImpl session = new SessionImpl("jdbc:interbase://pc183a/C:/Program Files/InterBase Corp/InterBase/bin/data/work.gdb");

      if(session.openDatabase(user, password))
      {
        try
        {
          Naming.rebind("Przyklad4_" + user, session);
          properties.put(user, session);
          
          return session;
        }
        catch(MalformedURLException e)
        {
          System.out.println(e.getMessage());
          return null;
        }
      }
      else
      {
        return null;
      }
    }
  }

  public synchronized void disconnect(String user) throws RemoteException
  {
    SessionImpl session = (SessionImpl) properties.get(user);

    if(null != session)
    {
      session.closeDatabase();
      properties.remove(user);

      try
      {
        Naming.unbind("Przyklad4_" + user);
      }
      catch(Exception e)
      {
        System.out.println(e.getMessage());
      }
    }
    else
    {
      //do nothing
    }
  }
} 