package db.przyklad3;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;


public class SQLFrame extends JFrame
{
  SQLProcessor sqlProcessor = null;
  
  BorderLayout borderLayout = new BorderLayout();
  JToolBar toolBar = new JToolBar();
  JToggleButton connectButton = new JToggleButton();
  JPanel separator1 = new JPanel();
  JButton executeButton = new JButton();
  JPanel separator2 = new JPanel();
  JToggleButton autocommitButton = new JToggleButton();
  JButton commitButton = new JButton();
  JButton rollbackButton = new JButton();
  JPanel separator3 = new JPanel();
  JButton exitButton = new JButton();
  JButton clearButton = new JButton();
  JSplitPane splitPane = new JSplitPane();
  JScrollPane scrollPane1 = new JScrollPane();
  JScrollPane scrollPane2 = new JScrollPane();
  JTextArea commandTextArea = new JTextArea();
  JTextArea resultTextArea = new JTextArea();

  ImageIcon connectIcon = new ImageIcon("connect.gif");     
  ImageIcon executeIcon = new ImageIcon("execute.gif");     
  ImageIcon clearIcon = new ImageIcon("clear.gif");
  ImageIcon autocommitIcon = new ImageIcon("autocommit.gif");   
  ImageIcon commitIcon = new ImageIcon("commit.gif");
  ImageIcon rollbackIcon = new ImageIcon("rollback.gif");
  ImageIcon exitIcon = new ImageIcon("exit.gif");

  public SQLFrame()
  {
    try
    {
      jbInit();
      
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      SwingUtilities.updateComponentTreeUI(this);
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    
    setVisible(true);
  }

  public void setVisible(boolean visible)
  {
    super.setVisible(visible);

    if(!visible)
    {
      this.sqlProcessor.closeConnection();
      System.exit(0);
    }
  }

  public static void main(String[] args)
  {
    SQLFrame frame = new SQLFrame();
  }

  private void jbInit() throws Exception
  {
    this.sqlProcessor = new SQLProcessor("jdbc:interbase://pc183a/C:/Program Files/InterBase Corp/InterBase/bin/data/work.gdb");

    this.setTitle("SQL Frame");
    this.getContentPane().setLayout(borderLayout);
    this.setSize(700, 450);
    connectButton.setIcon(connectIcon);
    connectButton.setToolTipText("connect / disconnect");
    connectButton.setPreferredSize(new Dimension(25, 25));
    connectButton.setMaximumSize(new Dimension(25, 25));
    connectButton.setMinimumSize(new Dimension(25, 25));
    connectButton.setRequestFocusEnabled(false);
    connectButton.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        connectButton_actionPerformed(e);
      }
    });
    separator1.setAlignmentX((float) 0.0);
    separator1.setAlignmentY((float) 0.0);
    separator1.setMaximumSize(new Dimension(10, 25));
    separator1.setMinimumSize(new Dimension(10, 25));
    separator1.setPreferredSize(new Dimension(10, 25));
    executeButton.setMaximumSize(new Dimension(25, 25));
    executeButton.setMinimumSize(new Dimension(25, 25));
    executeButton.setPreferredSize(new Dimension(25, 25));
    executeButton.setRequestFocusEnabled(false);
    executeButton.setToolTipText("execute SQL statement");
    executeButton.setIcon(executeIcon);
    executeButton.addActionListener(new ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        executeButton_actionPerformed(e);
      }
    });
    separator2.setPreferredSize(new Dimension(10, 25));
    separator2.setMinimumSize(new Dimension(10, 25));
    separator2.setMaximumSize(new Dimension(10, 25));
    separator2.setAlignmentY((float) 0.0);
    separator2.setAlignmentX((float) 0.0);
    autocommitButton.setRequestFocusEnabled(false);
    autocommitButton.addActionListener(new ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        autocommitButton_actionPerformed(e);
      }
    });
    autocommitButton.setMinimumSize(new Dimension(25, 25));
    autocommitButton.setMaximumSize(new Dimension(25, 25));
    autocommitButton.setPreferredSize(new Dimension(25, 25));
    autocommitButton.setIcon(autocommitIcon);
    autocommitButton.setToolTipText("auto-commit");
    commitButton.setToolTipText("commit");
    commitButton.setIcon(commitIcon);
    commitButton.addActionListener(new ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        commitButton_actionPerformed(e);
      }
    });
    commitButton.setRequestFocusEnabled(false);
    commitButton.setPreferredSize(new Dimension(25, 25));
    commitButton.setMinimumSize(new Dimension(25, 25));
    commitButton.setMaximumSize(new Dimension(25, 25));
    rollbackButton.setToolTipText("rollback");
    rollbackButton.setIcon(rollbackIcon);
    rollbackButton.addActionListener(new ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        rollbackButton_actionPerformed(e);
      }
    });
    rollbackButton.setRequestFocusEnabled(false);
    rollbackButton.setPreferredSize(new Dimension(25, 25));
    rollbackButton.setMinimumSize(new Dimension(25, 25));
    rollbackButton.setMaximumSize(new Dimension(25, 25));
    separator3.setAlignmentX((float) 0.0);
    separator3.setAlignmentY((float) 0.0);
    separator3.setMaximumSize(new Dimension(10, 25));
    separator3.setMinimumSize(new Dimension(10, 25));
    separator3.setPreferredSize(new Dimension(10, 25));
    exitButton.setToolTipText("exit");
    exitButton.setIcon(exitIcon);
    exitButton.addActionListener(new ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        exitButton_actionPerformed(e);
      }
    });
    exitButton.setRequestFocusEnabled(false);
    exitButton.setPreferredSize(new Dimension(25, 25));
    exitButton.setMinimumSize(new Dimension(25, 25));
    exitButton.setMaximumSize(new Dimension(25, 25));
    splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
    splitPane.setRequestFocusEnabled(false);
    splitPane.setDividerSize(2);
    scrollPane1.setMinimumSize(new Dimension(200, 100));
    scrollPane1.setPreferredSize(new Dimension(100, 100));
    scrollPane2.setMinimumSize(new Dimension(100, 200));
    scrollPane2.setPreferredSize(new Dimension(100, 200));
    commandTextArea.setLineWrap(true);
    commandTextArea.setWrapStyleWord(true);
    resultTextArea.setEditable(false);
    resultTextArea.setRequestFocusEnabled(false);
    clearButton.setMaximumSize(new Dimension(25, 25));
    clearButton.setMinimumSize(new Dimension(25, 25));
    clearButton.setPreferredSize(new Dimension(25, 25));
    clearButton.setRequestFocusEnabled(false);
    clearButton.setToolTipText("clear command area");
    clearButton.setIcon(clearIcon);
    clearButton.addActionListener(new ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        clearButton_actionPerformed(e);
      }
    });
    this.getContentPane().add(toolBar, BorderLayout.NORTH);
    toolBar.add(connectButton, null);
    toolBar.add(separator1, null);
    toolBar.add(executeButton, null);
    toolBar.add(clearButton, null);
    toolBar.add(separator2, null);
    toolBar.add(autocommitButton, null);
    toolBar.add(commitButton, null);
    toolBar.add(rollbackButton, null);
    toolBar.add(separator3, null);
    toolBar.add(exitButton, null);
    this.getContentPane().add(splitPane, BorderLayout.CENTER);
    splitPane.add(scrollPane1, JSplitPane.TOP);
    scrollPane1.getViewport().add(commandTextArea, null);
    splitPane.add(scrollPane2, JSplitPane.BOTTOM);
    scrollPane2.getViewport().add(resultTextArea, null);

    setButtonsEnabled(false);
  }

  void setButtonsEnabled(boolean enabled)
  {
    this.executeButton.setEnabled(enabled);
    this.clearButton.setEnabled(enabled);
    this.autocommitButton.setEnabled(enabled);
    this.commitButton.setEnabled(enabled);
    this.rollbackButton.setEnabled(enabled);

    if(!enabled)
    {
      this.autocommitButton.setSelected(false);
    }
  }

  void connectButton_actionPerformed(ActionEvent e)
  {
    this.setCursor(Cursor.WAIT_CURSOR);

    if(connectButton.isSelected())
    {
      if(sqlProcessor.openConnection("SYSDBA","masterkey"))
      {
        setButtonsEnabled(true);
        sqlProcessor.setAutoCommit(false);
      }
      else
      {
        setButtonsEnabled(false);
        connectButton.setSelected(false);
      }
    }
    else
    {
      setButtonsEnabled(false);

      sqlProcessor.closeConnection();
    }

    this.setCursor(Cursor.DEFAULT_CURSOR);
  }

  void autocommitButton_actionPerformed(ActionEvent e)
  {   
    if(autocommitButton.isSelected())
    {
      this.commitButton.setEnabled(false);
      this.rollbackButton.setEnabled(false);

      this.sqlProcessor.commit();
      this.sqlProcessor.setAutoCommit(true);
    }
    else
    {
      this.commitButton.setEnabled(true);
      this.rollbackButton.setEnabled(true);
      
      this.sqlProcessor.setAutoCommit(false);
    }
  }

  void exitButton_actionPerformed(ActionEvent e)
  {
    this.setVisible(false);
  }

  void executeButton_actionPerformed(ActionEvent e)
  {
    String text = sqlProcessor.executeSQL(commandTextArea.getText());
    
    this.resultTextArea.moveCaretPosition(0);
    this.resultTextArea.insert(text + "\n", 0);
    this.resultTextArea.setCaretPosition(0);

    this.commandTextArea.setText("");
  }

  void commitButton_actionPerformed(ActionEvent e)
  {
    if(this.sqlProcessor.commit())
    {
      this.resultTextArea.insert("COMMIT;\n\n", 0);
    }
  }

  void rollbackButton_actionPerformed(ActionEvent e)
  {
    if(this.sqlProcessor.rollback())
    {
      this.resultTextArea.insert("ROLLBACK;\n\n", 0);
    }
  }

  void clearButton_actionPerformed(ActionEvent e)
  {
    this.commandTextArea.setText("");
  }
}