CREATE TABLE friends2_tab 
(
  friend_id INTEGER NOT NULL,
  lastname VARCHAR(50) NOT NULL,
  firstname VARCHAR(20) NOT NULL,
  birthdate DATE NOT NULL,
  sex CHAR(1) DEFAULT '?' NOT NULL,
  description VARCHAR(250),
  PRIMARY KEY (friend_id),
  CHECK (sex IN('?', 'F', 'M'))
);

CREATE GENERATOR friend_id_gen;

CREATE TRIGGER friend_id_trig FOR friends2_tab
BEFORE INSERT
AS
BEGIN
 friends2_tab.friend_id = GEN_ID(friend_id_gen, 1);
END;

CREATE PROCEDURE add_new_friend(lastname VARCHAR(50), firstname VARCHAR(20), birthdate DATE, sex CHAR(1))
AS
BEGIN
  INSERT INTO friends2_tab(lastname, firstname, birthdate, sex)
  VALUES(:lastname, :firstname, :birthdate, :sex);
END;

CREATE PROCEDURE add_description_by_id(friend_id INTEGER, description VARCHAR(250))
AS
BEGIN
  UPDATE friends2_tab
  SET description = :description
  WHERE friend_id = :friend_id;
END;

CREATE PROCEDURE get_description_by_id(id INTEGER)
RETURNS (descript VARCHAR(250))
AS
BEGIN
  SELECT description
  FROM friends2_tab
  WHERE friend_id = :id
  INTO :descript ;
END;


CREATE TABLE address_tab 
(
  address_id INTEGER NOT NULL,
  friend_id INTEGER NOT NULL,
  city VARCHAR(25) NOT NULL,
  street VARCHAR(25) NOT NULL,
  phone VARCHAR(10),
  PRIMARY KEY(address_id),
  FOREIGN KEY(friend_id) REFERENCES friends2_tab (friend_id) 
    ON DELETE CASCADE 
	ON UPDATE CASCADE
);

CREATE GENERATOR address_id_gen;

CREATE TRIGGER address_id_trig FOR address_tab
BEFORE INSERT
AS
BEGIN
 address_tab.address_id = GEN_ID(address_id_gen, 1);
END;

CREATE INDEX city_street_ind ON address_tab (city, street);

CREATE PROCEDURE add_new_address(friend_id INTEGER, city VARCHAR(25), street VARCHAR(25), phone VARCHAR(10))
AS
BEGIN
  INSERT INTO address_tab(friend_id, city, street, phone)
  VALUES(:friend_id, :city, :street, :phone);
END;
