/* 
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted.
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */
import java.lang.*;
import java.io.*;
import java.awt.*;
import java.applet.*;
import java.util.*;
import Display;
import java.net.*; 
/**
 * 
 *
 * @author      Siebe R. Brouwer
 * version      1.1, 13 october 1995
 */

public class LineApplet extends Applet {

    protected Display display;
    protected LineDiagram diagram;
    
    public void init() {
	String at = getParameter("filename");
	String fileName = (at != null) ? at : "lines.data";
	at = getParameter("dir");
	String dir = (at != null) ? at : "dataFiles/";
	at = getParameter("header");
	String header = (at != null) ? at : "BAR DIAGRAM";
	at = getParameter("xtext");
	String xText = (at != null) ? at : "x-axis";
	at = getParameter("ytext");
	String yText = (at != null) ? at : "y-axis";
	at = getParameter("vxbegin");
	int vXbegin = (at != null) ? Integer.valueOf(at).intValue() :0;
	at = getParameter("vxgap");
	int vXgap = (at != null) ? Integer.valueOf(at).intValue() :100;
	at = getParameter("vybegin");
	int vYbegin = (at != null) ? Integer.valueOf(at).intValue() :0;
	at = getParameter("vygap");
	int vYgap = (at != null) ? Integer.valueOf(at).intValue() : 100;
	at = getParameter("xgap");
	int xGap = (at != null) ? Integer.valueOf(at).intValue() : 50;
	at = getParameter("ygap");
        int yGap = (at != null) ? Integer.valueOf(at).intValue() : 50;
        setLayout(new BorderLayout());
	display = new Display(header,xText, yText, xGap, yGap);
	add("Center",display);	
	
        // create a new LineDiagram
	diagram = new LineDiagram(vXbegin, vYbegin, vXgap, vYgap, display);
	    	
	
	runDiagram(fileName, dir);
    }

    public void runDiagram(String fileName, String dir) {
	
        URL url = new URL(getDocumentBase(), dir + fileName);
	DataInputStream file = new DataInputStream(url.openStream());
    	
	String number;
	String line;
	number = nextLine(file);
	int nrOfLines = Integer.valueOf(number).intValue();
	int c[] = new int[3];
	String d[] = new String[3];
	StringTokenizer t;
	for(int i = 0; i < nrOfLines; i++) {
	    String index;
	    index=nextLine(file);
	    
	    line = nextLine(file);
	    t= new StringTokenizer(line,",");
	    String n=null;
	    int j = 0;
	    while(t.hasMoreTokens()) {
	    	n = t.nextToken().trim();
		c[j] = Integer.valueOf(n).intValue();	
		j++;
	    }
            number=nextLine(file);
	    int nrOfDots = Integer.valueOf(number.trim()).intValue();
	    	Color color = new Color(c[0], c[1], c[2]);
	    	diagram.createLine(color, index);
	    	for(int k = 0; k < nrOfDots; k++) {
		    line=nextLine(file);
		    t = new StringTokenizer(line,",");
		    j = 0;
		    while(t.hasMoreTokens()) {
			d[j] = t.nextToken().trim(); 	
		    	j++;
		    }
		    int x = Integer.valueOf(d[1]).intValue();
		    int y = Integer.valueOf(d[2]).intValue();
		    for(int l = 0; l < 3;l++) {
		    diagram.addDot(x, y, d[0], index);
	    	}
	    }
	}
    	display.drawDiagram(diagram);
    }
    
    /* is the String "line" empty or begins with an "#" 
     * then return true, else return false.
     */
    protected String nextLine(DataInputStream file) {
	String line = file.readLine().trim();
	while(line.startsWith("#") || line.length() == 0) {
	    line = file.readLine().trim();
	}
	return line;
    }    
}







