/* 
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted.
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

import java.lang.*; 
import java.io.InputStream;
import java.awt.*;
import java.net.*;
import java.util.*;
 
/**
 * A image loop applet, first raise smiles and then drop them
 *
 * @author      Siebe R. Brouwer
 * version      1.1, 29 September 1995
 */

class BarDiagram extends Diagram {
    
    protected Vector fields;
    protected Vector indexs;
    protected int indexNumber;
    protected Display display;
    protected int virtualYbegin;
    protected int virtualYgap;
    protected int yBegin;
    
    BarDiagram(Display d, int vYbegin, int vYgap) {
	display = d;	
	fields = new Vector();
	indexs = new Vector();
    	virtualYgap = vYgap;
	virtualYbegin = vYbegin;
	float i = (float)vYbegin / (float)vYgap;
	yBegin = (int)(i * display.yGap());
    	indexNumber = 0;
    }

    public void addIndex(String indexLabel, Color color) {
    	if(!hasIndex(indexLabel) && !fields.isEmpty()) {
	    indexs.addElement(new Index(indexLabel, color, indexNumber));
	    updateFields(indexNumber, color);
	    indexNumber++;
	}
    }

    public void addField(String label) {
	if(!hasField(label)) {
	    fields.addElement(new Field(label));
	}
    }
    public void addValue(int vHeight, String indexLabel, String fieldLabel) {
    	if(hasField(fieldLabel) && hasIndex(indexLabel)) {
	    int f = getField(fieldLabel);
	    int i = getIndex(indexLabel);
	    Index index = (Index)indexs.elementAt(i);
	    Field field = (Field)fields.elementAt(f);
	    
	    int indexNumber = index.indexNumber();
	    int height = convertYvalue(vHeight);
	    
	    field.updateBar(indexNumber, height); 
    	}
    }
    
    protected boolean hasField(String fieldLabel) {
    	for(Enumeration e = fields.elements();e.hasMoreElements() ; ) {
	    Field field= (Field)e.nextElement();
            if (field.label() == fieldLabel) {
	   	
		return true;
	    }
	}
	
	return false;
    }
    protected boolean hasIndex(String indexLabel) {
	for(Enumeration e = indexs.elements();e.hasMoreElements() ; ) {
	    Index index= (Index)e.nextElement();
            if (index.label() == indexLabel) {
	 
		return true;
	    }
	}
	
	return false;
    }
    
    protected int getField(String fieldLabel) {
	for(Enumeration e = fields.elements();e.hasMoreElements() ; ) {
	    Field field = (Field)e.nextElement();
            if (field.label() == fieldLabel) {
	   	return fields.indexOf(field);
	    }
	}
    	return -1;
    }
    protected int getIndex(String indexLabel) {
    	for(Enumeration e = indexs.elements();e.hasMoreElements() ; ) {
	    Index index= (Index)e.nextElement();
            if (index.label() == indexLabel) {
	   	return indexs.indexOf(index);
	    }
	}
    	return -1;
    }
    protected void updateFields(int indexNumber, Color color) {
	for(Enumeration e = fields.elements();e.hasMoreElements() ; ) {
	    Field field = (Field)e.nextElement();
            field.addBar(color);
	}
    }
    
    public void drawData(Graphics g, int gaps, int left, int moved) { 
	int xStart = display.xStart();
	int yStart = display.yStart();
	int xTop = display.xTop();
	int yTop = display.yTop();
	int xGap = display.xGap();
	int yGap = display.yGap();
	int xBegin = xStart + moved;
	int vYgap = virtualYbegin;
	int xIndex = xTop - ((xTop - xStart) / 3);
	int yIndex = 50;
	
	
	for(int i = yStart; i >= yTop; i -= yGap) {
	    g.drawString(Integer.toString(vYgap), xStart - 40, i);
	    vYgap += virtualYgap;
	}
	
	g.drawString("INDEX", xIndex, yIndex);
	yIndex+=5;
	g.drawLine(xIndex, yIndex, xIndex + 30, yIndex);
	yIndex +=15;

	for(Enumeration e = indexs.elements();e.hasMoreElements() ; ) {
	    Index index= (Index)e.nextElement();
	    index.drawIndex(g, xIndex, yIndex);	
	    yIndex += 15;
	}
	for(Enumeration e = fields.elements();e.hasMoreElements() ; ) {
	    Field field= (Field)e.nextElement();
	   
	    field.drawField(g, xBegin, xStart, yStart, xTop, yTop, xGap);
	    xBegin += xGap;	   
	}
    }
    
    protected int convertYvalue(float i) {
    	float j = (float)virtualYbegin / (float)virtualYgap;
	int yBegin = (int)(j * display.yGap());
	int yGap = display.yGap();
	float virtual = i / virtualYgap;
	virtual = virtual * yGap;
	return (int)(virtual - yBegin);
    }
}

    
class Field {
    
    protected String label;
    protected Vector bars;
    protected int depth;
    
    Field(String l) {
	label = l;
	depth = 0;
	bars = new Vector();
    }
    
    public void addBar(Color color) {
	depth++;
	bars.addElement(new Bar(0, color));
    }

    public void updateBar(int indexNumber, int height) {
	
	Bar bar= (Bar)bars.elementAt(indexNumber);
	bar.changeHeight(height);
    }
	
    public String label() {
	return label;
    }

    public void drawField(Graphics g, int xBegin, int xStart, int yStart, int xTop, int yTop,int xCap) {
	
	if(xBegin >= xStart && xBegin <= xTop) {
	    g.setColor(Color.black);
	    g.drawString(label, xBegin, yStart + 15);
	}
        int barLength; 
	xCap -= (depth * 2);
	barLength = depth > 0 ? (xCap / depth): xCap;
	int begin = xBegin;
	Graphics graphics = g.create();

	for(Enumeration e = bars.elements();e.hasMoreElements() ; ) {
	    graphics.clipRect(xStart+1, yTop, xTop - xStart, yStart - yTop);
	    Bar bar = (Bar)e.nextElement();
            int height = bar.height();
	    	    
	    graphics.setColor(Color.black);
	    graphics.drawRect(begin, yStart - height, barLength, height);
	    graphics.setColor(bar.color());
	    graphics.fillRect(begin+1, yStart - height +1, barLength -1, height -1);	
	    begin += barLength + 2;	
	} 
    }
}
    
class Index {
    
    protected String label;
    protected int indexNumber;
    protected Color color;

    Index(String l, Color c, int i) {
	label = l;
	indexNumber = i;
	color = c;
    }
    
    public String label() {
	return label;
    }
    public int indexNumber() {
    	return indexNumber;
    }
    public Color color() {
	return color;
    }
    public void drawIndex(Graphics g, int x, int y) {
    	g.setColor(Color.black);
	g.drawRect(x,y,5,5);
	g.setColor(color);
	g.fillRect(x+1,y+1,4,4);
	g.setColor(Color.black);
	g.drawString(label, x+10,y+5);
    }
}

class Bar {
    protected Color color;
    protected int height;
        
    Bar(int h, Color c) {
	height = h;
	color = c;
    }
    
    public Color color() {
	return color;
    }
    public int height() {
	return height;
    }
    public void changeHeight(int h) {
	height = h;
    }
    public void changeColor(Color c) {
    	color = c;
    }
}
