import java.awt.*;
import java.applet.*;

public class GraphicsApplet extends Applet implements Runnable {
    boolean	stopped = true;
    Thread	animator;
    int		cx = 0;
    int		cy = 0;
    Formula	formula;

    public void init() {
	Rectangle r = bounds();
	//formula = new Line(r, r.width - 50, 0, 1, 2);
	//formula = new Parabola(r, r.width - 50, 0);
	int xvalues[] = new int[4];
	int yvalues[] = new int[4];

	xvalues[0] = 0;
	yvalues[0] = 0;

	xvalues[1] = 50;
	yvalues[1] = 20;

	xvalues[2] = 100;
	yvalues[2] = 100;

	xvalues[3] = 50;
	yvalues[3] = 20;

	formula = new Path(r, xvalues, yvalues);
	animator = new Thread(this);
    }
    public void start() {
	if (! animator.isAlive()) {
	    animator.start();
	} else {
	    animator.resume();
	}
    }
    public void stop() {
	animator.suspend();
    }
    public void destroy() {
	animator.stop();
    }
    public void paint(Graphics g) {
	if (animator.isAlive()) {
	    g.setColor(Color.red);
	    g.drawRect(cx, cy, 50, 50);
	}
    }

    public void run() {
	try {
	    while (true) {
		Dimension d = formula.step();
		cx = d.width;
		cy = d.height;
		repaint();
		Thread.sleep(200);
	    }
	} catch (InterruptedException e) {
	    return;
	}
    }
}

abstract class Formula {
    Rectangle	bounds;
    int x = 0;
    int y = 0;

    protected Formula(Rectangle bounds) {
	this.bounds = bounds;
    }
    public abstract Dimension step();
}

class Line extends Formula {
    int m;
    int b;
    int maxStep;
    int minStep;

    public Line(Rectangle bounds, int maxStep, int minStep, int m, int b) {
	super(bounds);
	this.m = m;
	this.b = b;
	this.maxStep = maxStep;
	this.minStep = minStep;
    }

    public Dimension step() {
	x += b;
	y = (m * x) + b;
	if (x > maxStep || x < minStep) {
	    b *= -1;
	}
	return new Dimension(x, y);
    }
}

class Path extends Formula {
    int i = 0;
    int c = 1;
    int xvalues[];
    int yvalues[];
    public Path(Rectangle bounds, int xvalues[], int yvalues[]) {
	super(bounds);
	this.xvalues = xvalues;
	this.yvalues = yvalues;
    }
    public Dimension step() {
	Dimension d = new Dimension(xvalues[i], yvalues[i]);

	i += c;
	if (i == xvalues.length || i < 0) {
	    c *= -1;
	    i += c;
	}

	return d;
    }
}

class Parabola extends Formula {
    int c = 4;
    int mid;
    int maxStep;
    int minStep;

    public Parabola(Rectangle bounds, int maxStep, int minStep) {
	super(bounds);
	this.maxStep = maxStep;
	this.minStep = minStep;
	mid = bounds.width / 4;
	x = -mid;
    }
    public Dimension step() {
	x += c;
	y = (x*x) / 10;
	if ((x+(2*mid)) > maxStep || (x+(2*mid)) < minStep) {
	    c *= -1;
	}
	System.out.println((x+mid) + " " + x + ", " + y);
	return new Dimension(x + mid + mid, y);
    }
}
