import java.awt.*;
import java.applet.*;

public class GraphicsApplet extends Applet {
    Font   appFont;
    Color appColor;
    String appShape;
    String appText;
    Image		 image;

    public void init() {
	appFont = new Font("Helvetica",Font.BOLD,14);
	String arg = getParameter("COLOR");
	if (arg!= null) {
	    appColor = colorFromString(arg,Color.red);
	}
	appShape = getParameter("SHAPE");
	if (appShape == null) {
	    appShape = "Line";
	}
	appText = getParameter("TEXT");
	if (appText == null) {
	    appText = "Graphics";
	}
	arg = getParameter("IMAGE");
	if (arg == null) {
	    arg = "images/duke.gif";
	}
	image = getImage(getDocumentBase(), arg);
    }

    public void paint(Graphics g) {
	Dimension r = size();
	g.setColor(appColor);
	if (appShape.equalsIgnoreCase("line")) {
	    g.drawLine(0, 0, r.width, r.height);
	} else if (appShape.equalsIgnoreCase(
	    "rectangle")) {
	    g.drawRect(0, 0, r.width - 1, r.height - 1);
	} else if (appShape.equalsIgnoreCase("image")) {
	    g.drawImage(image,0,0,r.width,r.height,this);
	} else if(appShape.equalsIgnoreCase("string")){
	    g.setFont(appFont);
	    drawCenteredString(appText, appColor, g, r);
	}
    }

    public void drawCenteredString(String s,
				   Color color,
				   Graphics g,
				   Dimension r) {
	FontMetrics fm = g.getFontMetrics();
	int sWidth = fm.stringWidth(s);
	int sHeight = fm.getHeight();
	g.setColor(color);
	g.drawString(s,(r.width - sWidth)/2, (r.height - sHeight)/2);
    }

    public Color colorFromString(String s, Color defaultColor) {
	Integer i;
	try {
	    i = Integer.valueOf(s, 16);
	    return new Color(i.intValue());
	} catch (NumberFormatException e) {
	    if (s.equalsIgnoreCase("red")) {
		return Color.red;
	    } else if (s.equalsIgnoreCase("green")) {
		return Color.green;
	    } else if (s.equalsIgnoreCase("blue")) {
		return Color.blue;
	    } else if (s.equalsIgnoreCase("black")) {
		return Color.black;
	    } else if (s.equalsIgnoreCase("white")) {
		return Color.white;
	    } else {
		return defaultColor;
	    }
	}
    }
}

