/*
 * %W% %E% Bob Weisblatt
 *
 * Copyright (c) 1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.io.InputStream;
import java.awt.*;
import java.net.*;

/**
 * A simple java.applet.Applet class to play an image loop.  The "img" tag parameter
 * indicates what image loop to play.
 *
 * @author 	Bob Weisblatt (major thievery from jag, maybe wholesale is a better word.)
 * @version 	1.07f, 19 Jan 1995
 */

public class JackhammerDuke extends java.applet.Applet implements Runnable {
    /**
     * The current loop slot.
     */
    int seqslot = 0;

    /**
     * The number of images
     */
    int nimgs = 4;

    /**
     * A strip of 4 images.
     */
    Image imgs;

    /**
     * The directory or URL from which the images are loaded
     */
    String dir;

    /**
     * The thread animating the images.
     */
    Thread kicker = null;

    /**
     * The length of the pause between revs.lkj 
     */
    int pause;

    /**
     * The current x position.
     */
    double x;

    int imgsWidth = 328;
    int imgsHeight = 90;

    /**
     * Run the image loop. This method is called by class Thread.
     * @see oak.lang.Thread
     *
     * getDocumentBase() is the URL of the document in which the applet is
     * embedded. It shouldn't be changed.
     *
     * dir is in net.www.html.Tag but is undocumented.
     */
    public void run() {
	Thread.currentThread().setPriority(Thread.MIN_PRIORITY);

	imgs = getImage(getCodeBase(), "images/jack.gif");

	if (imgs != null) {
	    x = (size().width - imgsWidth/nimgs) / 2;
	    while (size().width > 0 && size().height > 0 && kicker != null) {
		if (seqslot == 0) {
		    play(getCodeBase(), "audio/jackhammer-short.au");
		}

		repaint();
		try {Thread.sleep((seqslot == sequence.length -1) ? 500 : 100);} catch (InterruptedException e){}
		seqslot = (seqslot + 1) % sequence.length;
	    }
	}

    }

    private int sequence[] = { 2, 1, 0, 1, 0, 1, 0, 1, 2, 1, 0, 2, 0, 1, 0, 2, 3};

    /**
     * Paint the current frame.
     */
    boolean erase;

    public void update(Graphics g) {
	if (erase || (sequence[seqslot] == 3)) {
	    g.setColor(Color.lightGray);
	    g.fillRect(0, 0, size().width, size().height);
	    erase = false;
	}
	paint(g);
    }
    public void paint(Graphics g) {
	int loopslot = sequence[seqslot];
	if ((imgs != null) && (loopslot < nimgs)) {
	    int w = imgsWidth / nimgs;
	    x = Math.max(0, Math.min(size().width - w, x + Math.random() * 4 - 2));
	    
	    g.clipRect((int)x, 0, w, imgsHeight);
	    g.drawImage(imgs, (int)x - loopslot * w, 0, this);
	    erase = (loopslot == 3);
	}
    }

    /**
     * Start the applet by forking an animation thread.
     */
    public void start() {
	if (kicker == null) {
	    kicker = new Thread(this);
	    kicker.start();
	}
    }

    /**
     * Stop the applet. The thread will exit because kicker is set to null.
     */
    public void stop() {
	kicker = null;
    }
}
