/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* serp.java -- draws the 1-7th itteration of Serpinski triangle        */
/*----------------------------------------------------------------------*/
/*                    Jim Morey - morey@math.ubc.ca - July              */
/*----------------------------------------------------------------------*/

import java.io.InputStream;
import java.awt.*;
import java.net.*;

public class serp extends java.applet.Applet implements Runnable{
  private int size,max_lev,max_turn,step,lev;  
  private int turn[];
  private double TT=3.1415f;
  private int MAX = 7;
  private int scr_x, scr_y, scr_x_last, scr_y_last;
  private double x,y,len,angle;
  Color gcol = null;
  Graphics    offscreen;
  Image       im;
  Thread kicker = null;
  boolean im_ready=false;

  /* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - */
  public void init() {
    try{
      size = Integer.parseInt(getParameter("size"));
    } catch(Exception e) { size = 200; }

    try{
      max_lev = Integer.parseInt(getParameter("levels"));
    } catch(Exception e) { max_lev = 3; }

    String colour = getParameter("colour");
    if (colour != null){
      if (colour.equals("white")) gcol = java.awt.Color.white;
      else if (colour.equals("red")) gcol = java.awt.Color.red;
      else if (colour.equals("green")) gcol = java.awt.Color.green;
      else if (colour.equals("blue")) gcol = java.awt.Color.blue;
    }
    else gcol = java.awt.Color.black;

    max_turn = 3;
    
    resize(size+2, (int)(size*Math.sin(TT/3))+1);
  }

  /* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - */
  public void start() {
    if (kicker == null) {
      kicker = new Thread(this);
      kicker.start();
    }
  }

  /* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - */
  public void stop() {
    kicker = null;
  }

  /* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - */
  public void run() {                                                         
    Thread.currentThread().setPriority(Thread.MIN_PRIORITY);

    /* .. get a blank window to draw the triangle .. */ 
    im = createImage(size().width, size().height);
    offscreen = im.getGraphics();
    offscreen.setColor(Color.lightGray);
    offscreen.fillRect(0, 0, size().width, size().height);
    if (gcol != null) offscreen.setColor(gcol);
    else offscreen.setColor(Color.black);
    im_ready = true;

    turn = new int[MAX];
    int speed[] = {256,128,64,32,16,8,8,8,8,8,8,8};

    /* .. This part seems like a logo program since the drawing is done 
          without lifting the pen.  The angle, len, x and y tell you everything
          about the "turtle" including it's size.  After taking a step the 
          turtle changes it's attributes according to the algorithm and the 
          stack (turn & lev).  .. */
    len = size/4;
    angle = TT/3;
    x = size/2+1 ;
    y = 1;
    scr_x_last = (int)x;
    scr_y_last = (int) (size().height - y);
    scr_x = 0;
    scr_y = 0;
    step = 0;
    lev = 0;
    turn[lev] = 0;

    /* .. draw triangle .. */
    offscreen.drawLine(size,scr_y_last,scr_x_last,scr_y_last);
    repaint();
try {Thread.sleep(speed[0]);} catch (InterruptedException e){}
    offscreen.drawLine(size,scr_y_last,scr_x_last,1);
    repaint();
try {Thread.sleep(speed[0]);} catch (InterruptedException e){}
    offscreen.drawLine(1,scr_y_last,scr_x_last,1);
    repaint();
    offscreen.drawLine(1,scr_y_last,scr_x_last,scr_y_last);
try {Thread.sleep(speed[0]);} catch (InterruptedException e){}
    repaint();

    while (kicker != null && max_lev != 0 ) {
      /* .. take a step .. */
      x = len*Math.cos(angle) + x;
      y = len*Math.sin(angle) + y;
      scr_x = (int)x;
      scr_y = (int)(size().height - y);

      /* .. add the next line to the picture .. */
      offscreen.drawLine(scr_x,scr_y,scr_x_last,scr_y_last);
      repaint();

      scr_x_last = scr_x;
      scr_y_last = scr_y;

      if (step == 0){  /* .. the first step .. */
        if (lev == max_lev-1){ /* .. finished getting smaller? .. */
          step = 1; 
        } else{ /* .. turn in and shrink .. */
          lev = lev + 1;
          turn[lev] = 0;
          angle = angle - (2*TT)/3;
          len = len/2;
        }
      } else{  /* .. the second step .. */
        if (turn[lev] == max_turn-1){
          if (lev == 0) { /* .. back at the start? .. */
            stop();
          } else { /* .. get bigger & turn back (same as turn in) .. */
            lev = lev - 1;
            len = len * 2;
            angle = angle - (2*TT)/3;
          }
        } else{ /* .. make a turn (this is a turn out) .. */
          step = 0; 
          turn[lev] = turn[lev] + 1;
          angle = angle + (2*TT)/3;
        } 
      }    
try {Thread.sleep(speed[max_lev]);} catch (InterruptedException e){}
    }
  }
                        
  /* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - */
  public void paint(Graphics g) {
    update(g);
  }
  public void update(Graphics g) {
    if (im_ready) g.drawImage(im, 0, 0, this);
  }

  /* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - */
  public boolean mouseDown(java.awt.Event evt, int x, int y) {
    /* .. restart the program with a different level (or depth)  .. */
    stop();
    max_lev = max_lev+1;
    if (max_lev == MAX) max_lev = 0;

try {Thread.sleep(300);  /* .. to make sure the program stops .. */} catch (InterruptedException e){}
    start();
    return true;
  }

}



